% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRtwoD.R
\name{spatial2d}
\alias{spatial2d}
\title{Spatial 2D Reasoning Items}
\usage{
spatial2d(items, wd = NULL, view = "2D", seed = NULL, degree = 360)
}
\arguments{
\item{items}{The number of items to generate.}

\item{wd}{This is the working directory to save the figures in. If not provided, the file will be saved in the current working directory.}

\item{view}{There are three options ("2D", "top", "bottom") to view the display figure from different prespectives.}

\item{seed}{To generate the same set of item(s) on the local computer.}

\item{degree}{This allows you to change the rotation of the display figure by increasing or decreasing the value.}
}
\value{
\describe{
\item{ans}{Return the matrix that generates the display figure and answer.}
\item{mirror}{Return the matrix that generates a mirror figure.}
\item{dist3}{Return the matrix that generates the distractor without the first square.}
\item{dist4}{Return the matrix that generates the distractor that adds an extra square.}
    }
}
\description{
This function generates a 2 or 3 dimensional display figure with 4 2D distractors and 1 2D answer.
}
\details{
To see the 3D display figure, change the view argument to either 'top' or 'bottom'. For 3D figures, some of the cubes may be hidden in sight. Hence, the 2D answer may not seem correct. So one would need to rotate the display figure several times to ensure that none of the cubes are hidden. The rotation can be done by changing the degree value in the function. To ensure that the same image is generated again, please provide a seed value. Currently angle of the view from the top and the bottom is fixed. It may be better to generate one item at a time for the 3D displayed figures. This is not a problem for 2D items.

By default the actual answer is always at half of the display polar coordinates. The display figure polar coordinates by default is 360. Increasing the degrees will make the figure rotate clock-wise and decreasing the degrees will make the figure rotate anti-clockwise.

 4 distractors are generated. 2 of the generated distractors are a mirror image of the displayed figure. The difference in the polar coordinates between the two distractors are fixed at 120. The third distractor is a figure wihout the first square that is generated by the display item. The fourth distractor is a figure with an additional square added to the distractor. Currently, the polar coordinates are fixed for the third and fourth distractor as well.

There are occassions where a mirror distractor will not work. In such an instance, the item together with the distractors will not be useful for the test. Hence, it will be a good item to remove the item from the test. It is also a good idea to keep track on your local computer which seed it is so you can avoid having to regenerate the item. That is where the seed will come in handy. The seed correspond to the number position of which the item is created. For example, if you want to recreate item/figure number 19, then all you need do so is to keep the argument = 1, but change the argument seed = 19. This will re generate the number 19th item. However, the created figures will use item 1 as the file name. So be sure to check the file name if not it will be written over once you try to generate the second item with a different seed.
}
\examples{

#2D display figure
spatial2d(items=1, wd=NULL,view="2D", seed=NULL, degree=360)

#wd<- "~/desktop"
#3D display figure (top view)
#spatial2d(items=1, wd=wd,view="top", seed=1, degree=320)

#3D display figure (bottom view)
#spatial2d(items=1, wd=wd,view="bottom", seed=1, degree=320)
}
\author{
Aiden Loe
}
\seealso{
\code{\link{lisy}}, \code{\link{arith}}, \code{\link{spatial3d}}
}

