% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_agd.R
\name{read_agd}
\alias{read_agd}
\title{Read an ActiGraph agd file}
\usage{
read_agd(
  file,
  return = c("data", "settings", "both"),
  tz = "UTC",
  verbose = FALSE
)
}
\arguments{
\item{file}{character. Path to the agd file}

\item{return}{character. The desired elements to return (see details)}

\item{tz}{character. The desired timezone}

\item{verbose}{logical. Print updates to console?}
}
\value{
the desired output
}
\description{
Read an ActiGraph agd file
}
\details{
The agd is made up of a \code{settings} element and a \code{data}
  element. The former is likely only necessary for debugging, and so the
  default is to return only the \code{data} element. Both \code{settings} and
  \code{data} are in data frame format. If \code{return = "both"}, they are
  given as a list.
}
\examples{
agd_file <- system.file("extdata", "example1sec.agd", package = "AGread")
read_agd(agd_file, "both")
}
\seealso{
\href{https://github.com/actigraph/ActiLifeManual/blob/master/docs/appendix.rst}{ActiGraph documentation}
}
