/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.dev.BiffViewer;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;

public class EFBiffViewer {
    String file;

    public void run() throws IOException {
        NPOIFSFileSystem fs = new NPOIFSFileSystem(new File(this.file), true);
        InputStream din = BiffViewer.getPOIFSInputStream(fs);
        HSSFRequest req = new HSSFRequest();
        req.addListenerForAllRecords(new HSSFListener(){

            @Override
            public void processRecord(Record rec) {
                System.out.println(rec.toString());
            }
        });
        HSSFEventFactory factory = new HSSFEventFactory();
        factory.processEvents(req, din);
        din.close();
        fs.close();
    }

    public void setFile(String file) {
        this.file = file;
    }

    public static void main(String[] args) {
        if (args.length == 1 && !args[0].equals("--help")) {
            try {
                EFBiffViewer viewer = new EFBiffViewer();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("EFBiffViewer");
            System.out.println("Outputs biffview of records based on HSSFEventFactory");
            System.out.println("usage: java org.apache.poi.hssf.dev.EBBiffViewer filename");
        }
    }
}

