## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(mycolorsTB)

## ----fig.width=7, fig.height=5, out.width="100%"------------------------------
# View the main palette with lineage names
view_palette(palette_name = "mycolors")

# View the pathogenomics palette
view_palette(palette_name = "pathogenomics")

## ----fig.width=7, fig.height=4, out.width="100%"------------------------------
library(ggplot2)

# To ensure the vignette builds correctly, we define the lineage names locally.
# The functions from the package will use the actual package data.
local_mycolors <- c("A1"="#d1ae00", "A2"="#8ef5c8", "A3"="#73c2ff", "A4"="#ff9cdb",
                    "L1"="#ff3091", "L2"="#001aff", "L3"="#8a0bd2", "L4"="#ff0000",
                    "L5"="#995200", "L6"="#1eb040", "L7"="#fbff00", "L8"="#ff9d00",
                    "L9"="#37ff30", "L10"="#8fbda1")

# Example data using the local color vector
data <- data.frame(
  x = factor(names(local_mycolors), levels = names(local_mycolors)),
  y = abs(rnorm(14, mean = 10, sd = 3)),
  group = names(local_mycolors)
)

# Create a bar plot using the fill scale
ggplot(data, aes(x = x, y = y, fill = group)) +
  geom_bar(stat = "identity") +
  scale_fill_mycolors() +
  theme_minimal() +
  labs(title = "Bar Plot with scale_fill_mycolors()", x = "Lineage", y = "Value") +
  theme(axis.text.x = element_text(angle = 45, hjust = 1))

## ----fig.width=7, fig.height=4, message=FALSE, warning=FALSE, out.width="100%"----
tree_text <- "(L8,((L1,(L7,(L4,(L2,L3)))),(L5,((A2,(A3,A4)),(A1,(L10,(L6,L9)))))));"
plot_tb_tree(tree_text)

## ----fig.width=7, fig.height=4, message=FALSE, warning=FALSE, out.width="100%"----
plot_tb_cladogram(tree_text)

## ----fig.width=7, fig.height=5, out.width="100%"------------------------------
# Generate 25 colors from the 'classicTB' palette
my_custom_colors <- tb_palette(25, "classicTB")

# Create a plot to display the interpolated colors
plot(1:25, 
     rep(1, 25),
     col = my_custom_colors, 
     pch = 19, 
     cex = 5,
     xlab = "",
     ylab = "",
     axes = FALSE,
     main = "25 Interpolated Colors from 'classicTB' Palette")

