/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.global.Occurrence;
import choco.cp.solver.constraints.integer.channeling.ReifiedLargeOr;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class NorNode
extends AbstractBoolNode {
    public NorNode(INode ... subt) {
        super(subt, NodeType.NOR);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (INode subtree : this.subtrees) {
            if (!((BoolNode)((Object)subtree)).checkTuple(tuple)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        if (vs.length > 1) {
            IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
            IntDomainVar notv = s.createBooleanVar(StringUtils.randomName());
            IntDomainVar[] vars = ArrayUtils.append({v}, vs);
            s.post(new ReifiedLargeOr(vars, s.getEnvironment()));
            s.post(s.neq((IntExp)v, (IntExp)notv));
            return notv;
        }
        IntDomainVar notv = s.createBooleanVar(StringUtils.randomName());
        s.post(s.neq((IntExp)vs[0], (IntExp)notv));
        return notv;
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length + 1];
        for (int i = 0; i < vs.length - 1; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        vs[vs.length - 1] = new IntDomainVarImpl(s, StringUtils.randomName(), 6, this.subtrees.length, this.subtrees.length);
        return new Occurrence(vs, 0, true, true, s.getEnvironment());
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder st = new StringBuilder("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" and ");
        }
        st.append(this.subtrees[i].pretty()).append(')');
        return st.toString();
    }
}

