/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.buffer.tdouble.DoubleBuffer;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tdouble.AbstractDoubleIntMap;
import cern.colt.map.tdouble.OpenDoubleIntHashMap;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;
import cern.jet.stat.tdouble.DoubleDescriptive;
import hep.aida.tdouble.bin.DoubleBinBinFunction1D;
import hep.aida.tdouble.bin.QuantileDoubleBin1D;

public class DynamicDoubleBin1D
extends QuantileDoubleBin1D {
    private static final long serialVersionUID = 1L;
    protected DoubleArrayList elements = null;
    protected DoubleArrayList sortedElements = null;
    protected boolean fixedOrder = false;
    protected boolean isSorted = true;
    protected boolean isIncrementalStatValid = true;
    protected boolean isSumOfInversionsValid = true;
    protected boolean isSumOfLogarithmsValid = true;

    public DynamicDoubleBin1D() {
        this.clear();
        this.elements = new DoubleArrayList();
        this.sortedElements = new DoubleArrayList(0);
        this.fixedOrder = false;
        this.hasSumOfLogarithms = true;
        this.hasSumOfInversions = true;
    }

    public synchronized void add(double d) {
        this.elements.add(d);
        this.invalidateAll();
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        this.elements.addAllOfFromTo(doubleArrayList, n, n2);
        this.invalidateAll();
    }

    public synchronized double aggregate(DoubleDoubleFunction doubleDoubleFunction, DoubleFunction doubleFunction) {
        int n = this.size();
        if (n == 0) {
            return Double.NaN;
        }
        double d = doubleFunction.apply(this.elements.getQuick(n - 1));
        int n2 = n - 1;
        while (--n2 >= 0) {
            d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements.getQuick(n2)));
        }
        return d;
    }

    public synchronized void clear() {
        super.clear();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.sortedElements != null) {
            this.sortedElements.clear();
        }
        this.validateAll();
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
    }

    public synchronized Object clone() {
        DynamicDoubleBin1D dynamicDoubleBin1D = (DynamicDoubleBin1D)super.clone();
        if (this.elements != null) {
            dynamicDoubleBin1D.elements = dynamicDoubleBin1D.elements.copy();
        }
        if (this.sortedElements != null) {
            dynamicDoubleBin1D.sortedElements = dynamicDoubleBin1D.sortedElements.copy();
        }
        return dynamicDoubleBin1D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double correlation(DynamicDoubleBin1D dynamicDoubleBin1D) {
        DynamicDoubleBin1D dynamicDoubleBin1D2 = dynamicDoubleBin1D;
        synchronized (dynamicDoubleBin1D2) {
            return this.covariance(dynamicDoubleBin1D) / (this.standardDeviation() * dynamicDoubleBin1D.standardDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double covariance(DynamicDoubleBin1D dynamicDoubleBin1D) {
        DynamicDoubleBin1D dynamicDoubleBin1D2 = dynamicDoubleBin1D;
        synchronized (dynamicDoubleBin1D2) {
            if (this.size() != dynamicDoubleBin1D.size()) {
                throw new IllegalArgumentException("both bins must have same size");
            }
            double d = 0.0;
            int n = this.size();
            while (--n >= 0) {
                d += this.elements.getQuick(n) * dynamicDoubleBin1D.elements.getQuick(n);
            }
            double d2 = (d - this.sum() * dynamicDoubleBin1D.sum() / (double)this.size()) / (double)this.size();
            return d2;
        }
    }

    public synchronized DoubleArrayList elements() {
        return this.elements_unsafe().copy();
    }

    protected synchronized DoubleArrayList elements_unsafe() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object object) {
        if (!(object instanceof DynamicDoubleBin1D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DynamicDoubleBin1D dynamicDoubleBin1D = (DynamicDoubleBin1D)object;
        double[] dArray = this.sortedElements_unsafe().elements();
        DynamicDoubleBin1D dynamicDoubleBin1D2 = dynamicDoubleBin1D;
        synchronized (dynamicDoubleBin1D2) {
            double[] dArray2 = dynamicDoubleBin1D.sortedElements_unsafe().elements();
            int n = this.size();
            return DynamicDoubleBin1D.includes(dArray, dArray2, 0, n, 0, n) && DynamicDoubleBin1D.includes(dArray2, dArray, 0, n, 0, n);
        }
    }

    private static boolean includes(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (dArray2[n3] < dArray[n]) {
                return false;
            }
            if (dArray[n] < dArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public synchronized void frequencies(DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        DoubleDescriptive.frequencies(this.sortedElements_unsafe(), doubleArrayList, intArrayList);
    }

    private synchronized AbstractDoubleIntMap frequencyMap() {
        OpenDoubleIntHashMap openDoubleIntHashMap = new OpenDoubleIntHashMap();
        int n = this.size();
        while (--n >= 0) {
            double d = this.elements.getQuick(n);
            ((AbstractDoubleIntMap)openDoubleIntHashMap).put(d, 1 + ((AbstractDoubleIntMap)openDoubleIntHashMap).get(d));
        }
        return openDoubleIntHashMap;
    }

    public int getMaxOrderForSumOfPowers() {
        return Integer.MAX_VALUE;
    }

    public int getMinOrderForSumOfPowers() {
        return Integer.MIN_VALUE;
    }

    protected void invalidateAll() {
        this.isSorted = false;
        this.isIncrementalStatValid = false;
        this.isSumOfInversionsValid = false;
        this.isSumOfLogarithmsValid = false;
    }

    public synchronized boolean isRebinnable() {
        return true;
    }

    public synchronized double max() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.max;
    }

    public synchronized double min() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.min;
    }

    public synchronized double moment(int n, double d) {
        return DoubleDescriptive.moment(this.elements, n, d);
    }

    public synchronized double quantile(double d) {
        return DoubleDescriptive.quantile(this.sortedElements_unsafe(), d);
    }

    public synchronized double quantileInverse(double d) {
        return DoubleDescriptive.quantileInverse(this.sortedElements_unsafe(), d);
    }

    public DoubleArrayList quantiles(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.quantiles(this.sortedElements_unsafe(), doubleArrayList);
    }

    public synchronized boolean removeAllOf(DoubleArrayList doubleArrayList) {
        boolean bl = this.elements.removeAll(doubleArrayList);
        if (bl) {
            this.clearAllMeasures();
            this.invalidateAll();
            this.size = 0;
            if (this.fixedOrder) {
                this.sortedElements.removeAll(doubleArrayList);
                this.isSorted = true;
            }
        }
        return bl;
    }

    public synchronized void sample(int n, boolean bl, DoubleRandomEngine doubleRandomEngine, DoubleBuffer doubleBuffer) {
        if (doubleRandomEngine == null) {
            doubleRandomEngine = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        doubleBuffer.clear();
        if (!bl) {
            if (n > this.size()) {
                throw new IllegalArgumentException("n must be less than or equal to size()");
            }
            DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n, this.size(), doubleRandomEngine);
            int n2 = n;
            while (--n2 >= 0) {
                if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
                doubleBuffer.add(this.elements.getQuick(n2));
            }
        } else {
            DoubleUniform doubleUniform = new DoubleUniform(doubleRandomEngine);
            int n3 = this.size();
            int n4 = n;
            while (--n4 >= 0) {
                doubleBuffer.add(this.elements.getQuick(doubleUniform.nextIntFromTo(0, n3 - 1)));
            }
            doubleBuffer.flush();
        }
    }

    public synchronized DynamicDoubleBin1D sampleBootstrap(DynamicDoubleBin1D dynamicDoubleBin1D, int n, DoubleRandomEngine doubleRandomEngine, DoubleBinBinFunction1D doubleBinBinFunction1D) {
        if (doubleRandomEngine == null) {
            doubleRandomEngine = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        int n2 = 1000;
        int n3 = this.size();
        int n4 = dynamicDoubleBin1D.size();
        DynamicDoubleBin1D dynamicDoubleBin1D2 = new DynamicDoubleBin1D();
        DoubleBuffer doubleBuffer = dynamicDoubleBin1D2.buffered(Math.min(n2, n3));
        DynamicDoubleBin1D dynamicDoubleBin1D3 = new DynamicDoubleBin1D();
        DoubleBuffer doubleBuffer2 = dynamicDoubleBin1D3.buffered(Math.min(n2, n4));
        DynamicDoubleBin1D dynamicDoubleBin1D4 = new DynamicDoubleBin1D();
        DoubleBuffer doubleBuffer3 = dynamicDoubleBin1D4.buffered(Math.min(n2, n));
        int n5 = n;
        while (--n5 >= 0) {
            dynamicDoubleBin1D2.clear();
            dynamicDoubleBin1D3.clear();
            this.sample(n3, true, doubleRandomEngine, doubleBuffer);
            dynamicDoubleBin1D.sample(n4, true, doubleRandomEngine, doubleBuffer2);
            doubleBuffer3.add(doubleBinBinFunction1D.apply(dynamicDoubleBin1D2, dynamicDoubleBin1D3));
        }
        doubleBuffer3.flush();
        return dynamicDoubleBin1D4;
    }

    public void setFixedOrder(boolean bl) {
        this.fixedOrder = bl;
    }

    public synchronized int size() {
        return this.elements.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            if (this.fixedOrder) {
                this.sortedElements.clear();
                this.sortedElements.addAllOfFromTo(this.elements, 0, this.elements.size() - 1);
                this.sortedElements.sort();
            } else {
                this.updateIncrementalStats();
                this.invalidateAll();
                this.elements.sort();
                this.isIncrementalStatValid = true;
            }
            this.isSorted = true;
        }
    }

    public synchronized DoubleArrayList sortedElements() {
        return this.sortedElements_unsafe().copy();
    }

    protected synchronized DoubleArrayList sortedElements_unsafe() {
        this.sort();
        if (this.fixedOrder) {
            return this.sortedElements;
        }
        return this.elements;
    }

    public synchronized void standardize(double d, double d2) {
        DoubleDescriptive.standardize(this.elements, d, d2);
        this.clearAllMeasures();
        this.invalidateAll();
        this.size = 0;
    }

    public synchronized double sum() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum;
    }

    public synchronized double sumOfInversions() {
        if (!this.isSumOfInversionsValid) {
            this.updateSumOfInversions();
        }
        return this.sumOfInversions;
    }

    public synchronized double sumOfLogarithms() {
        if (!this.isSumOfLogarithmsValid) {
            this.updateSumOfLogarithms();
        }
        return this.sumOfLogarithms;
    }

    public synchronized double sumOfPowers(int n) {
        if (n >= -1 && n <= 2) {
            return super.sumOfPowers(n);
        }
        return DoubleDescriptive.sumOfPowers(this.elements, n);
    }

    public synchronized double sumOfSquares() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum_xx;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList = new IntArrayList();
        this.frequencies(doubleArrayList, intArrayList);
        if (doubleArrayList.size() < 100) {
            stringBuffer.append("Distinct elements: " + doubleArrayList + "\n");
            stringBuffer.append("Frequencies: " + intArrayList + "\n");
        } else {
            stringBuffer.append("Distinct elements & frequencies not printed (too many).");
        }
        return stringBuffer.toString();
    }

    public synchronized void trim(int n, int n2) {
        DoubleArrayList doubleArrayList = this.sortedElements();
        this.clear();
        this.addAllOfFromTo(doubleArrayList, n, doubleArrayList.size() - 1 - n2);
    }

    public synchronized double trimmedMean(int n, int n2) {
        return DoubleDescriptive.trimmedMean(this.sortedElements_unsafe(), this.mean(), n, n2);
    }

    public synchronized void trimToSize() {
        this.elements.trimToSize();
        this.sortedElements.clear();
        this.sortedElements.trimToSize();
        if (this.fixedOrder) {
            this.isSorted = false;
        }
    }

    protected void updateIncrementalStats() {
        double[] dArray = new double[]{this.min, this.max, this.sum, this.sum_xx};
        DoubleDescriptive.incrementalUpdate(this.elements, this.size, this.elements.size() - 1, dArray);
        this.min = dArray[0];
        this.max = dArray[1];
        this.sum = dArray[2];
        this.sum_xx = dArray[3];
        this.isIncrementalStatValid = true;
        this.size = this.elements.size();
    }

    protected void updateSumOfInversions() {
        this.sumOfInversions = DoubleDescriptive.sumOfInversions(this.elements, 0, this.size() - 1);
        this.isSumOfInversionsValid = true;
    }

    protected void updateSumOfLogarithms() {
        this.sumOfLogarithms = DoubleDescriptive.sumOfLogarithms(this.elements, 0, this.size() - 1);
        this.isSumOfLogarithmsValid = true;
    }

    protected void validateAll() {
        this.isSorted = true;
        this.isIncrementalStatValid = true;
        this.isSumOfInversionsValid = true;
        this.isSumOfLogarithmsValid = true;
    }
}

