/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.ref.DoubleHistogram1D;
import hep.aida.tdouble.ref.DoubleHistogram2D;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public class Test {
    public static void main(String[] stringArray) {
        Random random = new Random();
        DoubleHistogram1D doubleHistogram1D = new DoubleHistogram1D("AIDA 1D Histogram", 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram1D.fill(random.nextGaussian());
        }
        DoubleHistogram2D doubleHistogram2D = new DoubleHistogram2D("AIDA 2D Histogram", 40, -3.0, 3.0, 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram2D.fill(random.nextGaussian(), random.nextGaussian());
        }
        Test.writeAsXML(doubleHistogram1D, "aida1.xml");
        Test.writeAsXML(doubleHistogram2D, "aida2.xml");
        Test.writeAsXML(doubleHistogram2D.projectionX(), "projectionX.xml");
        Test.writeAsXML(doubleHistogram2D.projectionY(), "projectionY.xml");
    }

    private static void writeAsXML(DoubleIHistogram1D doubleIHistogram1D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            printWriter.println("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
            printWriter.println("<plotML>");
            printWriter.println("<plot>");
            printWriter.println("<dataArea>");
            printWriter.println("<data1d>");
            printWriter.println("<bins1d title=\"" + doubleIHistogram1D.title() + "\">");
            for (int i = 0; i < doubleIHistogram1D.xAxis().bins(); ++i) {
                printWriter.println(doubleIHistogram1D.binEntries(i) + "," + doubleIHistogram1D.binError(i));
            }
            printWriter.println("</bins1d>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
            printWriter.print(" min=\"" + doubleIHistogram1D.xAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + doubleIHistogram1D.xAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + doubleIHistogram1D.xAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.println("<statistics>");
            printWriter.println("<statistic name=\"Entries\" value=\"" + doubleIHistogram1D.entries() + "\"/>");
            printWriter.println("<statistic name=\"Underflow\" value=\"" + doubleIHistogram1D.binEntries(-2) + "\"/>");
            printWriter.println("<statistic name=\"Overflow\" value=\"" + doubleIHistogram1D.binEntries(-1) + "\"/>");
            if (!Double.isNaN(doubleIHistogram1D.mean())) {
                printWriter.println("<statistic name=\"Mean\" value=\"" + doubleIHistogram1D.mean() + "\"/>");
            }
            if (!Double.isNaN(doubleIHistogram1D.rms())) {
                printWriter.println("<statistic name=\"RMS\" value=\"" + doubleIHistogram1D.rms() + "\"/>");
            }
            printWriter.println("</statistics>");
            printWriter.println("</data1d>");
            printWriter.println("</dataArea>");
            printWriter.println("</plot>");
            printWriter.println("</plotML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeAsXML(DoubleIHistogram2D doubleIHistogram2D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            printWriter.println("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
            printWriter.println("<plotML>");
            printWriter.println("<plot>");
            printWriter.println("<dataArea>");
            printWriter.println("<data2d type=\"xxx\">");
            printWriter.println("<bins2d title=\"" + doubleIHistogram2D.title() + "\" xSize=\"" + doubleIHistogram2D.xAxis().bins() + "\" ySize=\"" + doubleIHistogram2D.yAxis().bins() + "\">");
            for (int i = 0; i < doubleIHistogram2D.xAxis().bins(); ++i) {
                for (int j = 0; j < doubleIHistogram2D.yAxis().bins(); ++j) {
                    printWriter.println(doubleIHistogram2D.binEntries(i, j) + "," + doubleIHistogram2D.binError(i, j));
                }
            }
            printWriter.println("</bins2d>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
            printWriter.print(" min=\"" + doubleIHistogram2D.xAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + doubleIHistogram2D.xAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + doubleIHistogram2D.xAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
            printWriter.print(" min=\"" + doubleIHistogram2D.yAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + doubleIHistogram2D.yAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + doubleIHistogram2D.yAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.println("</data2d>");
            printWriter.println("</dataArea>");
            printWriter.println("</plot>");
            printWriter.println("</plotML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

