/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.Float27Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix3D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_3D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_3D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix3D
extends FloatMatrix3D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_3D fft3;
    private FloatDCT_3D dct3;
    private FloatDST_3D dst3;
    private FloatDHT_3D dht3;
    protected float[] elements;

    public DenseFloatMatrix3D(float[][][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, fArray.length == 0 ? 0 : (fArray[0].length == 0 ? 0 : fArray[0][0].length));
        this.assign(fArray);
    }

    public DenseFloatMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new float[n * n2 * n3];
    }

    public DenseFloatMatrix3D(int n, int n2, int n3, float[] fArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = fArray;
        this.isNoView = !bl;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseFloatMatrix3D.this.elements[n + n4 * DenseFloatMatrix3D.this.sliceStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    f = floatFloatFunction.apply(f, floatFunction.apply(DenseFloatMatrix3D.this.elements[n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride + k * DenseFloatMatrix3D.this.columnStride]));
                                }
                                n2 = 0;
                            }
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        f = floatFloatFunction.apply(f, floatFunction.apply(this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride]));
                    }
                    n6 = 0;
                }
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatProcedure floatProcedure) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = DenseFloatMatrix3D.this.elements[n + n4 * DenseFloatMatrix3D.this.sliceStride];
                        float f2 = 0.0f;
                        if (floatProcedure.apply(f)) {
                            f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    f = DenseFloatMatrix3D.this.elements[n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride + k * DenseFloatMatrix3D.this.columnStride];
                                    if (floatProcedure.apply(f)) {
                                        f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                                    }
                                    n2 = 0;
                                }
                            }
                        }
                        return Float.valueOf(f2);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            float f2 = this.elements[n];
            if (floatProcedure.apply(f2)) {
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        f2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (floatProcedure.apply(f2)) {
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        n6 = 0;
                    }
                }
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            return Float.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        final int n2 = (int)this.index(0, 0, 0);
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n3 = Math.min(n3, this.slices);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseFloatMatrix3D.this.elements[n2 + nArray[n5] * DenseFloatMatrix3D.this.sliceStride + nArray2[n5] * DenseFloatMatrix3D.this.rowStride + nArray3[n5] * DenseFloatMatrix3D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            float f2 = DenseFloatMatrix3D.this.elements[n2 + nArray[i] * DenseFloatMatrix3D.this.sliceStride + nArray2[i] * DenseFloatMatrix3D.this.rowStride + nArray3[i] * DenseFloatMatrix3D.this.columnStride];
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n2 + nArray[0] * this.sliceStride + nArray2[0] * this.rowStride + nArray3[0] * this.columnStride]);
            for (int i = 1; i < n; ++i) {
                float f2 = this.elements[n2 + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride];
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        if (!(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            return super.aggregate(floatMatrix3D, floatFloatFunction, floatFloatFunction2);
        }
        this.checkShape(floatMatrix3D);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)floatMatrix3D.index(0, 0, 0);
        final int n3 = floatMatrix3D.sliceStride();
        final int n4 = floatMatrix3D.rowStride();
        final int n5 = floatMatrix3D.columnStride();
        final float[] fArray = (float[])floatMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int n6 = n + n8 * DenseFloatMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        float f = floatFloatFunction2.apply(DenseFloatMatrix3D.this.elements[n6], fArray[n22]);
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride + k * DenseFloatMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    f = floatFloatFunction.apply(f, floatFloatFunction2.apply(DenseFloatMatrix3D.this.elements[n6], fArray[n22]));
                                }
                                n32 = 0;
                            }
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFloatFunction2.apply(this.getQuick(0, 0, 0), floatMatrix3D.getQuick(0, 0, 0));
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.elements[n11], fArray[n12]));
                    }
                    n10 = 0;
                }
            }
        }
        return f;
    }

    public FloatMatrix3D assign(final FloatFunction floatFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    DenseFloatMatrix3D.this.elements[n2] = floatFunction.apply(DenseFloatMatrix3D.this.elements[n2]);
                                    n2 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = floatFunction.apply(this.elements[n6]);
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    float f = DenseFloatMatrix3D.this.elements[n2];
                                    if (floatProcedure.apply(f)) {
                                        DenseFloatMatrix3D.this.elements[n2] = floatFunction.apply(f);
                                    }
                                    n2 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        float f = this.elements[n6];
                        if (floatProcedure.apply(f)) {
                            this.elements[n6] = floatFunction.apply(f);
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure floatProcedure, final float f) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    float f2 = DenseFloatMatrix3D.this.elements[n2];
                                    if (floatProcedure.apply(f2)) {
                                        DenseFloatMatrix3D.this.elements[n2] = f;
                                    }
                                    n2 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        float f2 = this.elements[n6];
                        if (floatProcedure.apply(f2)) {
                            this.elements[n6] = f;
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float f) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    DenseFloatMatrix3D.this.elements[n2] = f;
                                    n2 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = f;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[] fArray) {
        if ((long)fArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n3;
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n4 = this.slices / n;
                for (n3 = 0; n3 < n; ++n3) {
                    final int n5 = n3 * n4;
                    final int n6 = n3 == n - 1 ? this.slices : n5 + n4;
                    futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n5 * DenseFloatMatrix3D.this.rows * DenseFloatMatrix3D.this.columns;
                            for (int i = n5; i < n6; ++i) {
                                for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                    int n22 = n2 + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                        DenseFloatMatrix3D.this.elements[n22] = fArray[n++];
                                        n22 += DenseFloatMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n3 = 0; n3 < n; ++n3) {
                        futureArray[n3].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n7 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n8] = fArray[n7++];
                            n8 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[][][] fArray) {
        if (fArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + fArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.slices : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseFloatMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                float[][] fArray3 = fArray[i];
                                if (fArray3.length != DenseFloatMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + DenseFloatMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                    float[] fArray2 = fArray3[j];
                                    if (fArray2.length != DenseFloatMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + DenseFloatMatrix3D.this.columns());
                                    }
                                    System.arraycopy(fArray2, 0, DenseFloatMatrix3D.this.elements, n, DenseFloatMatrix3D.this.columns);
                                    n += DenseFloatMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    float[][] fArray2 = fArray[i];
                    if (fArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        float[] fArray3 = fArray2[j];
                        if (fArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(fArray3, 0, this.elements, n6, this.columns);
                        n6 += this.columns;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n8;
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n9 = this.slices / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.slices : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n10; i < n11; ++i) {
                                float[][] fArray3 = fArray[i];
                                if (fArray3.length != DenseFloatMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + DenseFloatMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                    int n = n7 + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                    float[] fArray2 = fArray3[j];
                                    if (fArray2.length != DenseFloatMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + DenseFloatMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                        DenseFloatMatrix3D.this.elements[n] = fArray2[k];
                                        n += DenseFloatMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    float[][] fArray4 = fArray[i];
                    if (fArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n7 + i * this.sliceStride + j * this.rowStride;
                        float[] fArray5 = fArray4[j];
                        if (fArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n12] = fArray5[k];
                            n12 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(FloatMatrix3D floatMatrix3D) {
        FloatMatrix3D floatMatrix3D2;
        if (!(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            super.assign(floatMatrix3D);
            return this;
        }
        DenseFloatMatrix3D denseFloatMatrix3D = (DenseFloatMatrix3D)floatMatrix3D;
        if (denseFloatMatrix3D == this) {
            return this;
        }
        this.checkShape(denseFloatMatrix3D);
        if (this.haveSharedCells(denseFloatMatrix3D)) {
            floatMatrix3D2 = denseFloatMatrix3D.copy();
            if (!(floatMatrix3D2 instanceof DenseFloatMatrix3D)) {
                super.assign(floatMatrix3D);
                return this;
            }
            denseFloatMatrix3D = floatMatrix3D2;
        }
        floatMatrix3D2 = denseFloatMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseFloatMatrix3D.isNoView) {
            System.arraycopy(((DenseFloatMatrix3D)floatMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)((DenseFloatMatrix3D)floatMatrix3D2).index(0, 0, 0);
        final int n4 = ((DenseFloatMatrix3D)floatMatrix3D2).sliceStride;
        final int n5 = ((DenseFloatMatrix3D)floatMatrix3D2).rowStride;
        final int n6 = ((DenseFloatMatrix3D)floatMatrix3D2).columnStride;
        final float[] fArray = ((DenseFloatMatrix3D)floatMatrix3D2).elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n7;
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n8 = this.slices / n;
            for (n7 = 0; n7 < n; ++n7) {
                final int n9 = n7 * n8;
                final int n10 = n7 == n - 1 ? this.slices : n9 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                int n22 = n3 + i * n4 + j * n5;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    DenseFloatMatrix3D.this.elements[n] = fArray[n22];
                                    n += DenseFloatMatrix3D.this.columnStride;
                                    n22 += n6;
                                }
                            }
                        }
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n; ++n7) {
                    futureArray[n7].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n11 = n2 + i * this.sliceStride + j * this.rowStride;
                    int n12 = n3 + i * n4 + j * n5;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n11] = fArray[n12];
                        n11 += this.columnStride;
                        n12 += n6;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction) {
        if (!(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            super.assign(floatMatrix3D, floatFloatFunction);
            return this;
        }
        this.checkShape(floatMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)floatMatrix3D.index(0, 0, 0);
        final int n3 = floatMatrix3D.sliceStride();
        final int n4 = floatMatrix3D.rowStride();
        final int n5 = floatMatrix3D.columnStride();
        final float[] fArray = (float[])floatMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    DenseFloatMatrix3D.this.elements[n6] = floatFloatFunction.apply(DenseFloatMatrix3D.this.elements[n6], fArray[n22]);
                                    n6 += DenseFloatMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = floatFloatFunction.apply(this.elements[n10], fArray[n11]);
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (!(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            super.assign(floatMatrix3D, floatFloatFunction);
            return this;
        }
        this.checkShape(floatMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)floatMatrix3D.index(0, 0, 0);
        final int n3 = floatMatrix3D.sliceStride();
        final int n4 = floatMatrix3D.rowStride();
        final int n5 = floatMatrix3D.columnStride();
        final float[] fArray = (float[])floatMatrix3D.elements();
        int n6 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n7 = Math.min(n7, this.slices);
            Future[] futureArray = new Future[n7];
            int n8 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? n6 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            int n6 = n + nArray[i] * DenseFloatMatrix3D.this.sliceStride + nArray2[i] * DenseFloatMatrix3D.this.rowStride + nArray3[i] * DenseFloatMatrix3D.this.columnStride;
                            int n22 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                            DenseFloatMatrix3D.this.elements[n6] = floatFloatFunction.apply(DenseFloatMatrix3D.this.elements[n6], fArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n6; ++i) {
                int n11 = n + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride;
                int n12 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                this.elements[n11] = floatFloatFunction.apply(this.elements[n11], fArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            n3 = Math.min(n3, this.slices);
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    if (DenseFloatMatrix3D.this.elements[n22] != 0.0f) {
                                        ++n;
                                    }
                                    n22 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.elements[n8] != 0.0f) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public void dct2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).dct2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).dct2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new FloatDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.forward(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dct3.forward((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).dht2();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).dht2();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new FloatDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.forward(this.elements);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dht3.forward((float[])floatMatrix3D.elements());
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).dst2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).dst2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new FloatDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.forward(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dst3.forward((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realForward(this.elements);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.fft3.realForward((float[])floatMatrix3D.elements());
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseFComplexMatrix3D getFft2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix3D.viewSlice(i).assign(((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).getFft2());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                denseFComplexMatrix3D.viewSlice(i).assign(((DenseFloatMatrix2D)this.viewSlice(i)).getFft2());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix3D;
    }

    public DenseFComplexMatrix3D getFft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        final int n2 = this.rows * this.columns;
        final int n3 = this.columns;
        final float[] fArray = this.isNoView ? this.elements : (float[])this.copy().elements();
        final float[] fArray2 = denseFComplexMatrix3D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            int n5 = this.slices / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.slices : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n = i * n2 + j * n3;
                                System.arraycopy(fArray, n, fArray2, n, DenseFloatMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = i * n2 + j * n3;
                    System.arraycopy(fArray, n8, fArray2, n8, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(fArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix3D;
    }

    public DenseFComplexMatrix3D getIfft2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix3D.viewSlice(i).assign(((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).getIfft2(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                denseFComplexMatrix3D.viewSlice(i).assign(((DenseFloatMatrix2D)this.viewSlice(i)).getIfft2(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix3D;
    }

    public DenseFComplexMatrix3D getIfft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        final int n2 = this.rows * this.columns;
        final int n3 = this.columns;
        final float[] fArray = denseFComplexMatrix3D.elements();
        final float[] fArray2 = this.isNoView ? this.elements : (float[])this.copy().elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            int n5 = this.slices / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.slices : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n = i * n2 + j * n3;
                                System.arraycopy(fArray2, n, fArray, n, DenseFloatMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = i * n2 + j * n3;
                    System.arraycopy(fArray2, n8, fArray, n8, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(fArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix3D;
    }

    public float[] getMaxLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            float[][] fArray = new float[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        float f = DenseFloatMatrix3D.this.elements[n + n8 * DenseFloatMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    float f2 = DenseFloatMatrix3D.this.elements[n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride + k * DenseFloatMatrix3D.this.columnStride];
                                    if (!(f < f2)) continue;
                                    f = f2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new float[]{f, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    fArray[n6] = (float[])futureArray[n6].get();
                }
                f = fArray[0][0];
                n2 = (int)fArray[0][1];
                n3 = (int)fArray[0][2];
                n4 = (int)fArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (!(f < fArray[n6][0])) continue;
                    f = fArray[n6][0];
                    n2 = (int)fArray[n6][1];
                    n3 = (int)fArray[n6][2];
                    n4 = (int)fArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        float f2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (!(f < f2)) continue;
                        f = f2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new float[]{f, n2, n3, n4};
    }

    public float[] getMinLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            float[][] fArray = new float[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        float f = DenseFloatMatrix3D.this.elements[n + n5 * DenseFloatMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    float f2 = DenseFloatMatrix3D.this.elements[n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride + k * DenseFloatMatrix3D.this.columnStride];
                                    if (!(f > f2)) continue;
                                    f = f2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new float[]{f, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    fArray[n6] = (float[])futureArray[n6].get();
                }
                f = fArray[0][0];
                n2 = (int)fArray[0][1];
                n3 = (int)fArray[0][2];
                n4 = (int)fArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (!(f > fArray[n6][0])) continue;
                    f = fArray[n6][0];
                    n2 = (int)fArray[n6][1];
                    n3 = (int)fArray[n6][2];
                    n4 = (int)fArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        float f2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (!(f > f2)) continue;
                        f = f2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new float[]{f, n2, n3, n4};
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.elements[n2];
                    if (f < 0.0f) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        floatArrayList.add(f);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.elements[n2];
                    if (f != 0.0f) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        floatArrayList.add(f);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.elements[n2];
                    if (f > 0.0f) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        floatArrayList.add(f);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public float getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    public void idct2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).idct2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).idct2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new FloatDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.inverse(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dct3.inverse((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).idht2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).idht2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new FloatDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.inverse(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dht3.inverse((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(i)).idst2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseFloatMatrix2D)this.viewSlice(i)).idst2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new FloatDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.inverse(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.dst3.inverse((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realInverse(this.elements, bl);
        } else {
            FloatMatrix3D floatMatrix3D = this.copy();
            this.fft3.realInverse((float[])floatMatrix3D.elements(), bl);
            this.assign((float[])floatMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public FloatMatrix3D like(int n, int n2, int n3) {
        return new DenseFloatMatrix3D(n, n2, n3);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new DenseFloatMatrix2D(n, n2);
    }

    public void setQuick(int n, int n2, int n3, float f) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = f;
    }

    public float[][][] toArray() {
        final float[][][] fArray = new float[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n3 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[][] fArray3 = fArray[i];
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                float[] fArray2 = fArray3[j];
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    fArray2[k] = DenseFloatMatrix3D.this.elements[n];
                                    n += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray2 = fArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n2 + i * this.sliceStride + j * this.rowStride;
                    float[] fArray3 = fArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        fArray3[k] = this.elements[n6];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return fArray;
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseFloatMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseFloatMatrix1D;
    }

    public void zAssign27Neighbors(FloatMatrix3D floatMatrix3D, Float27Function float27Function) {
        if (!(floatMatrix3D instanceof DenseFloatMatrix3D)) {
            super.zAssign27Neighbors(floatMatrix3D, float27Function);
            return;
        }
        if (float27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(floatMatrix3D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseFloatMatrix3D denseFloatMatrix3D = (DenseFloatMatrix3D)floatMatrix3D;
        int n3 = this.sliceStride;
        int n4 = this.rowStride;
        int n5 = denseFloatMatrix3D.rowStride;
        int n6 = this.columnStride;
        int n7 = denseFloatMatrix3D.columnStride;
        float[] fArray = this.elements;
        float[] fArray2 = denseFloatMatrix3D.elements;
        if (fArray == null || fArray2 == null) {
            throw new InternalError();
        }
        for (int i = 1; i < this.slices - 1; ++i) {
            int n8 = (int)this.index(i, 1, 1);
            int n9 = (int)denseFloatMatrix3D.index(i, 1, 1);
            for (int j = 1; j < n; ++j) {
                int n10 = n8 - n3 - n4 - n6;
                int n11 = n10 + n4;
                int n12 = n11 + n4;
                int n13 = n10 + n3;
                int n14 = n13 + n4;
                int n15 = n14 + n4;
                int n16 = n13 + n3;
                int n17 = n16 + n4;
                int n18 = n17 + n4;
                float f = fArray[n10];
                float f2 = fArray[n10 += n6];
                float f3 = fArray[n11];
                float f4 = fArray[n11 += n6];
                float f5 = fArray[n12];
                float f6 = fArray[n12 += n6];
                float f7 = fArray[n13];
                float f8 = fArray[n13 += n6];
                float f9 = fArray[n14];
                float f10 = fArray[n14 += n6];
                float f11 = fArray[n15];
                float f12 = fArray[n15 += n6];
                float f13 = fArray[n16];
                float f14 = fArray[n16 += n6];
                float f15 = fArray[n17];
                float f16 = fArray[n17 += n6];
                float f17 = fArray[n18];
                float f18 = fArray[n18 += n6];
                int n19 = n9;
                for (int k = 1; k < n2; ++k) {
                    float f19 = fArray[n10 += n6];
                    float f20 = fArray[n11 += n6];
                    float f21 = fArray[n12 += n6];
                    float f22 = fArray[n13 += n6];
                    float f23 = fArray[n14 += n6];
                    float f24 = fArray[n15 += n6];
                    float f25 = fArray[n16 += n6];
                    float f26 = fArray[n17 += n6];
                    float f27 = fArray[n18 += n6];
                    fArray2[n19] = float27Function.apply(f, f2, f19, f3, f4, f20, f5, f6, f21, f7, f8, f22, f9, f10, f23, f11, f12, f24, f13, f14, f25, f15, f16, f26, f17, f18, f27);
                    n19 += n7;
                    f = f2;
                    f2 = f19;
                    f3 = f4;
                    f4 = f20;
                    f5 = f6;
                    f6 = f21;
                    f7 = f8;
                    f8 = f22;
                    f9 = f10;
                    f10 = f23;
                    f11 = f12;
                    f12 = f24;
                    f13 = f14;
                    f14 = f25;
                    f15 = f16;
                    f16 = f26;
                    f17 = f18;
                    f18 = f27;
                }
                n8 += n4;
                n9 += n5;
            }
        }
    }

    public float zSum() {
        float f = 0.0f;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseFloatMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseFloatMatrix3D.this.sliceStride + j * DenseFloatMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseFloatMatrix3D.this.columns; ++k) {
                                    f += DenseFloatMatrix3D.this.elements[n2];
                                    n2 += DenseFloatMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    f += ((Float)futureArray[n3].get()).floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        f += this.elements[n7];
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return f;
    }

    protected boolean haveSharedCellsRaw(FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D instanceof SelectedDenseFloatMatrix3D) {
            SelectedDenseFloatMatrix3D selectedDenseFloatMatrix3D = (SelectedDenseFloatMatrix3D)floatMatrix3D;
            return this.elements == selectedDenseFloatMatrix3D.elements;
        }
        if (floatMatrix3D instanceof DenseFloatMatrix3D) {
            DenseFloatMatrix3D denseFloatMatrix3D = (DenseFloatMatrix3D)floatMatrix3D;
            return this.elements == denseFloatMatrix3D.elements;
        }
        return false;
    }

    protected FloatMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseFloatMatrix2D(n, n2, this.elements, n3, n4, n5, n6, true);
    }

    protected FloatMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseFloatMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

