/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.DiagonalMatrix;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.SymmetricMatrix;

public class FactorOperator
extends AbstractAdaptableOperator {
    private static final String FACTOR_OPERATOR = "factorOperator";
    private LatentFactorModel LFM;
    private MatrixParameter diffusionPrecision;
    double[][] precision;
    double[] mean;
    double[] midMean;
    private int numFactors;
    private boolean randomScan;
    private double scaleFactor;

    public FactorOperator(LatentFactorModel latentFactorModel, double d, boolean bl, DiagonalMatrix diagonalMatrix, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.scaleFactor = d2;
        this.LFM = latentFactorModel;
        this.setWeight(d);
        this.randomScan = bl;
        this.diffusionPrecision = diagonalMatrix;
        this.setupParameters();
    }

    private void setupParameters() {
        if (this.numFactors != this.LFM.getFactorDimension()) {
            this.numFactors = this.LFM.getFactorDimension();
            this.mean = new double[this.numFactors];
            this.midMean = new double[this.numFactors];
            this.precision = new double[this.numFactors][this.numFactors];
        }
    }

    private void getPrecision(double[][] dArray) {
        MatrixParameterInterface matrixParameterInterface = this.LFM.getLoadings();
        MatrixParameter matrixParameter = this.LFM.getColumnPrecision();
        int n = matrixParameterInterface.getRowDimension();
        int n2 = matrixParameterInterface.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d = 0.0;
                for (int k = j; k < n2; ++k) {
                    d += matrixParameterInterface.getParameterValue(i, k) * matrixParameterInterface.getParameterValue(j, k) * matrixParameter.getParameterValue(k, k);
                }
                if (i == j) {
                    dArray[i][j] = d + this.diffusionPrecision.getParameterValue(i, j);
                    continue;
                }
                dArray[i][j] = d;
                dArray[j][i] = d;
            }
        }
    }

    private void getMean(int n, double[][] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        double d;
        int n3;
        MatrixParameterInterface matrixParameterInterface = this.LFM.getScaledData();
        MatrixParameter matrixParameter = this.LFM.getColumnPrecision();
        MatrixParameterInterface matrixParameterInterface2 = this.LFM.getLoadings();
        for (n3 = 0; n3 < matrixParameterInterface2.getRowDimension(); ++n3) {
            d = 0.0;
            for (n2 = n3; n2 < matrixParameterInterface2.getColumnDimension(); ++n2) {
                d += matrixParameterInterface2.getParameterValue(n3, n2) * matrixParameter.getParameterValue(n2, n2) * matrixParameterInterface.getParameterValue(n2, n);
            }
            dArray2[n3] = d;
        }
        for (n3 = 0; n3 < this.numFactors; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < this.numFactors; ++n2) {
                d += dArray[n3][n2] * dArray2[n2];
            }
            dArray3[n3] = d;
        }
    }

    private void copy(double[] dArray, int n) {
        Parameter parameter = this.LFM.getFactors().getParameter(n);
        for (int i = 0; i < parameter.getSize(); ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        parameter.fireParameterChangedEvent();
    }

    public int getStepCount() {
        return 0;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public String getOperatorName() {
        return FACTOR_OPERATOR;
    }

    public void randomDraw(int n, double[][] dArray) {
        double[] dArray2 = MultivariateNormalDistribution.nextMultivariateNormalVariance(this.LFM.getFactors().getParameter(n).getParameterValues(), dArray, this.scaleFactor);
        this.copy(dArray2, n);
    }

    @Override
    public double doOperation() {
        int n;
        this.setupParameters();
        this.getPrecision(this.precision);
        double[][] dArray = new SymmetricMatrix(this.precision).inverse().toComponents();
        if (this.randomScan) {
            n = MathUtils.nextInt(this.LFM.getFactors().getColumnDimension());
            this.randomDraw(n, dArray);
        }
        for (n = 0; n < this.LFM.getFactors().getColumnDimension(); ++n) {
            this.randomDraw(n, dArray);
        }
        this.LFM.getFactors().fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }
}

