/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class LogCtmcRatesFromMatrixMatrixProductParameter
extends Parameter.Abstract
implements VariableListener {
    private final MatrixParameter lhs;
    private final MatrixParameter rhs;
    private final int dim;
    private final int[][] map;
    private Bounds<Double> bounds;

    public LogCtmcRatesFromMatrixMatrixProductParameter(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        assert (matrixParameter.getRowDimension() == matrixParameter2.getColumnDimension());
        assert (matrixParameter2.getColumnDimension() == matrixParameter2.getRowDimension());
        this.lhs = matrixParameter;
        this.rhs = matrixParameter2;
        this.dim = matrixParameter.getRowDimension();
        this.map = this.makeMap(this.dim);
        matrixParameter.addVariableListener(this);
        matrixParameter2.addVariableListener(this);
        Parameter.CONNECTED_PARAMETER_SET.add(matrixParameter);
        Parameter.CONNECTED_PARAMETER_SET.add(matrixParameter2);
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public void setDimension(int n) {
        this.throwError("setDimension()");
    }

    @Override
    protected void storeValues() {
        this.lhs.storeParameterValues();
        this.rhs.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.lhs.restoreParameterValues();
        this.rhs.restoreVariableValues();
    }

    @Override
    protected void acceptValues() {
        this.lhs.acceptParameterValues();
        this.rhs.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        this.throwError("adoptValues");
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = this.map[n][0];
        int n3 = this.map[n][1];
        double d = 0.0;
        for (int i = 0; i < this.lhs.getColumnDimension(); ++i) {
            d += this.lhs.getParameterValue(n2, i) * this.rhs.getParameterValue(i, n3);
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.throwError("setParameterValue()");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.throwError("setParameterValueQuietly()");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.throwError("setParameterValueNotifyChangedAll()");
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    private void throwError(String string) throws RuntimeException {
        throw new RuntimeException("Object " + this.getId() + " is a deterministic function. Calling " + string + " is not allowed");
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            String string = "product." + this.lhs.getId() + "." + this.rhs.getId();
            this.setId(string);
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        this.throwError("addDimension");
    }

    @Override
    public double removeDimension(int n) {
        this.throwError("removeDimension");
        return Double.NaN;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent();
    }

    private int[][] makeMap(int n) {
        int n2;
        int n3;
        int[][] nArrayArray = new int[n * (n - 1) / 2][];
        int n4 = 0;
        for (n3 = 1; n3 < n; ++n3) {
            n2 = n3 + 2;
            while (n2 < n) {
                nArrayArray[n4++] = new int[]{n3, n2++};
            }
        }
        for (n3 = 1; n3 < n; ++n3) {
            n2 = n3 + 1;
            while (n2 < n) {
                nArrayArray[n4++] = new int[]{n2++, n3};
            }
        }
        return nArrayArray;
    }
}

