/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.heuristics;

import choco.kernel.common.TimeCacheThread;
import choco.kernel.common.opres.heuristics.IHeuristic;

public abstract class AbstractHeuristic
implements IHeuristic {
    private int objective;
    private boolean hasSearched = false;
    private double time;

    @Override
    public void reset() {
        this.hasSearched = false;
        this.time = 0.0;
        this.objective = Integer.MAX_VALUE;
    }

    @Override
    public boolean isObjectiveOptimal() {
        return false;
    }

    @Override
    public int getIterationCount() {
        return this.hasSearched() ? 1 : 0;
    }

    @Override
    public int getSolutionCount() {
        return this.hasSearched() ? 1 : 0;
    }

    @Override
    public final void execute() {
        this.time = -TimeCacheThread.currentTimeMillis;
        this.objective = this.apply();
        this.time += (double)TimeCacheThread.currentTimeMillis;
        this.time /= 1000.0;
        this.hasSearched = true;
    }

    public final void executeQuick() {
        this.objective = this.apply();
        this.hasSearched = true;
    }

    protected abstract int apply();

    public final int getNumberOfBins() {
        return this.objective;
    }

    @Override
    public final Number getObjectiveValue() {
        return this.objective;
    }

    @Override
    public final double getTimeCount() {
        return this.time;
    }

    @Override
    public final boolean hasSearched() {
        return this.hasSearched;
    }

    @Override
    public boolean existsSolution() {
        return this.hasSearched();
    }

    @Override
    public String solutionToString() {
        return null;
    }
}

