/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.Float27Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DProcedure;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FloatMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected FloatMatrix3D() {
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = n; k < FloatMatrix3D.this.columns; ++k) {
                                    f = floatFloatFunction.apply(f, floatFunction.apply(FloatMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        f = floatFloatFunction.apply(f, floatFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatProcedure floatProcedure) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = FloatMatrix3D.this.getQuick(n3, 0, 0);
                        float f2 = 0.0f;
                        if (floatProcedure.apply(f)) {
                            f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = n; k < FloatMatrix3D.this.columns; ++k) {
                                    f = FloatMatrix3D.this.getQuick(i, j, k);
                                    if (floatProcedure.apply(f)) {
                                        f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                                    }
                                    n = 0;
                                }
                            }
                        }
                        return Float.valueOf(f2);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            float f2 = this.getQuick(0, 0, 0);
            if (floatProcedure.apply(f2)) {
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        f2 = this.getQuick(i, j, k);
                        if (floatProcedure.apply(f2)) {
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        n5 = 0;
                    }
                }
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            return Float.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(FloatMatrix3D.this.getQuick(nArray[n4], nArray2[n4], nArray3[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            float f2 = FloatMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.getQuick(nArray[0], nArray2[0], nArray3[0]));
            for (int i = 1; i < n; ++i) {
                float f2 = this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(final FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        this.checkShape(floatMatrix3D);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFloatFunction2.apply(FloatMatrix3D.this.getQuick(n3, 0, 0), floatMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = n; k < FloatMatrix3D.this.columns; ++k) {
                                    f = floatFloatFunction.apply(f, floatFloatFunction2.apply(FloatMatrix3D.this.getQuick(i, j, k), floatMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFloatFunction2.apply(this.getQuick(0, 0, 0), floatMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.getQuick(i, j, k), floatMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return f;
    }

    public FloatMatrix3D assign(final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, floatFunction.apply(FloatMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, floatFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    float f = FloatMatrix3D.this.getQuick(i, j, k);
                                    if (!floatProcedure.apply(f)) continue;
                                    FloatMatrix3D.this.setQuick(i, j, k, floatFunction.apply(f));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float f = this.getQuick(i, j, k);
                        if (!floatProcedure.apply(f)) continue;
                        this.setQuick(i, j, k, floatFunction.apply(f));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure floatProcedure, final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    float f2 = FloatMatrix3D.this.getQuick(i, j, k);
                                    if (!floatProcedure.apply(f2)) continue;
                                    FloatMatrix3D.this.setQuick(i, j, k, f);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        float f2 = this.getQuick(i, j, k);
                        if (!floatProcedure.apply(f2)) continue;
                        this.setQuick(i, j, k, f);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, f);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, f);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[] fArray) {
        if (fArray.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * FloatMatrix3D.this.rows * FloatMatrix3D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, fArray[n++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fArray[n5++]);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[][][] fArray) {
        if (fArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + fArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[][] fArray3 = fArray[i];
                            if (fArray3.length != FloatMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray3.length + "rows()=" + FloatMatrix3D.this.rows());
                            }
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                float[] fArray2 = fArray3[j];
                                if (fArray2.length != FloatMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + FloatMatrix3D.this.columns());
                                }
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, fArray2[k]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray2 = fArray[i];
                if (fArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + fArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray3 = fArray2[j];
                    if (fArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "columns()=" + this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, fArray3[k]);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D == this) {
            return this;
        }
        this.checkShape(floatMatrix3D);
        final FloatMatrix3D floatMatrix3D2 = this.haveSharedCells(floatMatrix3D) ? floatMatrix3D.copy() : floatMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, floatMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, floatMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    FloatMatrix3D.this.setQuick(i, j, k, floatFloatFunction.apply(FloatMatrix3D.this.getQuick(i, j, k), floatMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, floatFloatFunction.apply(this.getQuick(i, j, k), floatMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatMatrix3D floatMatrix3D, final FloatFloatFunction floatFloatFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        this.checkShape(floatMatrix3D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FloatMatrix3D.this.setQuick(nArray[i], nArray2[i], nArray3[i], floatFloatFunction.apply(FloatMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]), floatMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], nArray3[i], floatFloatFunction.apply(this.getQuick(nArray[i], nArray2[i], nArray3[i]), floatMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    if (FloatMatrix3D.this.getQuick(i, j, k) == 0.0f) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.getQuick(i, j, k) == 0.0f) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public FloatMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(float f) {
        return FloatProperty.DEFAULT.equals(this, f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FloatMatrix3D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix3D)object);
    }

    public float get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    public float[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        float f = FloatMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < FloatMatrix3D.this.columns; ++k) {
                                    float f2 = FloatMatrix3D.this.getQuick(i, j, k);
                                    if (!(f < f2)) continue;
                                    f = f2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new float[]{f, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                n3 = (int)fArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f < fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                    n3 = (int)fArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        float f2 = this.getQuick(i, j, k);
                        if (!(f < f2)) continue;
                        f = f2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new float[]{f, n, n2, n3};
    }

    public float[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, this.slices);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.slices / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.slices : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = 0;
                        float f = FloatMatrix3D.this.getQuick(n, 0, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < FloatMatrix3D.this.columns; ++k) {
                                    float f2 = FloatMatrix3D.this.getQuick(i, j, k);
                                    if (!(f > f2)) continue;
                                    f = f2;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new float[]{f, n, n2, n3};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                n3 = (int)fArray[0][3];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f > fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                    n3 = (int)fArray[n5][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.getQuick(0, 0, 0);
            int n9 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n9; k < this.columns; ++k) {
                        float f2 = this.getQuick(i, j, k);
                        if (!(f > f2)) continue;
                        f = f2;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n9 = 0;
                }
            }
        }
        return new float[]{f, n, n2, n3};
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.getQuick(i, j, k);
                    if (!(f < 0.0f)) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    floatArrayList.add(f);
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.getQuick(i, j, k);
                    if (f == 0.0f) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    floatArrayList.add(f);
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        floatArrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.getQuick(i, j, k);
                    if (!(f > 0.0f)) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    floatArrayList.add(f);
                }
            }
        }
    }

    public abstract float getQuick(int var1, int var2, int var3);

    public FloatMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract FloatMatrix3D like(int var1, int var2, int var3);

    public abstract FloatMatrix2D like2D(int var1, int var2);

    public void normalize() {
        float f = this.getMinLocation()[0];
        if (f < 0.0f) {
            this.assign(FloatFunctions.minus(f));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign(1.0f / (float)this.size());
        } else {
            float f2 = this.zSum();
            f2 = 1.0f / f2;
            this.assign(FloatFunctions.mult(f2));
        }
    }

    public void set(int n, int n2, int n3, float f) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, f);
    }

    public abstract void setQuick(int var1, int var2, int var3, float var4);

    public float[][][] toArray() {
        final float[][][] fArray = new float[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[][] fArray3 = fArray[i];
                            for (int j = 0; j < FloatMatrix3D.this.rows; ++j) {
                                float[] fArray2 = fArray3[j];
                                for (int k = 0; k < FloatMatrix3D.this.columns; ++k) {
                                    fArray2[k] = FloatMatrix3D.this.getQuick(i, j, k);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                float[][] fArray2 = fArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    float[] fArray3 = fArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        fArray3[k] = this.getQuick(i, j, k);
                    }
                }
            }
        }
        return fArray;
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public abstract FloatMatrix1D vectorize();

    public FloatMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FloatMatrix3D viewColumnFlip() {
        return (FloatMatrix3D)this.view().vColumnFlip();
    }

    public FloatMatrix3D viewDice(int n, int n2, int n3) {
        return (FloatMatrix3D)this.view().vDice(n, n2, n3);
    }

    public FloatMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (FloatMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public FloatMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FloatMatrix3D viewRowFlip() {
        return (FloatMatrix3D)this.view().vRowFlip();
    }

    public FloatMatrix3D viewSelection(FloatMatrix2DProcedure floatMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!floatMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public FloatMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            for (n2 = 0; n2 < this.slices; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public FloatMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public FloatMatrix3D viewSliceFlip() {
        return (FloatMatrix3D)this.view().vSliceFlip();
    }

    public FloatMatrix3D viewSorted(int n, int n2) {
        return FloatSorting.mergeSort.sort(this, n, n2);
    }

    public FloatMatrix3D viewStrides(int n, int n2, int n3) {
        return (FloatMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public void zAssign27Neighbors(FloatMatrix3D floatMatrix3D, Float27Function float27Function) {
        if (float27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(floatMatrix3D);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        for (int i = 1; i < this.slices - 1; ++i) {
            for (int j = 1; j < n; ++j) {
                float f = this.getQuick(i - 1, j - 1, 0);
                float f2 = this.getQuick(i - 1, j - 1, 1);
                float f3 = this.getQuick(i - 1, j, 0);
                float f4 = this.getQuick(i - 1, j, 1);
                float f5 = this.getQuick(i - 1, j + 1, 0);
                float f6 = this.getQuick(i - 1, j + 1, 1);
                float f7 = this.getQuick(i - 1, j - 1, 0);
                float f8 = this.getQuick(i, j - 1, 1);
                float f9 = this.getQuick(i, j, 0);
                float f10 = this.getQuick(i, j, 1);
                float f11 = this.getQuick(i, j + 1, 0);
                float f12 = this.getQuick(i, j + 1, 1);
                float f13 = this.getQuick(i + 1, j - 1, 0);
                float f14 = this.getQuick(i + 1, j - 1, 1);
                float f15 = this.getQuick(i + 1, j, 0);
                float f16 = this.getQuick(i + 1, j, 1);
                float f17 = this.getQuick(i + 1, j + 1, 0);
                float f18 = this.getQuick(i + 1, j + 1, 1);
                for (int k = 1; k < n2; ++k) {
                    float f19 = this.getQuick(i - 1, j - 1, k + 1);
                    float f20 = this.getQuick(i - 1, j, k + 1);
                    float f21 = this.getQuick(i - 1, j + 1, k + 1);
                    float f22 = this.getQuick(i, j - 1, k + 1);
                    float f23 = this.getQuick(i, j, k + 1);
                    float f24 = this.getQuick(i, j + 1, k + 1);
                    float f25 = this.getQuick(i + 1, j - 1, k + 1);
                    float f26 = this.getQuick(i + 1, j, k + 1);
                    float f27 = this.getQuick(i + 1, j + 1, k + 1);
                    floatMatrix3D.setQuick(i, j, k, float27Function.apply(f, f2, f19, f3, f4, f20, f5, f6, f21, f7, f8, f22, f9, f10, f23, f11, f12, f24, f13, f14, f25, f15, f16, f26, f17, f18, f27));
                    f = f2;
                    f2 = f19;
                    f3 = f4;
                    f4 = f20;
                    f5 = f6;
                    f6 = f21;
                    f7 = f8;
                    f8 = f22;
                    f9 = f10;
                    f10 = f23;
                    f11 = f12;
                    f12 = f24;
                    f13 = f14;
                    f14 = f25;
                    f15 = f16;
                    f16 = f26;
                    f17 = f18;
                    f18 = f27;
                }
            }
        }
    }

    public float zSum() {
        if (this.size() == 0L) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }

    protected FloatMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D == null) {
            return false;
        }
        if (this == floatMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(floatMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix3D floatMatrix3D) {
        return false;
    }

    protected abstract FloatMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected FloatMatrix3D view() {
        return (FloatMatrix3D)this.clone();
    }

    protected abstract FloatMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);
}

