/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import blbutil.IntSet;
import dag.DagLevel;
import java.util.Arrays;

public final class LowCapacityDagLevel
implements DagLevel {
    private final float count;
    private final char[] parentNodes;
    private final char[] childNodes;
    private final char[] parentIndices;
    private final char[] parents;
    private final char[] childIndices;
    private final char[] children;
    private final char[] symbols;
    private final float[] edgeCounts;
    private final float[] condEdgeProbs;
    private final float[] parentCounts;

    public LowCapacityDagLevel(char[] cArray, char[] cArray2, char[] cArray3, float[] fArray) {
        int n = LowCapacityDagLevel.checkLengths(cArray, cArray2, cArray3, fArray);
        this.parentIndices = LowCapacityDagLevel.getIndicesArray(cArray);
        this.childIndices = LowCapacityDagLevel.getIndicesArray(cArray2);
        this.parentNodes = (char[])cArray.clone();
        this.childNodes = (char[])cArray2.clone();
        this.symbols = (char[])cArray3.clone();
        this.edgeCounts = (float[])fArray.clone();
        this.condEdgeProbs = new float[n];
        this.parents = new char[n];
        this.children = new char[n];
        char[] cArray4 = Arrays.copyOfRange(this.parentIndices, 0, this.parentIndices.length - 1);
        char[] cArray5 = Arrays.copyOfRange(this.childIndices, 0, this.childIndices.length - 1);
        this.parentCounts = this.parentCnts(cArray, fArray, cArray4.length);
        this.count = this.sum(this.parentCounts);
        for (int n2 = 0; n2 < n; n2 = (int)((char)(n2 + 1))) {
            char c = cArray[n2];
            char c2 = cArray2[n2];
            char c3 = c;
            char c4 = cArray4[c3];
            cArray4[c3] = (char)(c4 + '\u0001');
            this.parents[c4] = n2;
            char c5 = c2;
            char c6 = cArray5[c5];
            cArray5[c5] = (char)(c6 + '\u0001');
            this.children[c6] = n2;
            this.condEdgeProbs[n2] = fArray[n2] / this.parentCounts[c];
        }
        LowCapacityDagLevel.checkForDuplicateOutEdges(this.parentIndices, this.parents, cArray3);
    }

    private static int checkLengths(char[] cArray, char[] cArray2, char[] cArray3, float[] fArray) {
        if (cArray.length > 65535) {
            String string = "parentNodes.length>Character.MAX_VALUE";
            throw new IllegalArgumentException(string);
        }
        if (cArray.length != cArray2.length || cArray.length != cArray3.length || cArray.length != fArray.length) {
            throw new IllegalArgumentException("inconsistent arrays");
        }
        return cArray.length;
    }

    private static void checkForDuplicateOutEdges(char[] cArray, char[] cArray2, char[] cArray3) {
        IntSet intSet = new IntSet(cArray3.length);
        for (int i = 1; i < cArray.length; ++i) {
            intSet.clear();
            char c = cArray[i];
            for (int j = cArray[i - 1]; j < c; ++j) {
                char c2 = cArray2[j];
                if (intSet.add(cArray3[c2])) continue;
                throw new IllegalArgumentException("duplicate edge");
            }
        }
    }

    private static char[] getIndicesArray(char[] cArray) {
        int[] nArray = LowCapacityDagLevel.elementCounts(cArray);
        char[] cArray2 = new char[nArray.length + 1];
        for (int i = 1; i < cArray2.length; ++i) {
            assert (nArray[i - 1] > 0);
            int n = cArray2[i - 1] + nArray[i - 1];
            assert (n <= 65535);
            cArray2[i] = (char)n;
        }
        return cArray2;
    }

    private static int[] elementCounts(char[] cArray) {
        int n = LowCapacityDagLevel.max(cArray);
        int[] nArray = new int[n + 1];
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = c = cArray2[i];
            nArray[c2] = nArray[c2] + 1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            throw new IllegalArgumentException("no element with value " + i);
        }
        return nArray;
    }

    private static int max(char[] cArray) {
        char c = '\u0000';
        for (char c2 : cArray) {
            if (c2 <= c) continue;
            c = c2;
        }
        return c;
    }

    private float sum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    private float[] parentCnts(char[] cArray, float[] fArray, int n) {
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.condEdgeProbs.length; ++i) {
            char c;
            char c2 = c = cArray[i];
            fArray2[c2] = fArray2[c2] + fArray[i];
        }
        return fArray2;
    }

    @Override
    public int nEdges() {
        return this.condEdgeProbs.length;
    }

    @Override
    public int nParentNodes() {
        return this.parentIndices.length - 1;
    }

    @Override
    public int nChildNodes() {
        return this.childIndices.length - 1;
    }

    @Override
    public int parentNode(int n) {
        return this.parentNodes[n];
    }

    @Override
    public int childNode(int n) {
        return this.childNodes[n];
    }

    @Override
    public int symbol(int n) {
        return this.symbols[n];
    }

    @Override
    public float edgeWeight(int n) {
        return this.edgeCounts[n];
    }

    @Override
    public float parentWeight(int n) {
        return this.parentCounts[n];
    }

    @Override
    public float condEdgeProb(int n) {
        return this.condEdgeProbs[n];
    }

    @Override
    public float edgeProb(int n) {
        return this.edgeCounts[n] / this.count;
    }

    @Override
    public float parentProb(int n) {
        return this.parentCounts[n] / this.count;
    }

    @Override
    public int nOutEdges(int n) {
        return this.parentIndices[n + 1] - this.parentIndices[n];
    }

    @Override
    public int outEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nOutEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.parents[this.parentIndices[n] + n2];
    }

    @Override
    public int outEdgeBySymbol(int n, int n2) {
        int n3 = this.parentIndices[n];
        char c = this.parentIndices[n + 1];
        for (int i = n3; i < c; ++i) {
            char c2 = this.parents[i];
            if (this.symbols[c2] != n2) continue;
            return c2;
        }
        return -1;
    }

    @Override
    public int nInEdges(int n) {
        return this.childIndices[n + 1] - this.childIndices[n];
    }

    @Override
    public int inEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nInEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.children[this.childIndices[n] + n2];
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentNodes=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.parentNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childNodes=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.childNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("symbols=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.symbols));
        stringBuilder.append(Const.nl);
        stringBuilder.append("condEdgeProbs=");
        stringBuilder.append(Arrays.toString(this.condEdgeProbs));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentCounts=");
        stringBuilder.append(Arrays.toString(this.parentCounts));
        stringBuilder.append(Const.nl);
        stringBuilder.append("edgeCounts=");
        stringBuilder.append(Arrays.toString(this.edgeCounts));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentIndices=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.parentIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parents=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.parents));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childIndices=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.childIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("children=");
        stringBuilder.append(LowCapacityDagLevel.charArrayToString(this.children));
        return stringBuilder.toString();
    }

    private static String charArrayToString(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 4 + 10);
        stringBuilder.append("[");
        stringBuilder.append((int)cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append((int)cArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

