## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

library(shiny)
library(testthat)
library(shinytesters)

## ----create_example-----------------------------------------------------------
#  # Simple module where when a button is clicked, a select input is updated to
#  # select "h" out of the letters and checkbox is selected
#  server_module_fn <- function(id) {
#    moduleServer(id, function(input, output, session) {
#      observeEvent(input$button, {
#        updateSelectInput(inputId = "options", choices = letters, selected = "h")
#        updateCheckboxInput(inputId = "check", value = TRUE)
#      })
#    })
#  }
#  
#  test_that("When the button is clicked, the options update", {
#    local_mocked_bindings(
#      !!!create_test_update_fns(c("updateSelectInput", "updateCheckboxInput")),
#      .package = "shiny"
#    )
#  
#    testServer(
#      app = server_module_fn,
#      expr = {
#        # Uninitialised modulehas NULL for inputs
#        expect_null(input$options)
#  
#        # After clicking button, options choices and selected option update
#        session$setInputs(button = 1L)
#        expect_identical(input$options, "h")
#        expect_identical(input$options.choices, letters)
#        expect_true(input$check)
#      }
#    )
#  })

## ----use_example--------------------------------------------------------------
#  test_that("When the button is clicked, the options update", {
#    use_shiny_testers()
#  
#    testServer(
#      app = server_module_fn,
#      expr = {
#        # Uninitialised modulehas NULL for inputs
#        expect_null(input$options)
#  
#        # After clicking button, options choices and selected option update
#        session$setInputs(button = 1L)
#        expect_identical(input$options, "h")
#        expect_identical(input$options.choices, letters)
#        expect_true(input$check)
#      }
#    )
#  })

