/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.tsp.lagrangian;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.graph.cost.GraphLagrangianRelaxation;
import org.chocosolver.solver.constraints.graph.cost.trees.lagrangian.AbstractTreeFinder;
import org.chocosolver.solver.constraints.graph.cost.tsp.lagrangian.KruskalOneTreeGAC;
import org.chocosolver.solver.constraints.graph.cost.tsp.lagrangian.PrimOneTreeFinder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropLagrOneTree
extends Propagator<Variable>
implements GraphLagrangianRelaxation {
    protected UndirectedGraph g;
    protected IntVar obj;
    protected int n;
    protected final double[][] costs;
    protected final TIntArrayList mandatoryArcsList;
    protected boolean waitFirstSol;
    private UndirectedGraphVar gV;
    private final int[][] originalCosts;
    private final double[] penalities;
    private double totalPenalities;
    private UndirectedGraph mst;
    private double step;
    private final AbstractTreeFinder HKfilter;
    private final AbstractTreeFinder HK;
    private final int nbSprints;

    protected PropLagrOneTree(Variable[] vars, int[][] costMatrix) {
        super(vars, (Priority)PropagatorPriority.CUBIC, false);
        this.originalCosts = costMatrix;
        this.n = this.originalCosts.length;
        this.costs = new double[this.n][this.n];
        this.totalPenalities = 0.0;
        this.penalities = new double[this.n];
        this.mandatoryArcsList = new TIntArrayList();
        this.nbSprints = 30;
        this.HK = new PrimOneTreeFinder(this.n, this);
        this.HKfilter = new KruskalOneTreeGAC(this.n, this);
    }

    public PropLagrOneTree(UndirectedGraphVar graph, IntVar cost, int[][] costMatrix) {
        this(new Variable[]{graph, cost}, costMatrix);
        this.g = (UndirectedGraph)graph.getUB();
        this.gV = graph;
        this.obj = cost;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int lb;
        if (this.waitFirstSol && this.getModel().getSolver().getSolutionCount() == 0L) {
            return;
        }
        this.rebuild();
        this.setCosts();
        do {
            lb = this.obj.getLB();
            this.lagrangianRelaxation();
        } while (lb < this.obj.getLB());
    }

    private void lagrangianRelaxation() throws ContradictionException {
        double hkb;
        double alpha = 2.0;
        double beta = 0.5;
        double bestHKB = 0.0;
        this.HKfilter.computeMST(this.costs, this.g);
        bestHKB = hkb = this.HKfilter.getBound() - this.totalPenalities;
        this.mst = this.HKfilter.getMST();
        if (hkb - Math.floor(hkb) < 0.001) {
            hkb = Math.floor(hkb);
        }
        this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
        this.HKfilter.performPruning((double)this.obj.getUB() + this.totalPenalities + 0.001);
        for (int iter = 5; iter > 0; --iter) {
            for (int i = this.nbSprints; i > 0; --i) {
                this.HK.computeMST(this.costs, this.g);
                hkb = this.HK.getBound() - this.totalPenalities;
                if (hkb > bestHKB + 1.0) {
                    bestHKB = hkb;
                }
                this.mst = this.HK.getMST();
                if (hkb - Math.floor(hkb) < 0.001) {
                    hkb = Math.floor(hkb);
                }
                this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
                this.updateStep(hkb, alpha);
                this.penalitiesHK();
                this.updateCostMatrix();
            }
            this.HKfilter.computeMST(this.costs, this.g);
            hkb = this.HKfilter.getBound() - this.totalPenalities;
            if (hkb > bestHKB + 1.0) {
                bestHKB = hkb;
            }
            this.mst = this.HKfilter.getMST();
            if (hkb - Math.floor(hkb) < 0.001) {
                hkb = Math.floor(hkb);
            }
            this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
            this.HKfilter.performPruning((double)this.obj.getUB() + this.totalPenalities + 0.001);
            this.updateStep(hkb, alpha);
            this.penalitiesHK();
            this.updateCostMatrix();
            alpha *= beta;
            beta /= 2.0;
        }
    }

    protected void rebuild() {
        this.mandatoryArcsList.clear();
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.gV.getMandatoryNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.mandatoryArcsList.add(i * this.n + j);
            }
        }
    }

    private void setCosts() {
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.costs[i][j] = (double)this.originalCosts[i][j] + this.penalities[i] + this.penalities[j];
                this.costs[j][i] = this.costs[i][j];
            }
        }
    }

    private void updateStep(double hkb, double alpha) {
        double nb2viol = 0.0;
        double target = this.obj.getUB();
        if (target - hkb < 0.0) {
            target = hkb + 0.1;
        }
        for (int i = 0; i < this.n; ++i) {
            int deg = this.mst.getNeighborsOf(i).size();
            nb2viol += (double)((2 - deg) * (2 - deg));
        }
        this.step = nb2viol == 0.0 ? 0.0 : alpha * (target - hkb) / nb2viol;
    }

    private void penalitiesHK() {
        if (this.step == 0.0) {
            return;
        }
        double sumPenalities = 0.0;
        for (int i = 0; i < this.n; ++i) {
            int deg = this.mst.getNeighborsOf(i).size();
            int n = i;
            this.penalities[n] = this.penalities[n] + (double)(deg - 2) * this.step;
            assert (!(this.penalities[i] > Double.MAX_VALUE / (double)(this.n - 1)) && !(this.penalities[i] < -1.7976931348623157E308 / (double)(this.n - 1))) : "Extreme-value lagrangian multipliers. Numerical issue may happen";
            sumPenalities += this.penalities[i];
        }
        this.totalPenalities = 2.0 * sumPenalities;
    }

    private void updateCostMatrix() {
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.costs[i][j] = (double)this.originalCosts[i][j] + this.penalities[i] + this.penalities[j];
                this.costs[j][i] = this.costs[i][j];
            }
        }
    }

    @Override
    public void remove(int from, int to) throws ContradictionException {
        this.gV.removeEdge(from, to, this);
    }

    @Override
    public void enforce(int from, int to) throws ContradictionException {
        this.gV.enforceEdge(from, to, this);
    }

    @Override
    public void contradiction() throws ContradictionException {
        this.fails();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public double getMinArcVal() {
        return -((double)this.obj.getUB() + this.totalPenalities);
    }

    @Override
    public TIntArrayList getMandatoryArcsList() {
        return this.mandatoryArcsList;
    }

    @Override
    public boolean isMandatory(int i, int j) {
        return this.gV.getMandatoryNeighborsOf(i).contains(j);
    }

    @Override
    public void waitFirstSolution(boolean b) {
        this.waitFirstSol = b;
    }

    @Override
    public boolean contains(int i, int j) {
        return this.mst == null || this.mst.containsEdge(i, j);
    }

    @Override
    public UndirectedGraph getSupport() {
        return this.mst;
    }

    @Override
    public double getReplacementCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }

    @Override
    public double getMarginalCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }
}

