/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.cp.common.util.preprocessor.AbstractAdvancedDetector;
import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.common.util.preprocessor.merger.TaskVariableMerger;
import choco.cp.model.CPModel;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.common.util.objects.BooleanSparseMatrix;
import choco.kernel.common.util.objects.ISparseMatrix;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.variables.scheduling.TaskVar;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractTaskVariableEqualitiesDetector
extends AbstractAdvancedDetector {
    public AbstractTaskVariableEqualitiesDetector(CPModel model) {
        super(model);
    }

    @Override
    public void apply() {
        ISparseMatrix matrix;
        if (AbstractDetector.LOGGER.isLoggable(Level.CONFIG)) {
            AbstractDetector.LOGGER.config("TaskVariable equalities detection :");
        }
        if ((matrix = this.analyze()).getNbElement() > 0) {
            this.change(matrix);
        }
    }

    private ISparseMatrix analyze() {
        int nbStoredMultipleVars = this.model.getNbStoredMultipleVars();
        BooleanSparseMatrix matrix = new BooleanSparseMatrix(nbStoredMultipleVars);
        for (int i = 0; i < nbStoredMultipleVars - 1; ++i) {
            MultipleVariables m1 = this.model.getStoredMultipleVar(i);
            if (!(m1 instanceof TaskVariable)) continue;
            for (int j = i + 1; j < nbStoredMultipleVars; ++j) {
                MultipleVariables m2 = this.model.getStoredMultipleVar(j);
                if (!(m2 instanceof TaskVariable) || !m1.isEquivalentTo(m2)) continue;
                matrix.add(m1.getHook(), m2.getHook());
            }
        }
        return matrix;
    }

    private void change(ISparseMatrix matrix) {
        int nbStoredMultipleVars = this.model.getNbStoredMultipleVars();
        matrix.prepare();
        int[] color = new int[nbStoredMultipleVars];
        Arrays.fill(color, -1);
        TIntObjectHashMap<TaskVariableMerger> domainByColor = new TIntObjectHashMap<TaskVariableMerger>();
        int nbDiffObject = this.detect(matrix, nbStoredMultipleVars, color, domainByColor);
        this.apply(nbDiffObject, nbStoredMultipleVars, color, domainByColor);
    }

    private int detect(ISparseMatrix matrix, int nbStoredMultipleVars, int[] color, TIntObjectHashMap<TaskVariableMerger> domainByColor) {
        int nb = -1;
        Iterator<Long> it = matrix.iterator();
        TaskVariableMerger dtmp = new TaskVariableMerger();
        while (it.hasNext()) {
            long v = it.next();
            int i = (int)(v / (long)nbStoredMultipleVars);
            int j = (int)(v % (long)nbStoredMultipleVars);
            if (color[i] == -1) {
                color[i] = ++nb;
                domainByColor.put(nb, new TaskVariableMerger((TaskVariable)this.model.getStoredMultipleVar(i)));
            }
            TaskVariableMerger d = domainByColor.get(color[i]);
            dtmp.copy(d);
            if (d.intersection((TaskVariable)this.model.getStoredMultipleVar(j))) {
                color[j] = color[i];
                domainByColor.put(color[i], d);
                continue;
            }
            d.copy(dtmp);
            if (color[j] != -1) continue;
            color[j] = ++nb;
            domainByColor.put(nb, new TaskVariableMerger((TaskVariable)this.model.getStoredMultipleVar(j)));
        }
        return nb;
    }

    protected abstract void apply(int var1, int var2, int[] var3, TIntObjectHashMap<TaskVariableMerger> var4);

    public static final class TaskVariableEqualitiesSolverDetector
    extends AbstractTaskVariableEqualitiesDetector {
        private final PreProcessCPSolver ppsolver;

        public TaskVariableEqualitiesSolverDetector(CPModel model, PreProcessCPSolver solver) {
            super(model);
            this.ppsolver = solver;
        }

        @Override
        protected void apply(int k, int nbStoredMultipleVars, int[] color, TIntObjectHashMap<TaskVariableMerger> domainByColor) {
            TaskVar[] var = new TaskVar[k + 1];
            for (int i = 0; i < nbStoredMultipleVars; ++i) {
                int col = color[i];
                if (col == -1) continue;
                TaskVariable v = (TaskVariable)this.model.getStoredMultipleVar(i);
                if (var[col] == null) {
                    TaskVariableMerger dtmp = domainByColor.get(col);
                    TaskVariable vtmp = dtmp.create();
                    vtmp.addOptions(vtmp.getOptions());
                    vtmp.findManager(CPModel.properties);
                    this.ppsolver.setVar(vtmp.start(), this.ppsolver.getMod2Sol().readModelVariable(vtmp.start()));
                    this.ppsolver.setVar(vtmp.duration(), this.ppsolver.getMod2Sol().readModelVariable(vtmp.duration()));
                    this.ppsolver.setVar(vtmp.end(), this.ppsolver.getMod2Sol().readModelVariable(vtmp.end()));
                    var[col] = (TaskVar)this.ppsolver.getMod2Sol().readModelVariable(vtmp);
                }
                this.ppsolver.setVar(v, var[col]);
                this.ppsolver.setVar(v.start(), var[col].start());
                this.ppsolver.setVar(v.duration(), var[col].duration());
                this.ppsolver.setVar(v.end(), var[col].end());
                v.resetHook();
            }
        }
    }

    public static final class TaskVariableEqualitiesModelDetector
    extends AbstractTaskVariableEqualitiesDetector {
        public TaskVariableEqualitiesModelDetector(CPModel model) {
            super(model);
        }

        @Override
        protected void apply(int k, int nbStoredMultipleVars, int[] color, TIntObjectHashMap<TaskVariableMerger> domainByColor) {
            TaskVariable[] var = new TaskVariable[k + 1];
            for (int i = 0; i < nbStoredMultipleVars; ++i) {
                int col = color[i];
                if (col == -1) continue;
                TaskVariable v = (TaskVariable)this.model.getStoredMultipleVar(i);
                if (var[col] == null) {
                    TaskVariableMerger dtmp = domainByColor.get(col);
                    TaskVariable vtmp = dtmp.create();
                    vtmp.addOptions(vtmp.getOptions());
                    var[col] = vtmp;
                    this.add(var[col]);
                }
                this.replaceBy(v, var[col]);
                this.replaceBy(v.start(), var[col].start());
                this.replaceBy(v.duration(), var[col].duration());
                this.replaceBy(v.end(), var[col].end());
                this.delete(v);
            }
        }
    }
}

