/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;

public class SparseFloatMatrix3D
extends FloatMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix3D(float[][][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, fArray.length == 0 ? 0 : (fArray[0].length == 0 ? 0 : fArray[0][0].length));
        this.assign(fArray);
    }

    public SparseFloatMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2f, 0.5f);
    }

    public SparseFloatMatrix3D(int n, int n2, int n3, int n4, float f, float f2) {
        block2: {
            try {
                this.setUp(n, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongFloatHashMap(n4, f, f2);
    }

    protected SparseFloatMatrix3D(int n, int n2, int n3, AbstractLongFloatMap abstractLongFloatMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongFloatMap;
        this.isNoView = false;
    }

    public FloatMatrix3D assign(float f) {
        if (this.isNoView && f == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(f);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized float getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
    }

    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    public FloatMatrix3D like(int n, int n2, int n3) {
        return new SparseFloatMatrix3D(n, n2, n3);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, int n3, float f) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (f == 0.0f) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, f);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    float f = this.getQuick(i, j, k);
                    if (f == 0.0f) continue;
                    stringBuilder.append('(').append(i).append(',').append(j).append(',').append(k).append(')').append('\t').append(f).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public FloatMatrix1D vectorize() {
        SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseFloatMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseFloatMatrix1D;
    }

    protected boolean haveSharedCellsRaw(FloatMatrix3D floatMatrix3D) {
        if (floatMatrix3D instanceof SelectedSparseFloatMatrix3D) {
            SelectedSparseFloatMatrix3D selectedSparseFloatMatrix3D = (SelectedSparseFloatMatrix3D)floatMatrix3D;
            return this.elements == selectedSparseFloatMatrix3D.elements;
        }
        if (floatMatrix3D instanceof SparseFloatMatrix3D) {
            SparseFloatMatrix3D sparseFloatMatrix3D = (SparseFloatMatrix3D)floatMatrix3D;
            return this.elements == sparseFloatMatrix3D.elements;
        }
        return false;
    }

    protected FloatMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseFloatMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    protected FloatMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseFloatMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

