/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import java.io.Serializable;

public class DenseDoubleQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private double[] elementsA;
    private double[] T;
    private boolean columnMatrix = false;
    private DoubleMatrix2D R;
    private DoubleMatrix2D Q;
    private int m;
    private int n;

    public DenseDoubleQRDecomposition(DoubleMatrix2D doubleMatrix2D) {
        DoubleProperty.DEFAULT.checkRectangular(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            this.elementsA = (double[])doubleMatrix2D.viewDice().copy().elements();
        } else {
            this.columnMatrix = true;
            this.elementsA = (double[])doubleMatrix2D.copy().elements();
        }
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        int n = this.m;
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
        this.T = Dplasma.plasma_Allocate_T((int)this.m, (int)this.n);
        int n2 = Dplasma.plasma_DGEQRF((int)this.m, (int)this.n, (double[])this.elementsA, (int)0, (int)n, (double[])this.T, (int)0);
        Dplasma.plasma_Finalize();
        if (n2 != 0) {
            throw new IllegalArgumentException("Error occured while computing QR decomposition: " + n2);
        }
    }

    public DoubleMatrix2D getQ(boolean bl) {
        if (this.Q == null) {
            int n;
            Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
            this.Q = new DenseColumnDoubleMatrix2D(this.m, this.m);
            double[] dArray = (double[])this.Q.elements();
            for (n = 0; n < this.m; ++n) {
                dArray[this.m * n + n] = 1.0;
            }
            n = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)this.m, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])dArray, (int)0, (int)this.m);
            Dplasma.plasma_Finalize();
            if (n != 0) {
                throw new IllegalArgumentException("Error occured while computing matrix Q: " + n);
            }
            this.Q = this.Q.viewDice().copy();
        }
        if (!this.columnMatrix) {
            if (bl) {
                return ((DenseColumnDoubleMatrix2D)this.Q.viewPart(0, 0, this.m, this.n)).getRowMajor();
            }
            return ((DenseColumnDoubleMatrix2D)this.Q).getRowMajor();
        }
        if (bl) {
            return this.Q.viewPart(0, 0, this.m, this.n).copy();
        }
        return this.Q.copy();
    }

    public DoubleMatrix2D getR(boolean bl) {
        if (this.R == null) {
            this.R = new DenseColumnDoubleMatrix2D(this.m, this.n);
            double[] dArray = (double[])this.R.elements();
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.m; ++j) {
                    if (j > i) continue;
                    dArray[i * this.m + j] = this.elementsA[i * this.m + j];
                }
            }
        }
        if (!this.columnMatrix) {
            if (bl) {
                return ((DenseColumnDoubleMatrix2D)this.R.viewPart(0, 0, this.n, this.n)).getRowMajor();
            }
            return ((DenseColumnDoubleMatrix2D)this.R).getRowMajor();
        }
        if (bl) {
            return ((DenseColumnDoubleMatrix2D)this.R.viewPart(0, 0, this.n, this.n)).copy();
        }
        return this.R.copy();
    }

    public boolean hasFullRank() {
        for (int i = 0; i < this.n; ++i) {
            if (this.elementsA[i * this.m + i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        if (doubleMatrix1D.size() != (long)this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        double[] dArray = doubleMatrix1D.isView() ? (double[])doubleMatrix1D.copy().elements() : (double[])doubleMatrix1D.elements();
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)1);
        int n = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)1, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])dArray, (int)0, (int)this.m);
        if (n != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + n);
        }
        n = Dplasma.plasma_DTRSM((int)141, (int)121, (int)111, (int)131, (int)this.n, (int)1, (double[])this.elementsA, (int)0, (int)this.m, (double[])dArray, (int)0, (int)this.m);
        Dplasma.plasma_Finalize();
        if (n != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + n);
        }
        if (doubleMatrix1D.isView()) {
            doubleMatrix1D.assign(dArray);
        }
    }

    public void solve(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        double[] dArray = doubleMatrix2D instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D.viewDice().copy().elements() : (doubleMatrix2D.isView() ? (double[])doubleMatrix2D.copy().elements() : (double[])doubleMatrix2D.elements());
        int n = doubleMatrix2D.columns();
        Dplasma.plasma_Init((int)this.m, (int)this.n, (int)n);
        int n2 = Dplasma.plasma_DORMQR((int)141, (int)111, (int)this.m, (int)n, (int)this.n, (double[])this.elementsA, (int)0, (int)this.m, (double[])this.T, (int)0, (double[])dArray, (int)0, (int)this.m);
        if (n2 != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + n2);
        }
        n2 = Dplasma.plasma_DTRSM((int)141, (int)121, (int)111, (int)131, (int)this.n, (int)n, (double[])this.elementsA, (int)0, (int)this.m, (double[])dArray, (int)0, (int)this.m);
        Dplasma.plasma_Finalize();
        if (n2 != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using QR decomposition: " + n2);
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            doubleMatrix2D.viewDice().assign(dArray);
        } else if (doubleMatrix2D.isView()) {
            doubleMatrix2D.assign(dArray);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("QRDecomposition(A) --> hasFullRank(A), Q, R, pseudo inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("hasFullRank = ");
        try {
            stringBuffer.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nQ = ");
        try {
            stringBuffer.append(String.valueOf(this.getQ(false)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nR = ");
        try {
            stringBuffer.append(String.valueOf(this.getR(false)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\npseudo inverse(A) = ");
        try {
            DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.identity(this.m);
            this.solve(doubleMatrix2D);
            stringBuffer.append(String.valueOf(doubleMatrix2D));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

