/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MultivariateFunction;
import jebl.math.UnivariateFunction;

public class OrthogonalLineFunction
implements UnivariateFunction {
    private MultivariateFunction f;
    private int numArgs;
    private int n;
    private double bak;
    private double[] s;
    private double[] x;

    public OrthogonalLineFunction(MultivariateFunction func) {
        this(func, 0, null);
    }

    public OrthogonalLineFunction(MultivariateFunction func, int selectedDimension, double[] initialArguments) {
        this.f = func;
        this.numArgs = this.f.getNumArguments();
        this.x = new double[this.numArgs];
        this.n = selectedDimension;
        if (initialArguments != null) {
            System.arraycopy(initialArguments, 0, this.x, 0, Math.min(this.x.length, initialArguments.length));
        }
    }

    public void setAllArguments(double[] start) {
        for (int i = 0; i < this.numArgs; ++i) {
            this.x[i] = start[i];
        }
    }

    public void setArgument(double val) {
        this.x[this.n] = val;
        this.bak = this.x[this.n];
    }

    public void selectArgument(int num) {
        this.n = num;
        this.bak = this.x[this.n];
        if (this.f.getLowerBound(num) == this.f.getUpperBound(num)) {
            System.out.println("Warning! Range is zero on parameter:" + num);
        }
    }

    public double evaluate(double arg) {
        this.x[this.n] = arg;
        double v = this.f.evaluate(this.x);
        this.x[this.n] = this.bak;
        return v;
    }

    public double getLowerBound() {
        return this.f.getLowerBound(this.n);
    }

    public double getUpperBound() {
        return this.f.getUpperBound(this.n);
    }
}

