/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.inference.markovjumps.MarkovReward;
import dr.math.Binomial;
import dr.math.GammaFunction;
import dr.math.matrixAlgebra.Vector;
import dr.stats.DiscreteStatistics;

public class SericolaSeriesMarkovReward
implements MarkovReward {
    private static final boolean DEBUG = false;
    private double[][][][] internalC;
    private EigenDecomposition eigenDecomposition;
    private final double[] Q;
    private final double[] r;
    private final double lambda;
    private final double[] P;
    private final int phi;
    private final int dim;
    private final double epsilon;
    private final EigenSystem eigenSystem;
    private double maxTime;

    public SericolaSeriesMarkovReward(double[] dArray, double[] dArray2, int n) {
        this(dArray, dArray2, n, 1.0E-10);
    }

    public SericolaSeriesMarkovReward(double[] dArray, double[] dArray2, int n, double d) {
        this.Q = dArray;
        this.r = dArray2;
        this.maxTime = 0.0;
        this.epsilon = d;
        this.dim = n;
        this.lambda = this.determineLambda();
        this.phi = n - 1;
        this.P = this.initializeP(dArray, this.lambda);
        this.eigenSystem = new DefaultEigenSystem(n);
    }

    private double[][] initializeW(int n, int n2) {
        return new double[n][n2 * n2];
    }

    private double determineLambda() {
        double d = this.Q[0];
        for (int i = 1; i < this.dim; ++i) {
            int n = this.idx(i, i);
            if (!(this.Q[n] < d)) continue;
            d = this.Q[n];
        }
        return -d;
    }

    private double[] initializeP(double[] dArray, double d) {
        double[] dArray2 = new double[this.dim * this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double d2 = i == j ? 1.0 : 0.0;
                dArray2[this.idx((int)i, (int)j)] = d2 + dArray[this.idx(i, j)] / d;
            }
        }
        return dArray2;
    }

    private int getHfromX(double d, double d2) {
        if (d < this.r[0] * d2) {
            throw new IllegalArgumentException("x must be greater than r[0] * time");
        }
        if (d > this.r[this.phi] * d2) {
            throw new IllegalArgumentException("x must be less than r[phi] * time");
        }
        int n = 1;
        while (d > this.r[n] * d2) {
            ++n;
        }
        return n;
    }

    private int[] getHfromX(double[] dArray, double d) {
        return this.getHfromX(dArray, new double[]{d});
    }

    private int[] getHfromX(double[] dArray, double[] dArray2) {
        boolean bl = false;
        double d = 0.0;
        if (dArray2.length == 1) {
            bl = true;
            d = dArray2[0];
        } else if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Either times must have one dimension, or X and times must have the same dimension");
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!bl) {
                d = dArray2[i];
            }
            nArray[i] = this.getHfromX(dArray[i], d);
        }
        return nArray;
    }

    private void growC(double d, int n) {
        int n2 = this.getNfromC();
        if (d > this.maxTime) {
            n2 = this.determineNumberOfSteps(d, this.lambda) + n;
            this.maxTime = d;
        }
        if (n2 > this.getNfromC()) {
            if (n2 > 500) {
                System.err.println("Warning: > 500 recursion depth in SericolaSeriesMarkovReward");
            }
            this.initializeSpace(this.phi, n2);
            this.computeChnk();
        }
    }

    private void initializeSpace(int n, int n2) {
        this.internalC = new double[n + 1][n2 + 1][n2 + 1][this.dim * this.dim];
    }

    private double[] C(int n, int n2, int n3) {
        return this.internalC[n][n2][n3];
    }

    private int getNfromC() {
        return this.internalC == null ? -1 : this.internalC[0].length - 1;
    }

    private int idx(int n, int n2) {
        return n * this.dim + n2;
    }

    @Override
    public double computePdf(double d, double d2, int n, int n2) {
        if (d == d2) {
            return 0.0;
        }
        return this.computePdf(d, d2)[n * this.dim + n2];
    }

    @Override
    public double[] computePdf(double d, double d2) {
        return this.computePdf(new double[]{d}, d2)[0];
    }

    public double[][] computePdf(double[] dArray, double d) {
        return this.computePdf(dArray, new double[]{d});
    }

    public double[][] computePdf(double[] dArray, double[] dArray2) {
        return this.computePdf(dArray, dArray2, false);
    }

    public double[][] computePdf(double[] dArray, double[] dArray2, boolean bl) {
        int n;
        double[][] dArray3 = this.initializeW(dArray.length, this.dim);
        int[] nArray = this.getHfromX(dArray, dArray2);
        this.growC(DiscreteStatistics.max(dArray2), 1);
        int[] nArray2 = new int[dArray2.length];
        if (bl && dArray2.length > 1) {
            for (n = 0; n < dArray2.length; ++n) {
                nArray2[n] = this.determineNumberOfSteps(dArray2[n], this.lambda);
            }
        } else {
            nArray2 = null;
        }
        n = this.getNfromC() - 1;
        for (int i = 0; i <= n; ++i) {
            this.accumulatePdf(dArray3, dArray, nArray, i, dArray2, nArray2);
        }
        return dArray3;
    }

    @Override
    public double computeCdf(double d, double d2, int n, int n2) {
        return this.computeCdf(d, d2)[n * this.dim + n2];
    }

    public double[] computeCdf(double d, double d2) {
        return this.computeCdf(new double[]{d}, d2)[0];
    }

    public double[][] computeCdf(double[] dArray, double d) {
        int[] nArray = this.getHfromX(dArray, d);
        this.growC(d, 0);
        double[][] dArray2 = this.initializeW(dArray.length, this.dim);
        int n = this.getNfromC();
        for (int i = 0; i <= n; ++i) {
            this.accumulateCdf(dArray2, dArray, nArray, i, d);
        }
        return dArray2;
    }

    private void accumulateCdf(double[][] dArray, double[] dArray2, int[] nArray, int n, double d) {
        double d2 = Math.exp(-this.lambda * d + (double)n * (Math.log(this.lambda) + Math.log(d)) - GammaFunction.lnGamma((double)n + 1.0));
        for (int i = 0; i < dArray2.length; ++i) {
            int n2;
            double d3 = dArray2[i];
            int n3 = nArray[i];
            double d4 = (d3 - this.r[n3 - 1] * d) / ((this.r[n3] - this.r[n3 - 1]) * d);
            int n4 = this.dim * this.dim;
            double[] dArray3 = new double[n4];
            for (n2 = 0; n2 <= n; ++n2) {
                double d5 = Binomial.choose(n, n2) * Math.pow(d4, n2) * Math.pow(1.0 - d4, n - n2);
                for (int j = 0; j < n4; ++j) {
                    int n5 = j;
                    dArray3[n5] = dArray3[n5] + d5 * this.C(n3, n, n2)[j];
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                double[] dArray4 = dArray[i];
                int n6 = n2;
                dArray4[n6] = dArray4[n6] + d2 * dArray3[n2];
            }
        }
    }

    private void accumulatePdf(double[][] dArray, double[] dArray2, int[] nArray, int n, double[] dArray3, int[] nArray2) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        if (dArray3.length == 1) {
            d = this.computingPremultiplier(this.lambda, dArray3[0], n);
            d2 = dArray3[0];
            bl = true;
        }
        boolean bl2 = false;
        if (nArray2 != null) {
            bl2 = true;
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl2 && nArray2[i] < n) continue;
            if (!bl) {
                d2 = dArray3[i];
                d = this.computingPremultiplier(this.lambda, d2, n);
            }
            this.loopCyclePdf(dArray2[i], d2, nArray[i], n, d, dArray[i]);
        }
    }

    private void accumulatePdf(double[][] dArray, double[] dArray2, int[] nArray, int n, double[] dArray3) {
        this.accumulatePdf(dArray, dArray2, nArray, n, dArray3, null);
    }

    private double computingPremultiplier(double d, double d2, int n) {
        return Math.exp(-d * d2 + (double)n * (Math.log(d) + Math.log(d2)) - GammaFunction.lnGamma((double)n + 1.0));
    }

    private void loopCyclePdf(double d, double d2, int n, int n2, double d3, double[] dArray) {
        double d4 = this.lambda / (this.r[n] - this.r[n - 1]);
        double d5 = (d - this.r[n - 1] * d2) / ((this.r[n] - this.r[n - 1]) * d2);
        int n3 = this.dim * this.dim;
        double[] dArray2 = new double[n3];
        for (int i = 0; i <= n2; ++i) {
            double d6 = Binomial.choose(n2, i) * Math.pow(d5, i) * Math.pow(1.0 - d5, n2 - i);
            for (int j = 0; j < n3; ++j) {
                int n4 = j;
                dArray2[n4] = dArray2[n4] + d6 * (this.C(n, n2 + 1, i + 1)[j] - this.C(n, n2 + 1, i)[j]);
            }
        }
        double d7 = d4 * d3;
        for (int i = 0; i < n3; ++i) {
            int n5 = i;
            dArray[n5] = dArray[n5] + d7 * dArray2[i];
        }
    }

    private double relationTwelve(int n, int n2, int n3, int n4, int n5) {
        double d = (this.r[n4] - this.r[n]) / (this.r[n4] - this.r[n - 1]) * this.C(n, n2, n3 - 1)[this.idx(n4, n5)];
        double d2 = 0.0;
        for (int i = 0; i <= this.phi; ++i) {
            d2 += this.P[this.idx(n4, i)] * this.C(n, n2 - 1, n3 - 1)[this.idx(i, n5)];
        }
        return d + (d2 *= (this.r[n] - this.r[n - 1]) / (this.r[n4] - this.r[n - 1]));
    }

    private double relationThirteen(int n, int n2, int n3, int n4, int n5) {
        double d = (this.r[n - 1] - this.r[n4]) / (this.r[n] - this.r[n4]) * this.C(n, n2, n3 + 1)[this.idx(n4, n5)];
        double d2 = 0.0;
        for (int i = 0; i <= this.phi; ++i) {
            d2 += this.P[this.idx(n4, i)] * this.C(n, n2 - 1, n3)[this.idx(i, n5)];
        }
        return d + (d2 *= (this.r[n] - this.r[n - 1]) / (this.r[n] - this.r[n4]));
    }

    private double[] product(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[this.dim * this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                int n = this.idx(i, j);
                for (int k = 0; k < this.dim; ++k) {
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + dArray[this.idx(i, k)] * dArray2[this.idx(k, j)];
                }
            }
        }
        return dArray3;
    }

    private void computeChnk() {
        int n;
        int n2;
        double[] dArray = new double[this.dim * this.dim];
        for (n2 = 0; n2 < this.dim; ++n2) {
            dArray[this.idx((int)n2, (int)n2)] = 1.0;
        }
        for (n2 = 1; n2 <= this.phi; ++n2) {
            for (n = 0; n <= n2 - 1; ++n) {
                this.C((int)n2, (int)0, (int)0)[this.idx((int)n, (int)n)] = 1.0;
            }
        }
        n2 = this.getNfromC();
        for (n = 1; n <= n2; ++n) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = 1; n6 <= this.phi; ++n6) {
                for (n5 = 1; n5 <= n; ++n5) {
                    for (n4 = n6; n4 <= this.phi; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)n6, (int)n, (int)n5)[this.idx((int)n4, (int)n3)] = this.relationTwelve(n6, n, n5, n4, n3);
                        }
                    }
                }
                for (n5 = n6 + 1; n5 <= this.phi; ++n5) {
                    for (n4 = 0; n4 <= this.phi; ++n4) {
                        this.C((int)(n6 + 1), (int)n, (int)0)[this.idx((int)n5, (int)n4)] = this.C(n6, n, n)[this.idx(n5, n4)];
                    }
                }
            }
            dArray = this.product(dArray, this.P);
            for (n6 = 0; n6 <= this.phi - 1; ++n6) {
                for (n5 = 0; n5 <= this.phi; ++n5) {
                    this.C((int)this.phi, (int)n, (int)n)[this.idx((int)n6, (int)n5)] = dArray[this.idx(n6, n5)];
                }
            }
            for (n6 = this.phi; n6 >= 1; --n6) {
                for (n5 = n - 1; n5 >= 0; --n5) {
                    for (n4 = 0; n4 <= n6 - 1; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)n6, (int)n, (int)n5)[this.idx((int)n4, (int)n3)] = this.relationThirteen(n6, n, n5, n4, n3);
                        }
                    }
                    for (n4 = 0; n4 <= n6 - 2; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)(n6 - 1), (int)n, (int)n)[this.idx((int)n4, (int)n3)] = this.C(n6, n, 0)[this.idx(n4, n3)];
                        }
                    }
                }
            }
        }
    }

    private double[][] squareMatrix(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray2[i][j] = dArray[this.idx(i, j)];
            }
        }
        return dArray2;
    }

    private int determineNumberOfSteps(double d, double d2) {
        double d3;
        int n = -1;
        double d4 = 1.0 - this.epsilon;
        for (double d5 = 0.0; Math.abs(d5 - d4) > this.epsilon && d5 < 1.0; d5 += Math.exp(d3)) {
            d3 = -d2 * d + (double)(++n) * (Math.log(d2) + Math.log(d)) - GammaFunction.lnGamma(n + 1);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Q: " + new Vector(this.Q) + "\n");
        stringBuilder.append("r: " + new Vector(this.r) + "\n");
        stringBuilder.append("lambda: " + this.lambda + "\n");
        stringBuilder.append("N: " + this.getNfromC() + "\n");
        stringBuilder.append("maxTime: " + this.maxTime + "\n");
        stringBuilder.append("cprob at maxTime: " + new Vector(this.computeConditionalProbabilities(this.maxTime)) + "\n");
        return stringBuilder.toString();
    }

    private EigenDecomposition getEigenDecomposition() {
        if (this.eigenDecomposition == null) {
            this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.squareMatrix(this.Q));
        }
        return this.eigenDecomposition;
    }

    public double[] computeConditionalProbabilities(double d) {
        double[] dArray = new double[this.dim * this.dim];
        this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, dArray);
        return dArray;
    }

    @Override
    public double computeConditionalProbability(double d, int n, int n2) {
        return this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, n, n2);
    }
}

