/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.evomodel.substmodel.LogAdditiveCtmcRateProvider;
import dr.inference.distribution.LogLinearModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;

public class LogGaussianProcessModel
extends LogLinearModel
implements LogAdditiveCtmcRateProvider.DataAugmented {
    private final List<DesignMatrix> designMatrices;
    private final Parameter gaussianNoise;
    private boolean precisionKnown;
    private boolean vInvKnown;
    private RealMatrix vInvReal;
    private RealMatrix predictiveKernel;
    private RealMatrix predictiveInvVariance;
    private double logDetinvV;
    private final GaussianProcessKernel kernel;
    private final Parameter realizedField;

    public LogGaussianProcessModel(Parameter parameter, Parameter parameter2, Parameter parameter3, List<DesignMatrix> list) {
        super(parameter);
        this.gaussianNoise = parameter2;
        this.addVariable(parameter2);
        this.realizedField = parameter;
        this.addVariable(this.realizedField);
        this.designMatrices = list;
        for (DesignMatrix designMatrix : list) {
            this.addVariable(designMatrix);
        }
        this.precisionKnown = false;
        this.kernel = new GaussianProcessKernel("name", parameter3);
        this.addModel(this.kernel);
    }

    public Parameter getFieldParameter() {
        return this.realizedField;
    }

    @Override
    public Parameter getLogRateParameter() {
        return this.realizedField;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.kernel) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.precisionKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.dependentParam) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.precisionKnown = false;
    }

    @Override
    protected double calculateLogLikelihood() {
        double d;
        double[] dArray = this.dependentParam.getParameterValues();
        RealMatrix realMatrix = MatrixUtils.createColumnRealMatrix(dArray);
        if (!this.precisionKnown) {
            d = this.gaussianNoise.getParameterValue(0);
            this.precision(d);
            this.logDetinvV = Math.log(this.predictiveInvVariance.getDeterminant());
            this.precisionKnown = true;
        }
        d = realMatrix.transpose().multiply(this.vInvReal).multiply(realMatrix).getEntry(0, 0);
        double d2 = -0.5 * ((double)this.N * Math.log(Math.PI * 2) - this.logDetinvV) - 0.5 * d;
        return d2;
    }

    public double[][] kernel() {
        int n = this.designMatrices.size();
        double[][] dArray = new double[this.N][this.N];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.designMatrices.get(i).getParameterValues();
            for (int j = 0; j < this.N; ++j) {
                for (int k = 0; k < this.N; ++k) {
                    double[] dArray3 = dArray[j];
                    int n2 = k;
                    dArray3[n2] = dArray3[n2] + this.kernel.getCorrelation(dArray2[j], dArray2[k]);
                }
            }
        }
        return dArray;
    }

    public void precision(double d) {
        double[][] dArray = this.kernel();
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(dArray);
        double[][] dArray2 = new double[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray2[i][i] = d;
        }
        RealMatrix realMatrix2 = MatrixUtils.createRealMatrix(dArray2);
        this.vInvReal = realMatrix.add(realMatrix2).inverse();
        this.predictiveKernel = MatrixUtils.createRealMatrix(dArray);
        double[][] dArray3 = this.kernel();
        RealMatrix realMatrix3 = MatrixUtils.createRealMatrix(dArray3);
        RealMatrix realMatrix4 = realMatrix3.subtract(realMatrix.multiply(this.vInvReal).multiply(this.predictiveKernel.transpose()));
        this.predictiveInvVariance = realMatrix4.inverse();
    }

    @Override
    public double[] getXBeta() {
        return this.dependentParam.getParameterValues();
    }

    public static class GaussianProcessKernel
    extends AbstractModel {
        private final Parameter parameter;

        public GaussianProcessKernel(String string, Parameter parameter) {
            super(string);
            this.parameter = parameter;
            this.addVariable(parameter);
        }

        double getCorrelation(double d, double d2) {
            double d3 = this.parameter.getParameterValue(1);
            double d4 = this.parameter.getParameterValue(2);
            return d * d2;
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            if (variable == this.parameter) {
                this.fireModelChanged(this.parameter);
            }
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }
    }
}

