/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.LinkedGroup;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LinkedGroupParser
extends AbstractXMLObjectParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Taxa.class), AttributeRule.newDoubleRule("probability", true, "the probability that the group of reads are linked to each other")};

    @Override
    public String getParserDescription() {
        return "A group of metagenome reads linked with some probability";
    }

    @Override
    public Class getReturnType() {
        return LinkedGroup.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        TaxonList taxonList = null;
        double d = 0.9999999999;
        if (xMLObject.hasAttribute("probability")) {
            d = xMLObject.getDoubleAttribute("probability");
        }
        taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
        LinkedGroup linkedGroup = new LinkedGroup(taxonList, d);
        return linkedGroup;
    }

    @Override
    public String getParserName() {
        return "LinkedGroup";
    }
}

