/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeStatistic;
import dr.stats.DiscreteStatistics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SubtreeRateStatistic
extends TreeStatistic {
    private Tree tree;
    private BranchRateModel branchRateModel;
    private boolean complement;
    private final boolean includeStem;
    private final boolean returnGeneticDistance;
    private String mode;
    private final Set<Taxon> taxa;
    private final Set<String> leafSet;

    public SubtreeRateStatistic(String string, Tree tree, BranchRateModel branchRateModel, String string2, TaxonList taxonList, boolean bl, boolean bl2, boolean bl3) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.branchRateModel = branchRateModel;
        this.mode = string2;
        this.complement = bl;
        this.includeStem = bl2;
        this.returnGeneticDistance = bl3;
        this.taxa = new HashSet<Taxon>();
        for (Taxon taxon : taxonList) {
            this.taxa.add(taxon);
        }
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    private void addBranchesToClade(boolean[] blArray, NodeRef nodeRef) {
        for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            blArray[nodeRef2.getNumber()] = true;
            if (this.tree.isExternal(nodeRef)) continue;
            this.addBranchesToClade(blArray, nodeRef2);
        }
    }

    private boolean[] getBranchesToUse() {
        boolean[] blArray = new boolean[this.tree.getNodeCount()];
        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSet);
        if (this.includeStem) {
            blArray[nodeRef.getNumber()] = true;
        }
        this.addBranchesToClade(blArray, nodeRef);
        if (this.complement) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = !blArray[i];
            }
            blArray[this.tree.getRoot().getNumber()] = false;
        }
        return blArray;
    }

    private void getRates(List<Double> list, List<Double> list2) {
        boolean[] blArray = this.getBranchesToUse();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            NodeRef nodeRef = this.tree.getNode(i);
            list.add(this.branchRateModel.getBranchRate(this.tree, nodeRef));
            list2.add(this.tree.getBranchLength(nodeRef));
        }
    }

    @Override
    public double getStatisticValue(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        this.getRates(arrayList, arrayList2);
        double[] dArray = new double[arrayList.size()];
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
            dArray2[i] = (Double)arrayList2.get(i);
        }
        if (this.returnGeneticDistance) {
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray2[i];
            }
            return d;
        }
        if (this.mode.equals("mean")) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * dArray2[i];
                d2 += dArray2[i];
            }
            return d / d2;
        }
        if (this.mode.equals("variance")) {
            return DiscreteStatistics.variance(dArray);
        }
        if (this.mode.equals("coefficientOfVariation")) {
            double d = DiscreteStatistics.mean(dArray);
            return Math.sqrt(DiscreteStatistics.variance(dArray, d)) / d;
        }
        throw new IllegalArgumentException();
    }
}

