/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.ParameterReplaceableSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.Parameter;
import java.util.List;

public class InstantaneousMixtureSubstitutionModel
extends ComplexSubstitutionModel
implements ParameterReplaceableSubstitutionModel {
    private int alphabetSize;
    private int alphabetSize2;
    private int nRates;
    private int numComponents;
    private List<SubstitutionModel> substitutionModelList;
    private boolean pOneMinusP;
    private boolean transform;
    private boolean checkWeights = true;
    private Parameter mixtureWeights;

    public InstantaneousMixtureSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, List<SubstitutionModel> list, Parameter parameter, boolean bl) {
        super("instantaneousMixtureSubstitutionModel", dataType, frequencyModel, (Parameter)null);
        this.substitutionModelList = list;
        this.mixtureWeights = parameter;
        this.alphabetSize = list.get(0).getFrequencyModel().getFrequencyCount();
        this.alphabetSize2 = this.alphabetSize * this.alphabetSize;
        this.nRates = this.alphabetSize * (this.alphabetSize - 1);
        this.numComponents = list.size();
        this.transform = bl;
        boolean bl2 = this.pOneMinusP = this.numComponents == 2 && parameter.getSize() == 1 && !bl;
        if (!this.checkWeightDimension()) {
            throw new RuntimeException("Mismatch between number of mixture weights and number of substitution models.");
        }
        if (!this.checkStateSpaces(list)) {
            throw new RuntimeException("Not all substitution models in instantaneousMixtureSubstitutionModel have same state space size.");
        }
        this.addVariable(parameter);
        for (SubstitutionModel substitutionModel : list) {
            this.addModel(substitutionModel);
        }
    }

    private boolean checkWeightDimension() {
        boolean bl;
        boolean bl2 = bl = this.numComponents == this.mixtureWeights.getSize();
        if (!bl) {
            if (this.pOneMinusP) {
                bl = true;
            } else if (this.transform && this.mixtureWeights.getSize() == this.numComponents - 1) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean checkStateSpaces(List<SubstitutionModel> list) {
        boolean bl = true;
        for (SubstitutionModel substitutionModel : list) {
            if (substitutionModel.getFrequencyModel().getFrequencyCount() == this.alphabetSize) continue;
            bl = false;
        }
        return bl;
    }

    private double[] getComponentRates() {
        int n = this.nRates / 2;
        double[] dArray = new double[this.numComponents * this.nRates];
        for (int i = 0; i < this.numComponents; ++i) {
            SubstitutionModel substitutionModel = this.substitutionModelList.get(i);
            double[] dArray2 = new double[this.nRates];
            double d = 0.0;
            if (substitutionModel instanceof ComplexSubstitutionModel) {
                ((ComplexSubstitutionModel)substitutionModel).setupRelativeRates(dArray2);
            } else if (substitutionModel instanceof BaseSubstitutionModel) {
                double[] dArray3 = new double[n];
                ((BaseSubstitutionModel)substitutionModel).setupRelativeRates(dArray3);
                for (int j = 0; j < n; ++j) {
                    double d2 = dArray3[j];
                    dArray2[j + n] = d2;
                    dArray2[j] = d2;
                }
            } else {
                double[] dArray4 = new double[this.alphabetSize2];
                substitutionModel.getInfinitesimalMatrix(dArray4);
                double[] dArray5 = substitutionModel.getFrequencyModel().getFrequencies();
                int n2 = 0;
                for (int j = 0; j < this.alphabetSize - 1; ++j) {
                    for (int k = j + 1; k < this.alphabetSize; ++k) {
                        dArray2[n2] = dArray4[j * this.alphabetSize + k] / dArray5[k];
                        dArray2[n2 + n] = dArray4[k * this.alphabetSize + j] / dArray5[j];
                        ++n2;
                    }
                }
            }
            for (int j = 0; j < this.nRates; ++j) {
                dArray[j + i * this.nRates] = Math.log(dArray2[j]);
            }
        }
        return dArray;
    }

    private double[] getMixtureProportions() {
        double[] dArray = this.mixtureWeights.getParameterValues();
        if (this.transform) {
            int n;
            double[] dArray2 = new double[dArray.length + 1];
            dArray2[0] = 1.0;
            double d = 1.0;
            for (n = 0; n < dArray2.length - 1; ++n) {
                dArray2[n + 1] = dArray[n];
                d += dArray[n];
            }
            n = 0;
            int n2 = 0;
            while (n2 < dArray2.length) {
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] / d;
            }
            dArray = dArray2;
        } else if (this.pOneMinusP) {
            double d = this.mixtureWeights.getParameterValue(0);
            dArray = new double[]{d, 1.0 - d};
        }
        if (this.checkWeights) {
            double d = 0.0;
            for (int i = 0; i < this.numComponents; ++i) {
                if (dArray[i] < 0.0 || dArray[i] > 1.0) {
                    throw new RuntimeException("Mixing proportion " + i + " has value (" + dArray[i] + ") outside allowed range of [0,1]");
                }
                d += dArray[i];
            }
            if (Math.abs(d - 1.0) > 1.0E-6) {
                throw new RuntimeException("Mixing proportions do not sum to 1");
            }
        }
        return dArray;
    }

    public double[] getRates() {
        double[] dArray = this.getComponentRates();
        double[] dArray2 = this.getMixtureProportions();
        double[] dArray3 = new double[this.nRates];
        for (int i = 0; i < this.nRates; ++i) {
            for (int j = 0; j < this.numComponents; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray2[j] * dArray[i + j * this.nRates];
            }
            dArray3[i] = Math.exp(dArray3[i]);
            if (!Double.isNaN(dArray3[i])) continue;
            System.err.println("Rate " + i + " is NaN");
        }
        return dArray3;
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        System.arraycopy(this.getRates(), 0, dArray, 0, dArray.length);
    }

    @Override
    public String getDescription() {
        return "Substitution model from log-linear combinations of Q matrices.";
    }

    @Override
    public ParameterReplaceableSubstitutionModel factory(List<Parameter> list, List<Parameter> list2) {
        Parameter parameter = this.mixtureWeights;
        List<SubstitutionModel> list3 = this.substitutionModelList;
        FrequencyModel frequencyModel = this.freqModel;
        DataType dataType = this.dataType;
        String string = super.getModelName();
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter2 = list.get(i);
            Parameter parameter3 = list2.get(i);
            if (parameter2 != this.mixtureWeights) {
                throw new RuntimeException("Parameter not found in InstantaneousMixtureSubstitutionModel.");
            }
            parameter = parameter3;
        }
        return new InstantaneousMixtureSubstitutionModel(string, dataType, frequencyModel, list3, parameter, this.transform);
    }
}

