/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppDiploidHistory;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppNode;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.util.AlloppMisc;
import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.Stack;
import jebl.util.FixedBitSet;

public class AlloppMulLabTree {
    private MulLabNode[] mlnodes;
    private int rootn;
    private int nextn;
    private AlloppSpeciesBindings apsp;
    private Parameter tippopvals;
    private Parameter rootpopvals;
    private double[] hybpopvals;
    private int nofhybpopvals;
    public SimpleTree simptree;
    static final Comparator<SpSqUnion> SPUNION_ORDER = new Comparator<SpSqUnion>(){

        @Override
        public int compare(SpSqUnion spSqUnion, SpSqUnion spSqUnion2) {
            int n;
            int n2 = spSqUnion.spunion.cardinality();
            if (n2 != (n = spSqUnion2.spunion.cardinality())) {
                return n2 - n;
            }
            int n3 = spSqUnion.spunion.nextOnBit(0);
            int n4 = spSqUnion2.spunion.nextOnBit(0);
            while (n3 >= 0 || n4 >= 0) {
                if (n3 != n4) {
                    return n3 - n4;
                }
                n3 = spSqUnion.spunion.nextOnBit(n3 + 1);
                n4 = spSqUnion2.spunion.nextOnBit(n4 + 1);
            }
            n2 = spSqUnion.spsqunion.cardinality();
            if (n2 != (n = spSqUnion2.spsqunion.cardinality())) {
                return n2 - n;
            }
            n3 = spSqUnion.spsqunion.nextOnBit(0);
            n4 = spSqUnion2.spsqunion.nextOnBit(0);
            while (n3 >= 0 || n4 >= 0) {
                if (n3 != n4) {
                    return n3 - n4;
                }
                n3 = spSqUnion.spsqunion.nextOnBit(n3 + 1);
                n4 = spSqUnion2.spsqunion.nextOnBit(n4 + 1);
            }
            return 0;
        }
    };

    AlloppMulLabTree(AlloppDiploidHistory alloppDiploidHistory, ArrayList<AlloppLeggedTree> arrayList, AlloppSpeciesBindings alloppSpeciesBindings, Parameter parameter, Parameter parameter2, double[] dArray) {
        this.apsp = alloppSpeciesBindings;
        this.tippopvals = parameter;
        this.rootpopvals = parameter2;
        this.hybpopvals = dArray;
        this.nofhybpopvals = arrayList.size();
        int n = 0;
        n += alloppDiploidHistory.getDiploidTipCount();
        for (AlloppLeggedTree alloppLeggedTree : arrayList) {
            n += 2 * alloppLeggedTree.getExternalNodeCount();
        }
        this.mlnodes = new MulLabNode[2 * n - 1];
        for (int i = 0; i < this.mlnodes.length; ++i) {
            this.mlnodes[i] = new MulLabNode(i);
            this.mlnodes[i].tetraancestor = true;
        }
        this.nextn = 0;
        this.nextn = this.subtree2MulLabNodes(alloppDiploidHistory, alloppDiploidHistory.getRootIndex(), arrayList, alloppSpeciesBindings);
        this.rootn = this.nextn - 1;
        this.mlnodes[this.rootn].fillinUnionsInSubtree(alloppSpeciesBindings.numberOfSpSeqs());
        this.fillinTetraFlagsInSubtree(this.mlnodes[this.rootn]);
        this.makesimpletree();
    }

    public AlloppMulLabTree(AlloppDiploidHistory alloppDiploidHistory, ArrayList<AlloppLeggedTree> arrayList, AlloppSpeciesBindings alloppSpeciesBindings, Parameter parameter, Parameter parameter2, double[] dArray, int n) {
        this(alloppDiploidHistory, arrayList, alloppSpeciesBindings, parameter, parameter2, dArray);
        assert (n >= 1);
        assert (n <= 5);
        this.fillinpopvals();
    }

    public AlloppMulLabTree(AlloppSpeciesBindings alloppSpeciesBindings) {
        this.apsp = alloppSpeciesBindings;
        this.nofhybpopvals = 1;
        this.tippopvals = new Parameter.Default(3, 0.003);
        this.rootpopvals = new Parameter.Default(4, 0.001);
        this.hybpopvals = new double[1];
        this.hybpopvals[0] = 0.001;
        this.fillmlnodesforlhoodtest1();
        this.fillinTetraFlagsInSubtree(this.mlnodes[this.rootn]);
        this.mlnodes[this.rootn].fillinUnionsInSubtree(4);
    }

    public double testGeneTreeInMULTreeLogLikelihood() {
        return this.geneTreeInMULTreeLogLikelihood();
    }

    private void fillmlnodesforlhoodtest1() {
        this.mlnodes = new MulLabNode[7];
        for (int i = 0; i < this.mlnodes.length; ++i) {
            this.mlnodes[i] = new MulLabNode(i);
        }
        this.mlnodes[0].taxon = new Taxon("a");
        this.mlnodes[1].taxon = new Taxon("b");
        this.mlnodes[2].taxon = new Taxon("z0");
        this.mlnodes[3].taxon = new Taxon("z1");
        this.mlnodes[2].tetraancestor = true;
        this.mlnodes[3].tetraancestor = true;
        this.mlnodes[2].intetratree = true;
        this.mlnodes[3].intetratree = true;
        this.mlnodes[2].tetraroot = true;
        this.mlnodes[3].tetraroot = true;
        this.mlnodes[0].union = new FixedBitSet(4);
        this.mlnodes[0].union.set(0);
        this.mlnodes[1].union = new FixedBitSet(4);
        this.mlnodes[1].union.set(1);
        this.mlnodes[2].union = new FixedBitSet(4);
        this.mlnodes[2].union.set(2);
        this.mlnodes[3].union = new FixedBitSet(4);
        this.mlnodes[3].union.set(3);
        this.mlnodes[4].addChildren(this.mlnodes[0], this.mlnodes[2]);
        this.mlnodes[5].addChildren(this.mlnodes[1], this.mlnodes[3]);
        this.mlnodes[6].addChildren(this.mlnodes[4], this.mlnodes[5]);
        this.rootn = 6;
        this.mlnodes[0].height = 0.0;
        this.mlnodes[1].height = 0.0;
        this.mlnodes[2].height = 0.0;
        this.mlnodes[3].height = 0.0;
        this.mlnodes[4].height = 0.01;
        this.mlnodes[5].height = 0.02;
        this.mlnodes[6].height = 0.03;
        this.mlnodes[2].hybridheight = 0.005;
        this.mlnodes[3].hybridheight = 0.005;
        this.mlnodes[0].nlineages = 1;
        this.mlnodes[1].nlineages = 2;
        this.mlnodes[2].nlineages = 1;
        this.mlnodes[3].nlineages = 1;
        this.mlnodes[4].nlineages = 2;
        this.mlnodes[4].coalheights.add(0.015);
        this.mlnodes[5].nlineages = 3;
        this.mlnodes[5].coalheights.add(0.025);
        this.mlnodes[6].nlineages = 3;
        this.mlnodes[6].coalheights.add(0.035);
        this.mlnodes[6].coalheights.add(0.045);
    }

    boolean mullabtreeOK() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.mlnodes.length; ++n3) {
            if (this.mlnodes[n3].anc >= 0) continue;
            ++n4;
        }
        if (n4 != 1) {
            return false;
        }
        for (n3 = 0; n3 < this.mlnodes.length; ++n3) {
            n2 = 0;
            for (n = 0; n < this.mlnodes.length; ++n) {
                if (this.mlnodes[n].lft == n3) {
                    ++n2;
                }
                if (this.mlnodes[n].rgt != n3) continue;
                ++n2;
            }
            if (this.mlnodes[n3].anc < 0 && n2 != 0) {
                return false;
            }
            if (this.mlnodes[n3].anc < 0 || n2 == 1) continue;
            return false;
        }
        for (n3 = 0; n3 < this.mlnodes.length; ++n3) {
            if (this.mlnodes[n3].getNumber() == n3) continue;
            return false;
        }
        for (n3 = 0; n3 < this.mlnodes.length; ++n3) {
            if (this.mlnodes[n3].lft >= 0) {
                if (this.mlnodes[n3].rgt < 0) {
                    return false;
                }
                n2 = this.mlnodes[n3].lft;
                n = this.mlnodes[n3].rgt;
                if (this.mlnodes[n2].anc != n3) {
                    return false;
                }
                if (this.mlnodes[n].anc != n3) {
                    return false;
                }
                if (this.mlnodes[n3].height <= this.mlnodes[n2].height) {
                    return false;
                }
                if (!(this.mlnodes[n3].height <= this.mlnodes[n].height)) continue;
                return false;
            }
            if (this.mlnodes[n3].height == 0.0) continue;
            return false;
        }
        return this.mlnodes[this.rootn].anc < 0;
    }

    String mullabTreeAsNewick() {
        String string = TreeUtils.uniqueNewick(this.simptree, this.simptree.getRoot());
        return string;
    }

    String asText() {
        String string = "MUL-tree              height                          union                               []  tippop  []  hybpop  [] rootpop  tetroot   hybhgt nlin coalheights" + System.getProperty("line.separator");
        String string2 = "";
        Stack<Integer> stack = new Stack<Integer>();
        return string + AlloppNode.Abstract.subtreeAsText(this.mlnodes[this.rootn], string2, stack, 0, "");
    }

    void clearCoalescences() {
        this.clearSubtreeCoalescences(this.mlnodes[this.rootn]);
    }

    void recordLineageCounts() {
        this.recordSubtreeLineageCounts(this.mlnodes[this.rootn]);
    }

    boolean coalescenceIsCompatible(double d, FixedBitSet fixedBitSet) {
        MulLabNode mulLabNode = (MulLabNode)this.mlnodes[this.rootn].nodeOfUnionInSubtree(fixedBitSet);
        return mulLabNode.height <= d;
    }

    void recordCoalescence(double d, FixedBitSet fixedBitSet) {
        MulLabNode mulLabNode = (MulLabNode)this.mlnodes[this.rootn].nodeOfUnionInSubtree(fixedBitSet);
        assert (mulLabNode.height <= d);
        while (mulLabNode.anc >= 0 && this.mlnodes[mulLabNode.anc].height <= d) {
            mulLabNode = this.mlnodes[mulLabNode.anc];
        }
        mulLabNode.coalheights.add(d);
    }

    void sortCoalescences() {
        for (MulLabNode mulLabNode : this.mlnodes) {
            Collections.sort(mulLabNode.coalheights);
        }
    }

    double geneTreeInMULTreeLogLikelihood() {
        this.fillinpopvals();
        return this.geneTreeInMULSubtreeLogLikelihood(this.mlnodes[this.rootn]);
    }

    private void fillinTetraFlagsInSubtree(AlloppNode alloppNode) {
        if (alloppNode.nofChildren() == 2) {
            MulLabNode mulLabNode = (MulLabNode)alloppNode;
            MulLabNode mulLabNode2 = (MulLabNode)alloppNode.getChild(0);
            MulLabNode mulLabNode3 = (MulLabNode)alloppNode.getChild(1);
            this.fillinTetraFlagsInSubtree(alloppNode.getChild(0));
            this.fillinTetraFlagsInSubtree(alloppNode.getChild(1));
            mulLabNode.tetraancestor = mulLabNode2.tetraancestor && mulLabNode3.tetraancestor;
            mulLabNode.intetratree = mulLabNode2.intetratree && !mulLabNode2.tetraroot && mulLabNode3.intetratree && !mulLabNode3.tetraroot;
        }
    }

    private int subtree2MulLabNodes(AlloppDiploidHistory alloppDiploidHistory, int n, ArrayList<AlloppLeggedTree> arrayList, AlloppSpeciesBindings alloppSpeciesBindings) {
        if (alloppDiploidHistory.getLftFromIndex(n) < 0) {
            int n2 = alloppDiploidHistory.getNodeTettree(n);
            if (n2 < 0) {
                this.mlnodes[this.nextn].setTaxon(alloppDiploidHistory.getTaxonFromIndex(n).getId());
                this.mlnodes[this.nextn].setUnion(alloppSpeciesBindings.taxonseqToTipUnion(this.mlnodes[this.nextn].taxon, 0));
                this.mlnodes[this.nextn].setHeight(alloppDiploidHistory.getHeightFromIndex(n));
                this.mlnodes[this.nextn].tetraancestor = false;
                ++this.nextn;
            } else {
                AlloppNode alloppNode = (AlloppNode)((Object)arrayList.get(n2).getSlidableRoot());
                int n3 = alloppDiploidHistory.getNodeLeg(n) == AlloppDiploidHistory.LegLorR.left ? 0 : 1;
                this.nextn = this.allopptree2MulLabNodes(alloppSpeciesBindings, alloppNode, n3);
                this.mlnodes[this.nextn - 1].hybridheight = alloppDiploidHistory.getHeightFromIndex(n);
                this.mlnodes[this.nextn - 1].tetraroot = true;
                this.mlnodes[this.nextn - 1].ttreeindex = n2;
            }
        } else {
            this.nextn = this.subtree2MulLabNodes(alloppDiploidHistory, alloppDiploidHistory.getLftFromIndex(n), arrayList, alloppSpeciesBindings);
            int n4 = this.nextn - 1;
            this.nextn = this.subtree2MulLabNodes(alloppDiploidHistory, alloppDiploidHistory.getRgtFromIndex(n), arrayList, alloppSpeciesBindings);
            int n5 = this.nextn - 1;
            this.mlnodes[this.nextn].addChildren(this.mlnodes[n4], this.mlnodes[n5]);
            this.mlnodes[this.nextn].setHeight(alloppDiploidHistory.getHeightFromIndex(n));
            ++this.nextn;
        }
        return this.nextn;
    }

    private int allopptree2MulLabNodes(AlloppSpeciesBindings alloppSpeciesBindings, AlloppNode alloppNode, int n) {
        if (alloppNode.nofChildren() == 0) {
            this.mlnodes[this.nextn].setTaxon(alloppNode.getTaxon().getId() + n);
            this.mlnodes[this.nextn].setUnion(alloppSpeciesBindings.taxonseqToTipUnion(alloppNode.getTaxon(), n));
            this.mlnodes[this.nextn].intetratree = true;
        } else {
            this.nextn = this.allopptree2MulLabNodes(alloppSpeciesBindings, alloppNode.getChild(0), n);
            int n2 = this.nextn - 1;
            this.nextn = this.allopptree2MulLabNodes(alloppSpeciesBindings, alloppNode.getChild(1), n);
            int n3 = this.nextn - 1;
            this.mlnodes[this.nextn].addChildren(this.mlnodes[n2], this.mlnodes[n3]);
        }
        this.mlnodes[this.nextn].setHeight(alloppNode.getHeight());
        ++this.nextn;
        return this.nextn;
    }

    private void makesimpletree() {
        SimpleNode[] simpleNodeArray = new SimpleNode[this.mlnodes.length];
        for (int i = 0; i < this.mlnodes.length; ++i) {
            simpleNodeArray[i] = new SimpleNode();
        }
        this.makesimplesubtree(simpleNodeArray, 0, this.mlnodes[this.rootn]);
        this.simptree = new SimpleTree(simpleNodeArray[this.mlnodes.length - 1]);
    }

    private int makesimplesubtree(SimpleNode[] simpleNodeArray, int n, MulLabNode mulLabNode) {
        if (mulLabNode.lft < 0) {
            simpleNodeArray[n].setTaxon(new Taxon(mulLabNode.taxon.getId()));
        } else {
            n = this.makesimplesubtree(simpleNodeArray, n, this.mlnodes[mulLabNode.lft]);
            int n2 = n - 1;
            n = this.makesimplesubtree(simpleNodeArray, n, this.mlnodes[mulLabNode.rgt]);
            int n3 = n - 1;
            simpleNodeArray[n].addChild(simpleNodeArray[n2]);
            simpleNodeArray[n].addChild(simpleNodeArray[n3]);
        }
        simpleNodeArray[n].setHeight(mulLabNode.height);
        String string = mulLabNode.ttreeindex < 0 ? "X" : "T" + mulLabNode.ttreeindex;
        simpleNodeArray[n].setAttribute("tti", string);
        if (mulLabNode.hybridheight >= 0.0) {
            simpleNodeArray[n].setAttribute("hybhgt", mulLabNode.hybridheight);
        }
        return n + 1;
    }

    private void clearSubtreeCoalescences(MulLabNode mulLabNode) {
        if (mulLabNode.lft >= 0) {
            this.clearSubtreeCoalescences(this.mlnodes[mulLabNode.lft]);
            this.clearSubtreeCoalescences(this.mlnodes[mulLabNode.rgt]);
        }
        mulLabNode.coalheights.clear();
    }

    private void recordSubtreeLineageCounts(MulLabNode mulLabNode) {
        if (mulLabNode.lft < 0) {
            mulLabNode.nlineages = this.apsp.nLineages(this.apsp.spseqindex2sp(AlloppMulLabTree.union2spseqindex(mulLabNode.union)));
        } else {
            mulLabNode.nlineages = 0;
            this.recordSubtreeLineageCounts(this.mlnodes[mulLabNode.lft]);
            this.recordSubtreeLineageCounts(this.mlnodes[mulLabNode.rgt]);
            mulLabNode.nlineages += this.mlnodes[mulLabNode.lft].nlineages - this.mlnodes[mulLabNode.lft].coalheights.size();
            mulLabNode.nlineages += this.mlnodes[mulLabNode.rgt].nlineages - this.mlnodes[mulLabNode.rgt].coalheights.size();
        }
    }

    private void fillinpopvals() {
        int n;
        ArrayList<SpSqUnion> arrayList = new ArrayList<SpSqUnion>();
        for (int i = 0; i < this.mlnodes.length; ++i) {
            arrayList.add(new SpSqUnion(this.mlnodes[i].union));
        }
        Collections.sort(arrayList, SPUNION_ORDER);
        SpSqUnion[] spSqUnionArray = new SpSqUnion[arrayList.size()];
        spSqUnionArray = arrayList.toArray(spSqUnionArray);
        PopValIndices popValIndices = new PopValIndices(0, 0, 0);
        for (n = 0; n < this.mlnodes.length; ++n) {
            this.mlnodes[n].tippopindex = -1;
            this.mlnodes[n].rootpopindex = -1;
            this.mlnodes[n].hybpopindex = -1;
        }
        n = this.tippopvals.getDimension();
        int n2 = this.rootpopvals.getDimension();
        int n3 = 0;
        while (n3 < spSqUnionArray.length) {
            int n4;
            for (n4 = n3 + 1; n4 < spSqUnionArray.length && spSqUnionArray[n4].spunion.equals(spSqUnionArray[n3].spunion); ++n4) {
            }
            assert (popValIndices.tipp <= n);
            if (popValIndices.rootp > n2) {
                System.out.println("BUG in fillinpopvals()");
            }
            assert (popValIndices.rootp <= n2);
            assert (popValIndices.hybp <= this.nofhybpopvals);
            popValIndices = this.fillinpopvalsforspunion(spSqUnionArray, n3, n4, popValIndices);
            n3 = n4;
        }
        if (popValIndices.tipp != n || popValIndices.rootp != n2 || popValIndices.hybp != this.nofhybpopvals) {
            System.out.println("BUG in fillinpopvals()");
        }
        assert (popValIndices.tipp == n);
        assert (popValIndices.rootp == n2);
        assert (popValIndices.hybp == this.nofhybpopvals);
    }

    private PopValIndices fillinpopvalsforspunion(SpSqUnion[] spSqUnionArray, int n, int n2, PopValIndices popValIndices) {
        int n3;
        int n4;
        int n5 = n2 - n;
        MulLabNode[] mulLabNodeArray = new MulLabNode[n5];
        for (n4 = n; n4 < n2; ++n4) {
            mulLabNodeArray[n4 - n] = (MulLabNode)this.mlnodes[this.rootn].nodeOfUnionInSubtree(spSqUnionArray[n4].spsqunion);
        }
        if (mulLabNodeArray[0].tetraroot) {
            assert (n5 >= 2);
            assert (mulLabNodeArray[1].tetraroot);
            for (n4 = 0; n4 < 2; ++n4) {
                mulLabNodeArray[n4].hybpopindex = popValIndices.hybp;
            }
            ++popValIndices.hybp;
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (mulLabNodeArray[n3].lft >= 0) continue;
            mulLabNodeArray[n3].tippopindex = popValIndices.tipp;
            ++n4;
        }
        assert (n4 <= 2);
        if (n4 > 0) {
            ++popValIndices.tipp;
        }
        if (mulLabNodeArray[0].intetratree && !mulLabNodeArray[0].tetraroot) {
            if (n5 != 2) {
                System.out.println("BUG in fillinpopvalsforspunion() 2");
            }
            assert (n5 == 2);
            assert (mulLabNodeArray[1].intetratree && !mulLabNodeArray[1].tetraroot);
            for (n3 = 0; n3 < 2; ++n3) {
                mulLabNodeArray[n3].rootpopindex = popValIndices.rootp;
            }
            ++popValIndices.rootp;
        } else {
            for (n3 = 0; n3 < n5; ++n3) {
                MulLabNode mulLabNode = mulLabNodeArray[n3];
                if (mulLabNode.anc < 0) continue;
                MulLabNode mulLabNode2 = this.siblingOfNode(mulLabNode);
                if (mulLabNode.tetraancestor || mulLabNode2.tetraancestor) {
                    if (mulLabNode2.rootpopindex >= 0) {
                        mulLabNode.rootpopindex = mulLabNode2.rootpopindex;
                        continue;
                    }
                    mulLabNode.rootpopindex = popValIndices.rootp;
                    ++popValIndices.rootp;
                    continue;
                }
                mulLabNode.rootpopindex = popValIndices.rootp;
                ++popValIndices.rootp;
            }
        }
        return popValIndices;
    }

    private MulLabNode siblingOfNode(MulLabNode mulLabNode) {
        MulLabNode mulLabNode2;
        assert (mulLabNode.anc >= 0);
        if (this.mlnodes[this.mlnodes[mulLabNode.anc].lft] == mulLabNode) {
            mulLabNode2 = this.mlnodes[this.mlnodes[mulLabNode.anc].rgt];
        } else {
            assert (this.mlnodes[this.mlnodes[mulLabNode.anc].rgt] == mulLabNode);
            mulLabNode2 = this.mlnodes[this.mlnodes[mulLabNode.anc].lft];
        }
        return mulLabNode2;
    }

    private double geneTreeInMULSubtreeLogLikelihood(MulLabNode mulLabNode) {
        double d = 0.0;
        if (mulLabNode.lft >= 0) {
            d += this.geneTreeInMULSubtreeLogLikelihood(this.mlnodes[mulLabNode.lft]);
            d += this.geneTreeInMULSubtreeLogLikelihood(this.mlnodes[mulLabNode.rgt]);
        }
        return d += this.branchLLInMULtree(mulLabNode);
    }

    private double branchLLInMULtree(MulLabNode mulLabNode) {
        double d = 0.0;
        double d2 = 0.0;
        d2 = mulLabNode.lft < 0 ? mulLabNode.tippop() : this.mlnodes[mulLabNode.lft].rootpop() + this.mlnodes[mulLabNode.rgt].rootpop();
        if (mulLabNode.tetraroot) {
            int n;
            int n2;
            for (n2 = 0; n2 < mulLabNode.coalheights.size() && (Double)mulLabNode.coalheights.get(n2) < mulLabNode.hybridheight; ++n2) {
            }
            double[] dArray = new double[n2 + 2];
            dArray[0] = mulLabNode.height;
            for (n = 0; n < n2; ++n) {
                dArray[n + 1] = (Double)mulLabNode.coalheights.get(n);
            }
            dArray[dArray.length - 1] = mulLabNode.hybridheight;
            PopulationAndLineages populationAndLineages = new PopulationAndLineages(dArray, d2, mulLabNode.hybpop(), mulLabNode.nlineages);
            if (Double.isNaN(d += this.limbLogLike(populationAndLineages))) {
                System.out.println("BUG in branchLLInMULtree");
            }
            n = mulLabNode.coalheights.size() - n2;
            dArray = new double[n + 2];
            dArray[0] = mulLabNode.hybridheight;
            for (int i = 0; i < n; ++i) {
                dArray[i + 1] = (Double)mulLabNode.coalheights.get(n2 + i);
            }
            dArray[dArray.length - 1] = this.mlnodes[mulLabNode.anc].height;
            populationAndLineages = new PopulationAndLineages(dArray, mulLabNode.rootpop(), mulLabNode.rootpop(), mulLabNode.nlineages - n2);
            d += this.limbLogLike(populationAndLineages);
        } else if (mulLabNode.anc < 0) {
            double[] dArray = new double[mulLabNode.coalheights.size() + 2];
            dArray[0] = mulLabNode.height;
            dArray[dArray.length - 1] = this.apsp.maxGeneTreeHeight();
            for (int i = 0; i < mulLabNode.coalheights.size(); ++i) {
                dArray[i + 1] = (Double)mulLabNode.coalheights.get(i);
            }
            PopulationAndLineages populationAndLineages = new PopulationAndLineages(dArray, d2, d2, mulLabNode.nlineages);
            d += this.limbLogLike(populationAndLineages);
        } else {
            double[] dArray = new double[mulLabNode.coalheights.size() + 2];
            dArray[0] = mulLabNode.height;
            dArray[dArray.length - 1] = this.mlnodes[mulLabNode.anc].height;
            for (int i = 0; i < mulLabNode.coalheights.size(); ++i) {
                dArray[i + 1] = (Double)mulLabNode.coalheights.get(i);
            }
            PopulationAndLineages populationAndLineages = new PopulationAndLineages(dArray, d2, mulLabNode.rootpop(), mulLabNode.nlineages);
            d += this.limbLogLike(populationAndLineages);
        }
        if (Double.isNaN(d)) {
            System.out.println("BUG in branchLLInMULtree");
        }
        return d;
    }

    private double limbLogLike(PopulationAndLineages populationAndLineages) {
        int n;
        double d = 0.0;
        int n2 = populationAndLineages.t.length - 2;
        for (n = 1; n <= n2; ++n) {
            d -= Math.log(populationAndLineages.populationAt(populationAndLineages.t[n]));
        }
        for (n = 0; n <= n2; ++n) {
            double d2 = (populationAndLineages.tipnlin - n) * (populationAndLineages.tipnlin - n - 1) / 2;
            double d3 = this.limbLinPopIntegral(populationAndLineages, populationAndLineages.t[n], populationAndLineages.t[n + 1]);
            d -= d2 * d3;
        }
        if (Double.isNaN(d)) {
            System.out.println("BUG in limbLogLike");
        }
        return d;
    }

    private double limbLinPopIntegral(PopulationAndLineages populationAndLineages, double d, double d2) {
        double d3 = populationAndLineages.t[0];
        double d4 = populationAndLineages.t[populationAndLineages.t.length - 1];
        if (populationAndLineages.rootpop < 1.0E-20) {
            System.out.println("Underflow in limbLinPopIntegral()");
        }
        double d5 = populationAndLineages.rootpop - populationAndLineages.tippop;
        double d6 = d4 * populationAndLineages.tippop - d3 * populationAndLineages.rootpop;
        double d7 = Math.abs(d5 / populationAndLineages.tippop);
        if (d7 > 0.001) {
            return (d4 - d3) / d5 * Math.log((d6 + d5 * d2) / (d6 + d5 * d));
        }
        double d8 = d5 * (d2 - d) / (d6 + d5 * d);
        double d9 = 1.0 - d8 / 2.0 + d8 * d8 * (0.3333333333333333 - d8 / 4.0 + d8 * d8 * (0.2 - d8 / 6.0));
        return (d4 - d3) * (d2 - d) / (d6 + d5 * d) * d9;
    }

    private static int union2spseqindex(FixedBitSet fixedBitSet) {
        assert (fixedBitSet.cardinality() == 1);
        return fixedBitSet.nextOnBit(0);
    }

    private class MulLabNode
    extends AlloppNode.Abstract
    implements AlloppNode,
    NodeRef {
        private int nodeNumber;
        private int anc;
        private int lft;
        private int rgt;
        private double height;
        private boolean tetraroot;
        private boolean intetratree;
        private boolean tetraancestor;
        private int ttreeindex;
        private double hybridheight;
        private FixedBitSet union;
        private ArrayList<Double> coalheights;
        private int nlineages;
        private Taxon taxon;
        private int tippopindex;
        private int hybpopindex;
        private int rootpopindex;

        MulLabNode(int n) {
            this.nodeNumber = n;
            this.anc = -1;
            this.lft = -1;
            this.rgt = -1;
            this.height = -1.0;
            this.tetraroot = false;
            this.intetratree = false;
            this.tetraancestor = false;
            this.ttreeindex = -1;
            this.hybridheight = -1.0;
            this.coalheights = new ArrayList();
            this.taxon = new Taxon("");
            this.tippopindex = -1;
            this.hybpopindex = -1;
            this.rootpopindex = -1;
        }

        public double tippop() {
            return AlloppMulLabTree.this.tippopvals.getParameterValue(this.tippopindex);
        }

        public double hybpop() {
            return AlloppMulLabTree.this.hybpopvals[this.hybpopindex];
        }

        public double rootpop() {
            return AlloppMulLabTree.this.rootpopvals.getParameterValue(this.rootpopindex);
        }

        @Override
        public String asText(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder, Locale.US);
            if (this.lft < 0) {
                formatter.format("%s ", this.taxon.getId());
            } else {
                formatter.format("%s ", "+");
            }
            while (stringBuilder.length() < 20 - n) {
                formatter.format("%s", " ");
            }
            formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.height));
            formatter.format("%60s ", AlloppMisc.FixedBitSetasText(this.union));
            double d = this.tippopindex >= 0 ? this.tippop() : -1.0;
            formatter.format("%s %s ", AlloppMisc.nonnegIntIn2Chars(this.tippopindex), AlloppMisc.nonnegIn8Chars(d));
            double d2 = this.hybpopindex >= 0 ? this.hybpop() : -1.0;
            formatter.format("%s %s ", AlloppMisc.nonnegIntIn2Chars(this.hybpopindex), AlloppMisc.nonnegIn8Chars(d2));
            double d3 = this.rootpopindex >= 0 ? this.rootpop() : -1.0;
            formatter.format("%s %s ", AlloppMisc.nonnegIntIn2Chars(this.rootpopindex), AlloppMisc.nonnegIn8Chars(d3));
            formatter.format("%s ", this.tetraroot ? "tetroot" : "       ");
            formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.hybridheight));
            formatter.format("%3d  ", this.nlineages);
            for (int i = 0; i < this.coalheights.size(); ++i) {
                formatter.format(AlloppMisc.nonnegIn8Chars(this.coalheights.get(i)) + ",", new Object[0]);
            }
            return stringBuilder.toString();
        }

        @Override
        public int nofChildren() {
            return this.lft < 0 ? 0 : 2;
        }

        @Override
        public AlloppNode getChild(int n) {
            return n == 0 ? AlloppMulLabTree.this.mlnodes[this.lft] : AlloppMulLabTree.this.mlnodes[this.rgt];
        }

        @Override
        public AlloppNode getAnc() {
            return AlloppMulLabTree.this.mlnodes[this.anc];
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public FixedBitSet getUnion() {
            return this.union;
        }

        @Override
        public void setChild(int n, AlloppNode alloppNode) {
            int n2 = ((MulLabNode)alloppNode).nodeNumber;
            if (n == 0) {
                this.lft = n2;
            } else {
                this.rgt = n2;
            }
        }

        @Override
        public void setAnc(AlloppNode alloppNode) {
            this.anc = ((MulLabNode)alloppNode).nodeNumber;
        }

        @Override
        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public void setTaxon(String string) {
            this.taxon = new Taxon(string);
        }

        @Override
        public void setHeight(double d) {
            this.height = d;
        }

        @Override
        public void setUnion(FixedBitSet fixedBitSet) {
            this.union = fixedBitSet;
        }

        @Override
        public void addChildren(AlloppNode alloppNode, AlloppNode alloppNode2) {
            this.lft = ((MulLabNode)alloppNode).nodeNumber;
            ((AlloppMulLabTree)AlloppMulLabTree.this).mlnodes[this.lft].anc = this.nodeNumber;
            this.rgt = ((MulLabNode)alloppNode2).nodeNumber;
            ((AlloppMulLabTree)AlloppMulLabTree.this).mlnodes[this.rgt].anc = this.nodeNumber;
        }

        @Override
        public int getNumber() {
            return this.nodeNumber;
        }

        @Override
        public void setNumber(int n) {
            this.nodeNumber = n;
        }
    }

    private class SpSqUnion {
        public FixedBitSet spsqunion;
        public FixedBitSet spunion;

        public SpSqUnion(FixedBitSet fixedBitSet) {
            this.spsqunion = fixedBitSet;
            this.spunion = AlloppMulLabTree.this.apsp.spsqunion2spunion(fixedBitSet);
        }
    }

    private class PopValIndices {
        public int tipp;
        public int rootp;
        public int hybp;

        PopValIndices(int n, int n2, int n3) {
            this.tipp = n;
            this.rootp = n2;
            this.hybp = n3;
        }
    }

    private class PopulationAndLineages {
        public double[] t;
        public double tippop;
        public double rootpop;
        public int tipnlin;

        public PopulationAndLineages(double[] dArray, double d, double d2, int n) {
            this.t = dArray;
            this.tippop = d;
            this.rootpop = d2;
            this.tipnlin = n;
        }

        public double populationAt(double d) {
            double d2 = this.t[0];
            double d3 = this.t[this.t.length - 1];
            return ((d3 - d) * this.tippop + (d - d2) * this.rootpop) / (d3 - d2);
        }
    }
}

