/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.VariableUtils;

public class UnArExpression
implements ArExpression {
    Model model;
    IntVar me = null;
    ArExpression.Operator op;
    private final ArExpression e;

    public UnArExpression(ArExpression.Operator op, ArExpression exp) {
        this.op = op;
        this.e = exp;
        this.model = this.e.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public ArExpression.Operator getOp() {
        return this.op;
    }

    @Override
    public int getNoChild() {
        return 1;
    }

    @Override
    public ArExpression[] getExpressionChild() {
        return new ArExpression[]{this.e};
    }

    @Override
    public IntVar intVar() {
        if (this.me == null) {
            IntVar v = this.e.intVar();
            switch (this.op) {
                case NEG: {
                    this.me = this.model.neg(v);
                    break;
                }
                case ABS: {
                    this.me = this.model.abs(v);
                    break;
                }
                case SQR: {
                    int[] bounds = VariableUtils.boundsForMultiplication(v, v);
                    this.me = this.model.intVar(this.model.generateName("sqr_exp_"), bounds[0], bounds[1]);
                    this.model.square(this.me, v).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e.ieval(values, map));
    }

    public String toString() {
        return this.op.name() + "(" + this.e.toString() + ")";
    }
}

