/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.WrapperSubsetEval;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;

public class ClassifierAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    private static final long serialVersionUID = 2442390690522602284L;
    protected Instances m_trainInstances;
    protected double[] m_merit;
    protected WrapperSubsetEval m_wrapperTemplate = new WrapperSubsetEval();
    protected String m_wrapperSetup = "";
    protected boolean m_leaveOneOut;
    protected transient ExecutorService m_pool;
    protected int m_executionSlots = 1;

    public ClassifierAttributeEval() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "ClassifierAttributeEval :\n\nEvaluates the worth of an attribute by using a user-specified classifier.\n";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration<Option> wrapperOpts = this.m_wrapperTemplate.listOptions();
        while (wrapperOpts.hasMoreElements()) {
            result.addElement(wrapperOpts.nextElement());
        }
        result.addElement(new Option("\tEvaluate an attribute by measuring the impact of leaving it out\n\tfrom the full set instead of considering its worth in isolation", "L", 0, "-L"));
        result.addElement(new Option("\tNumber of attributes to evaluate in parallel.\n\tDefault = 1 (i.e. no parallelism)", "execution-slots", 1, "-execution-slots <integer>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.m_leaveOneOut = Utils.getFlag('L', options);
        String slots = Utils.getOption("execution-slots", options);
        if (slots.length() > 0) {
            this.m_executionSlots = Integer.parseInt(slots);
        }
        this.m_wrapperTemplate.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_leaveOneOut) {
            result.add("-L");
        }
        result.add("-execution-slots");
        result.add("" + this.m_executionSlots);
        for (String o : this.m_wrapperTemplate.getOptions()) {
            result.add(o);
        }
        return result.toArray(new String[result.size()]);
    }

    public String leaveOneAttributeOutTipText() {
        return "Evaluate an attribute by measuring the impact of leaving it out from the full set instead of considering its worth in isolation.";
    }

    public void setLeaveOneAttributeOut(boolean l) {
        this.m_leaveOneOut = l;
    }

    public boolean getLeaveOneAttributeOut() {
        return this.m_leaveOneOut;
    }

    public String numToEvaluateInParallelTipText() {
        return "The number of attributes to evaluate in parallel";
    }

    public void setNumToEvaluateInParallel(int n) {
        this.m_executionSlots = n;
    }

    public int getNumToEvaluateInParallel() {
        return this.m_executionSlots;
    }

    public void setIRClassValue(String val) {
        this.m_wrapperTemplate.setIRClassValue(val);
    }

    public String getIRClassValue() {
        return this.m_wrapperTemplate.getIRClassValue();
    }

    public String IRClassValueTipText() {
        return "The class label, or 1-based index of the class label, to use when evaluating subsets with an IR metric (such as f-measure or AUC. Leaving this unset will result in the class frequency weighted average of the metric being used.";
    }

    public String evaluationMeasureTipText() {
        return "The measure used to evaluate the performance of attribute combinations.";
    }

    public SelectedTag getEvaluationMeasure() {
        return this.m_wrapperTemplate.getEvaluationMeasure();
    }

    public void setEvaluationMeasure(SelectedTag newMethod) {
        this.m_wrapperTemplate.setEvaluationMeasure(newMethod);
    }

    public String thresholdTipText() {
        return this.m_wrapperTemplate.thresholdTipText();
    }

    public void setThreshold(double t) {
        this.m_wrapperTemplate.setThreshold(t);
    }

    public double getThreshold() {
        return this.m_wrapperTemplate.getThreshold();
    }

    public String foldsTipText() {
        return this.m_wrapperTemplate.foldsTipText();
    }

    public void setFolds(int f) {
        this.m_wrapperTemplate.setFolds(f);
    }

    public int getFolds() {
        return this.m_wrapperTemplate.getFolds();
    }

    public String seedTipText() {
        return this.m_wrapperTemplate.seedTipText();
    }

    public void setSeed(int s) {
        this.m_wrapperTemplate.setSeed(s);
    }

    public int getSeed() {
        return this.m_wrapperTemplate.getSeed();
    }

    public String classifierTipText() {
        return this.m_wrapperTemplate.classifierTipText();
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_wrapperTemplate.setClassifier(newClassifier);
    }

    public Classifier getClassifier() {
        return this.m_wrapperTemplate.getClassifier();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.m_wrapperTemplate.getClassifier().getCapabilities();
        result.setOwner(this);
        return result;
    }

    @Override
    public void buildEvaluator(final Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = new Instances(data, 0);
        double baseMerit = 0.0;
        this.m_merit = new double[data.numAttributes()];
        this.m_pool = Executors.newFixedThreadPool(this.m_executionSlots);
        HashSet<Future<double[]>> results = new HashSet<Future<double[]>>();
        for (int i = -1; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            final int n = i;
            Future<double[]> futureEval = this.m_pool.submit(new Callable<double[]>(){

                @Override
                public double[] call() throws Exception {
                    double[] eval = new double[2];
                    eval[0] = n;
                    WrapperSubsetEval evaluator = new WrapperSubsetEval();
                    evaluator.setOptions(ClassifierAttributeEval.this.m_wrapperTemplate.getOptions());
                    evaluator.buildEvaluator(data);
                    if (ClassifierAttributeEval.this.m_wrapperSetup.length() == 0) {
                        ClassifierAttributeEval.this.m_wrapperSetup = evaluator.toString();
                    }
                    BitSet b = new BitSet(data.numAttributes());
                    if (ClassifierAttributeEval.this.m_leaveOneOut) {
                        b.set(0, data.numAttributes());
                        b.set(data.classIndex(), false);
                    }
                    if (n >= 0) {
                        b.set(n, !ClassifierAttributeEval.this.m_leaveOneOut);
                    }
                    eval[1] = evaluator.evaluateSubset(b);
                    return eval;
                }
            });
            results.add(futureEval);
        }
        for (Future future : results) {
            if (((double[])future.get())[0] != -1.0) {
                this.m_merit[(int)((double[])future.get())[0]] = ((double[])future.get())[1];
                continue;
            }
            baseMerit = ((double[])future.get())[1];
        }
        for (int i = 0; i < data.numAttributes(); ++i) {
            this.m_merit[i] = this.m_leaveOneOut ? baseMerit - this.m_merit[i] : this.m_merit[i] - baseMerit;
        }
        this.m_pool.shutdown();
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_wrapperTemplate = new WrapperSubsetEval();
        this.m_wrapperSetup = "";
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        return this.m_merit[attribute];
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tClassifier feature evaluator has not been built yet");
        } else {
            text.append("\tClassifier feature evaluator " + (this.m_leaveOneOut ? "(leave one out)" : "") + "\n\n");
            text.append("\tUsing ");
            text.append(this.m_wrapperSetup);
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14195 $");
    }

    public static void main(String[] args) {
        ClassifierAttributeEval.runEvaluator(new ClassifierAttributeEval(), args);
    }
}

