/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;

public class Tee
extends PrintStream {
    protected Vector m_Streams = new Vector();
    protected Vector m_Timestamps = new Vector();
    protected Vector m_Prefixes = new Vector();
    protected PrintStream m_Default = null;

    public Tee() {
        this((PrintStream)null);
    }

    public Tee(PrintStream printStream) {
        super(printStream);
        this.m_Default = printStream;
        this.clear();
    }

    public void clear() {
        this.m_Streams.clear();
        this.m_Timestamps.clear();
        this.m_Prefixes.clear();
        if (this.getDefault() != null) {
            this.add(this.getDefault());
        }
    }

    public PrintStream getDefault() {
        return this.m_Default;
    }

    public void add(PrintStream printStream) {
        this.add(printStream, false);
    }

    public void add(PrintStream printStream, boolean bl) {
        this.add(printStream, bl, "");
    }

    public void add(PrintStream printStream, boolean bl, String string) {
        if (this.m_Streams.contains(printStream)) {
            this.remove(printStream);
        }
        if (string == null) {
            string = "";
        }
        this.m_Streams.add(printStream);
        this.m_Timestamps.add(new Boolean(bl));
        this.m_Prefixes.add(string);
    }

    public PrintStream get(int n) {
        if (n >= 0 && n < this.size()) {
            return (PrintStream)this.m_Streams.get(n);
        }
        return null;
    }

    public PrintStream remove(PrintStream printStream) {
        if (this.contains(printStream)) {
            int n = this.m_Streams.indexOf(printStream);
            this.m_Timestamps.remove(n);
            this.m_Prefixes.remove(n);
            return (PrintStream)this.m_Streams.remove(n);
        }
        return null;
    }

    public PrintStream remove(int n) {
        if (n >= 0 && n < this.size()) {
            this.m_Timestamps.remove(n);
            this.m_Prefixes.remove(n);
            return (PrintStream)this.m_Streams.remove(n);
        }
        return null;
    }

    public boolean contains(PrintStream printStream) {
        return this.m_Streams.contains(printStream);
    }

    public int size() {
        return this.m_Streams.size();
    }

    private void printHeader() {
        for (int i = 0; i < this.size(); ++i) {
            if (!((String)this.m_Prefixes.get(i)).equals("")) {
                ((PrintStream)this.m_Streams.get(i)).print("[" + this.m_Prefixes.get(i) + "]\t");
            }
            if (!((Boolean)this.m_Timestamps.get(i)).booleanValue()) continue;
            ((PrintStream)this.m_Streams.get(i)).print("[" + new Date() + "]\t");
        }
    }

    public void flush() {
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).flush();
        }
    }

    public void print(int n) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).print(n);
        }
        this.flush();
    }

    public void print(boolean bl) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).print(bl);
        }
        this.flush();
    }

    public void print(String string) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).print(string);
        }
        this.flush();
    }

    public void print(Object object) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).print(object);
        }
        this.flush();
    }

    public void println() {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).println();
        }
        this.flush();
    }

    public void println(int n) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).println(n);
        }
        this.flush();
    }

    public void println(boolean bl) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).println(bl);
        }
        this.flush();
    }

    public void println(String string) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            ((PrintStream)this.m_Streams.get(i)).println(string);
        }
        this.flush();
    }

    public void println(Object object) {
        int n;
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            String string = throwable.toString() + "\n";
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                string = string + "\t" + stackTraceElementArray[n].toString() + "\n";
            }
            object = string;
        }
        this.printHeader();
        for (n = 0; n < this.size(); ++n) {
            ((PrintStream)this.m_Streams.get(n)).println(object);
        }
        this.flush();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_Streams.size();
    }
}

