/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Random;
import weka.associations.ItemSet;
import weka.associations.RuleItem;
import weka.core.Instances;
import weka.core.SpecialFunctions;
import weka.core.Utils;

public class PriorEstimation
implements Serializable {
    protected int m_numRandRules;
    protected int m_numIntervals;
    protected static final int SEED = 0;
    protected static final int MAX_N = 1024;
    protected Random m_randNum;
    protected Instances m_instances;
    protected boolean m_CARs;
    protected Hashtable m_distribution;
    protected Hashtable m_priors;
    protected double m_sum;
    protected double[] m_midPoints;

    public PriorEstimation(Instances instances, int n, int n2, boolean bl) {
        this.m_instances = instances;
        this.m_CARs = bl;
        this.m_numRandRules = n;
        this.m_numIntervals = n2;
        this.m_randNum = this.m_instances.getRandomNumberGenerator(0L);
    }

    public final void generateDistribution() throws Exception {
        int n;
        int n2 = this.m_instances.numAttributes();
        int n3 = 0;
        boolean bl = false;
        this.m_distribution = new Hashtable(n2 * this.m_numIntervals);
        if (this.m_instances.numAttributes() == 0) {
            throw new Exception("Dataset has no attributes!");
        }
        if (this.m_instances.numAttributes() >= 1024) {
            throw new Exception("Dataset has to many attributes for prior estimation!");
        }
        if (this.m_instances.numInstances() == 0) {
            throw new Exception("Dataset has no instances!");
        }
        for (n = 0; n < n2; ++n) {
            if (!this.m_instances.attribute(n).isNumeric()) continue;
            throw new Exception("Can't handle numeric attributes!");
        }
        if (this.m_numIntervals == 0 || this.m_numRandRules == 0) {
            throw new Exception("Prior initialisation impossible");
        }
        this.midPoints();
        for (int i = 1; i <= n2; ++i) {
            int n4;
            this.m_sum = 0.0;
            n3 = 0;
            bl = false;
            for (n = 0; n < this.m_numRandRules; ++n) {
                RuleItem ruleItem;
                int[] nArray;
                ++n3;
                boolean bl2 = false;
                if (!this.m_CARs) {
                    nArray = this.randomRule(n2, i, this.m_randNum);
                    ruleItem = this.splitItemSet(this.m_randNum.nextInt(i), nArray);
                } else {
                    nArray = this.randomCARule(n2, i, this.m_randNum);
                    ruleItem = this.addCons(nArray);
                }
                int[] nArray2 = new int[n2];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray2[j] = ruleItem.m_premise.m_items[j] != -1 ? ruleItem.m_premise.m_items[j] : (ruleItem.m_consequence.m_items[j] != -1 ? ruleItem.m_consequence.m_items[j] : -1);
                }
                ItemSet itemSet = new ItemSet(nArray2);
                this.updateCounters(itemSet);
                int n5 = itemSet.m_counter;
                if (n5 > 0) {
                    bl2 = true;
                }
                this.updateCounters(ruleItem.m_premise);
                if (!bl2) continue;
                this.buildDistribution((double)n5 / (double)ruleItem.m_premise.m_counter, i);
            }
            if (this.m_sum > 0.0) {
                for (n4 = 0; n4 < this.m_midPoints.length; ++n4) {
                    String string = String.valueOf(this.m_midPoints[n4]).concat(String.valueOf((double)i));
                    Double d = (Double)this.m_distribution.remove(string);
                    if (d == null) {
                        this.m_distribution.put(string, new Double(1.0 / (double)this.m_numIntervals));
                        this.m_sum += 1.0 / (double)this.m_numIntervals;
                        continue;
                    }
                    this.m_distribution.put(string, d);
                }
                for (n4 = 0; n4 < this.m_midPoints.length; ++n4) {
                    double d = 0.0;
                    String string = String.valueOf(this.m_midPoints[n4]).concat(String.valueOf((double)i));
                    Double d2 = (Double)this.m_distribution.remove(string);
                    if (d2 == null) continue;
                    d = d2 / this.m_sum;
                    this.m_distribution.put(string, new Double(d));
                }
                continue;
            }
            for (n4 = 0; n4 < this.m_midPoints.length; ++n4) {
                String string = String.valueOf(this.m_midPoints[n4]).concat(String.valueOf((double)i));
                this.m_distribution.put(string, new Double(1.0 / (double)this.m_numIntervals));
            }
        }
    }

    public final int[] randomRule(int n, int n2, Random random) {
        int n3;
        int n4;
        int[] nArray = new int[n];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = -1;
        }
        n4 = n2;
        if (n4 == n) {
            n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = this.m_randNum.nextInt(this.m_instances.attribute(n3).numValues());
            }
        }
        while (n4 > 0) {
            n3 = random.nextInt(n);
            if (nArray[n3] != -1) continue;
            --n4;
            nArray[n3] = this.m_randNum.nextInt(this.m_instances.attribute(n3).numValues());
        }
        return nArray;
    }

    public final int[] randomCARule(int n, int n2, Random random) {
        int n3;
        int n4;
        int[] nArray = new int[n];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = -1;
        }
        if (n2 == 1) {
            return nArray;
        }
        n4 = n2 - 1;
        if (n4 == n - 1) {
            n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (n3 == this.m_instances.classIndex()) continue;
                nArray[n3] = this.m_randNum.nextInt(this.m_instances.attribute(n3).numValues());
            }
        }
        while (n4 > 0) {
            n3 = random.nextInt(n);
            if (nArray[n3] != -1 || n3 == this.m_instances.classIndex()) continue;
            --n4;
            nArray[n3] = this.m_randNum.nextInt(this.m_instances.attribute(n3).numValues());
        }
        return nArray;
    }

    public final void buildDistribution(double d, double d2) {
        double d3 = this.findIntervall(d);
        String string = String.valueOf(d3).concat(String.valueOf(d2));
        this.m_sum += d;
        Double d4 = (Double)this.m_distribution.remove(string);
        if (d4 != null) {
            d += d4.doubleValue();
        }
        this.m_distribution.put(string, new Double(d));
    }

    public final double findIntervall(double d) {
        if (d == 1.0) {
            return this.m_midPoints[this.m_midPoints.length - 1];
        }
        int n = this.m_midPoints.length - 1;
        int n2 = 0;
        while (Math.abs(n - n2) > 1) {
            int n3 = (n2 + n) / 2;
            if (d > this.m_midPoints[n3]) {
                n2 = n3 + 1;
            }
            if (d < this.m_midPoints[n3]) {
                n = n3 - 1;
            }
            if (d != this.m_midPoints[n3]) continue;
            return this.m_midPoints[n3];
        }
        if (Math.abs(d - this.m_midPoints[n2]) <= Math.abs(d - this.m_midPoints[n])) {
            return this.m_midPoints[n2];
        }
        return this.m_midPoints[n];
    }

    public final double calculatePriorSum(boolean bl, double d) {
        double d2 = 0.0;
        double d3 = PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), this.m_instances.numAttributes() / 2);
        for (int i = 1; i <= this.m_instances.numAttributes(); ++i) {
            if (bl) {
                String string = String.valueOf(d).concat(String.valueOf((double)i));
                Double d4 = (Double)this.m_distribution.get(string);
                double d5 = d4 != null ? d4 : 0.0;
                if (d5 == 0.0) continue;
                double d6 = Utils.log2(d5) - d3 + Utils.log2(Math.pow(2.0, i) - 1.0) + PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), i);
                d2 += Math.pow(2.0, d6);
                continue;
            }
            double d7 = Utils.log2(Math.pow(2.0, i) - 1.0) - d3 + PriorEstimation.logbinomialCoefficient(this.m_instances.numAttributes(), i);
            d2 += Math.pow(2.0, d7);
        }
        return d2;
    }

    public static final double logbinomialCoefficient(int n, int n2) {
        double d = 1.0;
        if (n == n2 || n2 == 0) {
            return d;
        }
        d = SpecialFunctions.log2Binomial(n, n2);
        return d;
    }

    public final Hashtable estimatePrior() throws Exception {
        Hashtable<Double, Double> hashtable = new Hashtable<Double, Double>(this.m_numIntervals);
        double d = this.calculatePriorSum(false, 1.0);
        this.generateDistribution();
        for (int i = 0; i < this.m_numIntervals; ++i) {
            double d2 = this.m_midPoints[i];
            double d3 = this.calculatePriorSum(true, d2) / d;
            hashtable.put(new Double(d2), new Double(d3));
        }
        return hashtable;
    }

    public final void midPoints() {
        this.m_midPoints = new double[this.m_numIntervals];
        for (int i = 0; i < this.m_numIntervals; ++i) {
            this.m_midPoints[i] = this.midPoint(1.0 / (double)this.m_numIntervals, i);
        }
    }

    public double midPoint(double d, int n) {
        return d * (double)n + d / 2.0;
    }

    public final double[] getMidPoints() {
        return this.m_midPoints;
    }

    public final RuleItem splitItemSet(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[this.m_instances.numAttributes()];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        int n3 = n;
        while (n3 > 0) {
            n2 = this.m_randNum.nextInt(nArray.length);
            if (nArray2[n2] == -1) continue;
            --n3;
            nArray2[n2] = -1;
        }
        if (n == 0) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = -1;
            }
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray2[n2] == -1) continue;
                nArray[n2] = -1;
            }
        }
        ItemSet itemSet = new ItemSet(nArray);
        ItemSet itemSet2 = new ItemSet(nArray2);
        RuleItem ruleItem = new RuleItem();
        ruleItem.m_premise = itemSet;
        ruleItem.m_consequence = itemSet2;
        return ruleItem;
    }

    public final RuleItem addCons(int[] nArray) {
        ItemSet itemSet = new ItemSet(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = -1;
        }
        nArray2[this.m_instances.classIndex()] = this.m_randNum.nextInt(this.m_instances.attribute(this.m_instances.classIndex()).numValues());
        ItemSet itemSet2 = new ItemSet(nArray2);
        RuleItem ruleItem = new RuleItem();
        ruleItem.m_premise = itemSet;
        ruleItem.m_consequence = itemSet2;
        return ruleItem;
    }

    public final void updateCounters(ItemSet itemSet) {
        for (int i = 0; i < this.m_instances.numInstances(); ++i) {
            itemSet.upDateCounter(this.m_instances.instance(i));
        }
    }
}

