/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Distribution
implements Cloneable,
Serializable {
    private double[][] m_perClassPerBag;
    private double[] m_perBag;
    private double[] m_perClass;
    private double totaL;

    public Distribution(int n, int n2) {
        this.m_perClassPerBag = new double[n][0];
        this.m_perBag = new double[n];
        this.m_perClass = new double[n2];
        for (int i = 0; i < n; ++i) {
            this.m_perClassPerBag[i] = new double[n2];
        }
        this.totaL = 0.0;
    }

    public Distribution(double[][] dArray) {
        this.m_perClassPerBag = dArray;
        this.m_perBag = new double[dArray.length];
        this.m_perClass = new double[dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                int n = i;
                this.m_perBag[n] = this.m_perBag[n] + dArray[i][j];
                int n2 = j;
                this.m_perClass[n2] = this.m_perClass[n2] + dArray[i][j];
                this.totaL += dArray[i][j];
            }
        }
    }

    public Distribution(Instances instances) throws Exception {
        this.m_perClassPerBag = new double[1][0];
        this.m_perBag = new double[1];
        this.totaL = 0.0;
        this.m_perClass = new double[instances.numClasses()];
        this.m_perClassPerBag[0] = new double[instances.numClasses()];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.add(0, (Instance)enumeration.nextElement());
        }
    }

    public Distribution(Instances instances, ClassifierSplitModel classifierSplitModel) throws Exception {
        this.m_perClassPerBag = new double[classifierSplitModel.numSubsets()][0];
        this.m_perBag = new double[classifierSplitModel.numSubsets()];
        this.totaL = 0.0;
        this.m_perClass = new double[instances.numClasses()];
        for (int i = 0; i < classifierSplitModel.numSubsets(); ++i) {
            this.m_perClassPerBag[i] = new double[instances.numClasses()];
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n = classifierSplitModel.whichSubset(instance);
            if (n != -1) {
                this.add(n, instance);
                continue;
            }
            double[] dArray = classifierSplitModel.weights(instance);
            this.addWeights(instance, dArray);
        }
    }

    public Distribution(Distribution distribution) {
        this.totaL = distribution.totaL;
        this.m_perClass = new double[distribution.numClasses()];
        System.arraycopy(distribution.m_perClass, 0, this.m_perClass, 0, distribution.numClasses());
        this.m_perClassPerBag = new double[1][0];
        this.m_perClassPerBag[0] = new double[distribution.numClasses()];
        System.arraycopy(distribution.m_perClass, 0, this.m_perClassPerBag[0], 0, distribution.numClasses());
        this.m_perBag = new double[1];
        this.m_perBag[0] = this.totaL;
    }

    public Distribution(Distribution distribution, int n) {
        this.totaL = distribution.totaL;
        this.m_perClass = new double[distribution.numClasses()];
        System.arraycopy(distribution.m_perClass, 0, this.m_perClass, 0, distribution.numClasses());
        this.m_perClassPerBag = new double[2][0];
        this.m_perClassPerBag[0] = new double[distribution.numClasses()];
        System.arraycopy(distribution.m_perClassPerBag[n], 0, this.m_perClassPerBag[0], 0, distribution.numClasses());
        this.m_perClassPerBag[1] = new double[distribution.numClasses()];
        for (int i = 0; i < distribution.numClasses(); ++i) {
            this.m_perClassPerBag[1][i] = distribution.m_perClass[i] - this.m_perClassPerBag[0][i];
        }
        this.m_perBag = new double[2];
        this.m_perBag[0] = distribution.m_perBag[n];
        this.m_perBag[1] = this.totaL - this.m_perBag[0];
    }

    public final int actualNumBags() {
        int n = 0;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.gr(this.m_perBag[i], 0.0)) continue;
            ++n;
        }
        return n;
    }

    public final int actualNumClasses() {
        int n = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClass[i], 0.0)) continue;
            ++n;
        }
        return n;
    }

    public final int actualNumClasses(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClassPerBag[n][i], 0.0)) continue;
            ++n2;
        }
        return n2;
    }

    public final void add(int n, Instance instance) throws Exception {
        int n2 = (int)instance.classValue();
        double d = instance.weight();
        this.m_perClassPerBag[n][n2] = this.m_perClassPerBag[n][n2] + d;
        this.m_perBag[n] = this.m_perBag[n] + d;
        this.m_perClass[n2] = this.m_perClass[n2] + d;
        this.totaL += d;
    }

    public final void sub(int n, Instance instance) throws Exception {
        int n2 = (int)instance.classValue();
        double d = instance.weight();
        this.m_perClassPerBag[n][n2] = this.m_perClassPerBag[n][n2] - d;
        this.m_perBag[n] = this.m_perBag[n] - d;
        this.m_perClass[n2] = this.m_perClass[n2] - d;
        this.totaL -= d;
    }

    public final void add(int n, double[] dArray) {
        int n2;
        double d = Utils.sum(dArray);
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double[] dArray2 = this.m_perClassPerBag[n];
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + dArray[n2];
        }
        this.m_perBag[n] = this.m_perBag[n] + d;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.m_perClass[n2] = this.m_perClass[n2] + dArray[n2];
        }
        this.totaL += d;
    }

    public final void addInstWithUnknown(Instances instances, int n) throws Exception {
        int n2;
        double[] dArray = new double[this.m_perBag.length];
        for (n2 = 0; n2 < this.m_perBag.length; ++n2) {
            dArray[n2] = Utils.eq(this.totaL, 0.0) ? 1.0 / (double)dArray.length : this.m_perBag[n2] / this.totaL;
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (!instance.isMissing(n)) continue;
            int n3 = (int)instance.classValue();
            double d = instance.weight();
            this.m_perClass[n3] = this.m_perClass[n3] + d;
            this.totaL += d;
            for (n2 = 0; n2 < this.m_perBag.length; ++n2) {
                double d2 = dArray[n2] * d;
                this.m_perClassPerBag[n2][n3] = this.m_perClassPerBag[n2][n3] + d2;
                this.m_perBag[n2] = this.m_perBag[n2] + d2;
            }
        }
    }

    public final void addRange(int n, Instances instances, int n2, int n3) throws Exception {
        double d = 0.0;
        for (int i = n2; i < n3; ++i) {
            Instance instance = instances.instance(i);
            int n4 = (int)instance.classValue();
            d += instance.weight();
            double[] dArray = this.m_perClassPerBag[n];
            int n5 = n4;
            dArray[n5] = dArray[n5] + instance.weight();
            int n6 = n4;
            this.m_perClass[n6] = this.m_perClass[n6] + instance.weight();
        }
        int n7 = n;
        this.m_perBag[n7] = this.m_perBag[n7] + d;
        this.totaL += d;
    }

    public final void addWeights(Instance instance, double[] dArray) throws Exception {
        int n = (int)instance.classValue();
        for (int i = 0; i < this.m_perBag.length; ++i) {
            double d = instance.weight() * dArray[i];
            this.m_perClassPerBag[i][n] = this.m_perClassPerBag[i][n] + d;
            this.m_perBag[i] = this.m_perBag[i] + d;
            this.m_perClass[n] = this.m_perClass[n] + d;
            this.totaL += d;
        }
    }

    public final boolean check(double d) {
        int n = 0;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.grOrEq(this.m_perBag[i], d)) continue;
            ++n;
        }
        return n > 1;
    }

    public final Object clone() {
        int n;
        Distribution distribution = new Distribution(this.m_perBag.length, this.m_perClass.length);
        for (int i = 0; i < this.m_perBag.length; ++i) {
            distribution.m_perBag[i] = this.m_perBag[i];
            for (n = 0; n < this.m_perClass.length; ++n) {
                distribution.m_perClassPerBag[i][n] = this.m_perClassPerBag[i][n];
            }
        }
        for (n = 0; n < this.m_perClass.length; ++n) {
            distribution.m_perClass[n] = this.m_perClass[n];
        }
        distribution.totaL = this.totaL;
        return distribution;
    }

    public final void del(int n, Instance instance) throws Exception {
        int n2 = (int)instance.classValue();
        double d = instance.weight();
        this.m_perClassPerBag[n][n2] = this.m_perClassPerBag[n][n2] - d;
        this.m_perBag[n] = this.m_perBag[n] - d;
        this.m_perClass[n2] = this.m_perClass[n2] - d;
        this.totaL -= d;
    }

    public final void delRange(int n, Instances instances, int n2, int n3) throws Exception {
        double d = 0.0;
        for (int i = n2; i < n3; ++i) {
            Instance instance = instances.instance(i);
            int n4 = (int)instance.classValue();
            d += instance.weight();
            double[] dArray = this.m_perClassPerBag[n];
            int n5 = n4;
            dArray[n5] = dArray[n5] - instance.weight();
            int n6 = n4;
            this.m_perClass[n6] = this.m_perClass[n6] - instance.weight();
        }
        int n7 = n;
        this.m_perBag[n7] = this.m_perBag[n7] - d;
        this.totaL -= d;
    }

    public final String dumpDistribution() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_perBag.length; ++i) {
            stringBuffer.append("Bag num " + i + "\n");
            for (int j = 0; j < this.m_perClass.length; ++j) {
                stringBuffer.append("Class num " + j + " " + this.m_perClassPerBag[i][j] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public final void initialize() {
        int n;
        for (n = 0; n < this.m_perClass.length; ++n) {
            this.m_perClass[n] = 0.0;
        }
        for (n = 0; n < this.m_perBag.length; ++n) {
            this.m_perBag[n] = 0.0;
        }
        for (n = 0; n < this.m_perBag.length; ++n) {
            for (int i = 0; i < this.m_perClass.length; ++i) {
                this.m_perClassPerBag[n][i] = 0.0;
            }
        }
        this.totaL = 0.0;
    }

    public final double[][] matrix() {
        return this.m_perClassPerBag;
    }

    public final int maxBag() {
        double d = 0.0;
        int n = -1;
        for (int i = 0; i < this.m_perBag.length; ++i) {
            if (!Utils.grOrEq(this.m_perBag[i], d)) continue;
            d = this.m_perBag[i];
            n = i;
        }
        return n;
    }

    public final int maxClass() {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.m_perClass.length; ++i) {
            if (!Utils.gr(this.m_perClass[i], d)) continue;
            d = this.m_perClass[i];
            n = i;
        }
        return n;
    }

    public final int maxClass(int n) {
        double d = 0.0;
        int n2 = 0;
        if (Utils.gr(this.m_perBag[n], 0.0)) {
            for (int i = 0; i < this.m_perClass.length; ++i) {
                if (!Utils.gr(this.m_perClassPerBag[n][i], d)) continue;
                d = this.m_perClassPerBag[n][i];
                n2 = i;
            }
            return n2;
        }
        return this.maxClass();
    }

    public final int numBags() {
        return this.m_perBag.length;
    }

    public final int numClasses() {
        return this.m_perClass.length;
    }

    public final double numCorrect() {
        return this.m_perClass[this.maxClass()];
    }

    public final double numCorrect(int n) {
        return this.m_perClassPerBag[n][this.maxClass(n)];
    }

    public final double numIncorrect() {
        return this.totaL - this.numCorrect();
    }

    public final double numIncorrect(int n) {
        return this.m_perBag[n] - this.numCorrect(n);
    }

    public final double perClassPerBag(int n, int n2) {
        return this.m_perClassPerBag[n][n2];
    }

    public final double perBag(int n) {
        return this.m_perBag[n];
    }

    public final double perClass(int n) {
        return this.m_perClass[n];
    }

    public final double laplaceProb(int n) {
        return (this.m_perClass[n] + 1.0) / (this.totaL + (double)this.actualNumClasses());
    }

    public final double laplaceProb(int n, int n2) {
        return (this.m_perClassPerBag[n2][n] + 1.0) / (this.m_perBag[n2] + (double)this.actualNumClasses());
    }

    public final double prob(int n) {
        if (!Utils.eq(this.totaL, 0.0)) {
            return this.m_perClass[n] / this.totaL;
        }
        return 0.0;
    }

    public final double prob(int n, int n2) {
        if (Utils.gr(this.m_perBag[n2], 0.0)) {
            return this.m_perClassPerBag[n2][n] / this.m_perBag[n2];
        }
        return this.prob(n);
    }

    public final Distribution subtract(Distribution distribution) {
        Distribution distribution2 = new Distribution(1, this.m_perClass.length);
        distribution2.m_perBag[0] = this.totaL - distribution.totaL;
        distribution2.totaL = distribution2.m_perBag[0];
        for (int i = 0; i < this.m_perClass.length; ++i) {
            distribution2.m_perClassPerBag[0][i] = this.m_perClass[i] - distribution.m_perClass[i];
            distribution2.m_perClass[i] = distribution2.m_perClassPerBag[0][i];
        }
        return distribution2;
    }

    public final double total() {
        return this.totaL;
    }

    public final void shift(int n, int n2, Instance instance) throws Exception {
        int n3 = (int)instance.classValue();
        double d = instance.weight();
        double[] dArray = this.m_perClassPerBag[n];
        int n4 = n3;
        dArray[n4] = dArray[n4] - d;
        double[] dArray2 = this.m_perClassPerBag[n2];
        int n5 = n3;
        dArray2[n5] = dArray2[n5] + d;
        int n6 = n;
        this.m_perBag[n6] = this.m_perBag[n6] - d;
        int n7 = n2;
        this.m_perBag[n7] = this.m_perBag[n7] + d;
    }

    public final void shiftRange(int n, int n2, Instances instances, int n3, int n4) throws Exception {
        for (int i = n3; i < n4; ++i) {
            Instance instance = instances.instance(i);
            int n5 = (int)instance.classValue();
            double d = instance.weight();
            double[] dArray = this.m_perClassPerBag[n];
            int n6 = n5;
            dArray[n6] = dArray[n6] - d;
            double[] dArray2 = this.m_perClassPerBag[n2];
            int n7 = n5;
            dArray2[n7] = dArray2[n7] + d;
            int n8 = n;
            this.m_perBag[n8] = this.m_perBag[n8] - d;
            int n9 = n2;
            this.m_perBag[n9] = this.m_perBag[n9] + d;
        }
    }
}

