# GTAPViz: R Package for Automating GTAP Data Processing and Visualization

## **Overview** 

**GTAPViz** is an R package designed to streamline the processing and visualization of GTAP-CGE results. While primarily built for **GTAP simulations, it also supports other `.har` and `.sl4` datasets**. 

With intuitive commands and automated adjustments, users can create, customize, and export high-quality visualizations for journal publications, economic analysis, and research reports—all with minimal coding. 

## **Key Features**  

This package streamlines the creation of figures and tables from `.har` and `.sl4` results, making academic presentations effortless. Some key features are:

- **Effortless Multi-Plot Generation** – Automatically adjusts dimensions, facets, and layout with minimal input.  

- **Smart Plot Adjustments** – Fine-tune visuals easily without manual sizing or layout tweaks.  

- **Dual Export Plot Formats** – Instantly save high-resolution PNG and PDF outputs for slides, papers, and LaTeX. 

- **Publication-Ready Pivot Tables** – Generate clean tables alongside figures—ideal for academic papers.  

- **Streamlined Styling** – Customize colors, fonts, and legends through simple, flexible options.  

- **Powerful Yet Simple** – Built on `ggplot2`, with intuitive `TRUE/FALSE` switches—no advanced coding needed.  

- **Self-Contained Help** – Includes a detailed vignette and internal help—no need to search online.


## **Installation**

GTAPViz can be installed from GitHub using the following command in R:

```r
devtools::install_github("Bodysbobb/GTAPViz")
```


## **Package Helps**

The most interactive package help is available via [ChatGPT GTAPViz](https://chatgpt.com/g/g-67f87a78396c81919aa2a0676c40e8b3-gtapviz-r/), specifically designed to assist with the GTAPViz package!

For complete instructions on using this package and exploring practical examples:

- [GTAPViz Step-by-Step Guide](https://bodysbobb.github.io/GTAPViz/)  
- [GTAPViz: Plot Catalogs](https://pattawee.shinyapps.io/gtapviz-advanced-plot-configs/)  
- [GTAPViz: Table Catalogs](https://pattawee.shinyapps.io/gtapviz-advanced-table-configs/)

## **GTAP Users** 

For GTAP users seeking minimal or no code modifications, please visit [GTAPViz for GTAP Users](https://bodysbobb.github.io/GTAPViz-R-GTAPuser/).

## **Useful Packages for CGE Fellows**

- [HARplus](https://bodysbobb.github.io/HARplus/)

## **Author:**  
**Pattawee Puangchit**  
Ph.D. Candidate, Agricultural Economics  
Purdue University  
Research Assistant at GTAP  
