/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.DefaultModel;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;

public class ValuesPool
extends DefaultModel {
    private final Variable<Double> pool;
    private final Variable<Double> selector;
    private final double defaultValue;
    private final Bounds<Double> bounds = new Bounds<Double>(){

        @Override
        public Double getUpperLimit(int n) {
            int n2 = ValuesPool.this.get(n);
            return n2 < 0 ? ValuesPool.this.defaultValue : (Double)ValuesPool.this.pool.getBounds().getUpperLimit(n2);
        }

        @Override
        public Double getLowerLimit(int n) {
            int n2 = ValuesPool.this.get(n);
            return n2 < 0 ? ValuesPool.this.defaultValue : (Double)ValuesPool.this.pool.getBounds().getLowerLimit(n2);
        }

        @Override
        public int getBoundsDimension() {
            return ValuesPool.this.pool.getSize();
        }
    };
    private final Statistic numberOfParams = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "numberOfParams";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            double d = -1.0;
            for (int i = 0; i < ValuesPool.this.selector.getSize(); ++i) {
                Double d2 = (Double)ValuesPool.this.selector.getValue(i);
                if (!(d2 > d)) continue;
                d = d2;
            }
            return d + 1.0;
        }
    };

    ValuesPool(Variable<Double> variable, Variable<Double> variable2, Double d) {
        this.pool = variable;
        this.selector = variable2;
        this.defaultValue = d;
        assert (variable.getSize() == variable2.getSize());
        this.addVariable(variable);
        this.addVariable(variable2);
        this.addStatistic(this.numberOfParams);
    }

    public Variable<Double> getPool() {
        return this.pool;
    }

    public Variable<Double> getSelector() {
        return this.selector;
    }

    public int length() {
        return this.pool.getSize();
    }

    private int get(int n) {
        double d = this.selector.getValue(n);
        return d < 0.0 ? -1 : (int)(d + 0.5);
    }

    public Double getValue(int n) {
        int n2 = this.get(n);
        return n2 < 0 ? this.defaultValue : this.pool.getValue(n2);
    }

    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    public boolean hasChanged(int n, Object object, int n2) {
        return object == this.pool ? this.get(n) == n2 : object == this.selector && n == n2;
    }
}

