library(shiny)
library(bslib)

# Define UI for dataset viewer app ----
ui <- page_sidebar(

  # App title ----
  title = "Shiny Text",

  # Sidebar panel for inputs ----
  sidebar = sidebar(

    # Input: Selector for choosing dataset ----
    selectInput(
      inputId = "dataset",
      label = "Choose a dataset:",
      choices = c("rock", "pressure", "cars")
    ),

    # Input: Numeric entry for number of obs to view ----
    numericInput(
      inputId = "obs",
      label = "Number of observations to view:",
      value = 10
    )
  ),

  # Output: Verbatim text for data summary ----
  verbatimTextOutput("summary"),

  # Output: HTML table with requested number of observations ----
  tableOutput("view")
)

# Define server logic to summarize and view selected dataset ----
server <- function(input, output) {

  # Return the requested dataset ----
  datasetInput <- reactive({
    switch(
      input$dataset,
      "rock" = rock,
      "pressure" = pressure,
      "cars" = cars
    )
  })

  # Generate a summary of the dataset ----
  output$summary <- renderPrint({
    dataset <- datasetInput()
    summary(dataset)
  })

  # Show the first "n" observations ----
  output$view <- renderTable({
    head(datasetInput(), n = input$obs)
  })
}

# Create Shiny app ----
shinyApp(ui = ui, server = server)
