/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.dataStructures;

import choco.cp.solver.constraints.global.geost.dataStructures.HeapImpl;
import choco.cp.solver.constraints.global.geost.dataStructures.Heapable;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public final class HeapDescending
extends ArrayList<Heapable>
implements HeapImpl {
    private static final long serialVersionUID = -1098658235927216892L;

    public HeapDescending(Heapable[] anArray) {
        super(anArray.length);
        int i;
        this.ensureCapacity(anArray.length);
        for (i = 0; i < anArray.length; ++i) {
            this.set(i, anArray[i]);
        }
        for (i = (int)Math.floor(this.size() / 2) - 1; i >= 0; --i) {
            this.heapify(i);
        }
    }

    public HeapDescending() {
        super(0);
    }

    protected int left(int i) {
        return (i + 1 << 1) - 1;
    }

    protected int right(int i) {
        return i + 1 << 1;
    }

    protected int parent(int i) {
        return (i + 1 >> 1) - 1;
    }

    protected synchronized void exchange(int i, int j) {
        Heapable temp = (Heapable)this.get(j);
        this.set(j, this.get(i));
        this.set(i, temp);
    }

    protected synchronized void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int largest = l < this.size() && ((Heapable)this.get(l)).greaterThan(this.get(i)) ? l : i;
        if (r < this.size() && ((Heapable)this.get(r)).greaterThan(this.get(largest))) {
            largest = r;
        }
        if (largest != i) {
            this.exchange(i, largest);
            this.heapify(largest);
        }
    }

    public synchronized Heapable extractMax() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        Object max = this.get(0);
        this.set(0, this.get(this.size() - 1));
        this.remove(this.size() - 1);
        this.heapify(0);
        return (Heapable)max;
    }

    public synchronized Heapable getMax() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        Object max = this.get(0);
        return (Heapable)max;
    }

    @Override
    public Heapable remove() throws NoSuchElementException {
        return this.extractMax();
    }

    @Override
    public synchronized void insert(Heapable key) {
        int i = this.size();
        this.ensureCapacity(this.size() + 1);
        while (i > 0 && ((Heapable)this.get(this.parent(i))).lessThan(key)) {
            this.set(i, this.get(this.parent(i)));
            i = this.parent(i);
        }
        this.set(i, key);
    }

    @Override
    public void removeAllElements() {
        this.clear();
    }
}

