## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width=7
)

## -----------------------------------------------------------------------------
library(BlueCarbon)

## -----------------------------------------------------------------------------
compaction <- estimate_compaction(core_comp,
                                  core = "core",
                                  sampler_length = "sampler_length",
                                  internal_distance = "internal_distance",
                                  external_distance = "external_distance")

## -----------------------------------------------------------------------------
core_comp[core_comp$core == "Sm_03_04",]

## -----------------------------------------------------------------------------
head(compaction, n = 10)

## -----------------------------------------------------------------------------
bluecarbon_decompact <- decompact(bluecarbon_data, dbd = "dbd")

## -----------------------------------------------------------------------------
head(bluecarbon_decompact, n = 10) |> 
  table()

## -----------------------------------------------------------------------------
oc_out <- estimate_oc(bluecarbon_decompact)

## -----------------------------------------------------------------------------
head(oc_out[[1]])  

## -----------------------------------------------------------------------------
head(oc_out[[2]], n = 2)

## -----------------------------------------------------------------------------
stocks <- estimate_oc_stock(oc_out[[1]])

## -----------------------------------------------------------------------------
head(stocks, n=10)

## -----------------------------------------------------------------------------
stocks75 <- estimate_oc_stock(oc_out[[1]], depth = 75)

## -----------------------------------------------------------------------------
head(stocks75, n = 10)

## ----out.width='100%'---------------------------------------------------------
stocks_test <- test_extrapolation(oc_out[[1]])

## ----out.width='100%'---------------------------------------------------------
stocks_test <- test_extrapolation(oc_out[[1]], depth = 75)

## -----------------------------------------------------------------------------
seq_rate <- estimate_seq_rate(oc_out[[1]])

## -----------------------------------------------------------------------------
head(seq_rate, n=10)

## -----------------------------------------------------------------------------
seq_rate_200 <- estimate_seq_rate(oc_out[[1]], timeframe = 200)

## -----------------------------------------------------------------------------
head(seq_rate_200, n=10)

