/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.ibd;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.HKY;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IBDReporter
extends AbstractModel
implements TreeTraitProvider {
    protected double[] ibdweights;
    protected double[][] ibdForward;
    protected double[][] ibdBackward;
    protected double[] diag;
    protected boolean weightsKnown;
    protected HKY substitutionModel;
    protected TreeModel treeModel;
    protected BranchRateModel branchRateModel;
    protected Parameter mutationParameter;
    TreeTrait ibdWeight = new TreeTrait.D(){

        @Override
        public String getTraitName() {
            return "IBDWeight";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            if (!IBDReporter.this.weightsKnown) {
                IBDReporter.this.expectedIBD();
                IBDReporter.this.weightsKnown = true;
            }
            if (tree.isExternal(nodeRef)) {
                return IBDReporter.this.getIBDWeight(tree, nodeRef);
            }
            return null;
        }
    };
    public static final String IBD_REPORTER_LIKELIHOOD = "ibdReporter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule(BranchRateModel.class, true), new ElementRule(AbstractSubstitutionModel.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return IBDReporter.IBD_REPORTER_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            AbstractSubstitutionModel abstractSubstitutionModel = (AbstractSubstitutionModel)xMLObject.getChild(AbstractSubstitutionModel.class);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            if (branchRateModel == null) {
                branchRateModel = new DefaultBranchRateModel();
            }
            return new IBDReporter(parameter, treeModel, branchRateModel, abstractSubstitutionModel);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a reporter for expected number of tips ibd.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    IBDReporter(Parameter parameter, TreeModel treeModel, BranchRateModel branchRateModel, AbstractSubstitutionModel abstractSubstitutionModel) {
        super("IBDReporter");
        this.substitutionModel = (HKY)abstractSubstitutionModel;
        this.addModel(this.substitutionModel);
        this.treeModel = treeModel;
        this.addModel(this.treeModel);
        this.branchRateModel = branchRateModel;
        this.addModel(this.branchRateModel);
        this.mutationParameter = parameter;
        this.addVariable(this.mutationParameter);
    }

    public void forwardIBD() {
        int n = this.treeModel.getNodeCount();
        int n2 = this.substitutionModel.getStateCount();
        this.getDiagonalRates(this.diag);
        for (int i = 0; i < n; ++i) {
            int n3;
            double d;
            NodeRef nodeRef = this.treeModel.getNode(i);
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            if (nodeRef2 == null) continue;
            if (this.treeModel.isExternal(nodeRef)) {
                d = this.branchRateModel.getBranchRate(this.treeModel, nodeRef) * (this.treeModel.getNodeHeight(nodeRef2) - this.treeModel.getNodeHeight(nodeRef));
                for (n3 = 0; n3 < n2; ++n3) {
                    this.ibdForward[i][n3] = Math.exp(-this.diag[n3] * d);
                }
                continue;
            }
            d = this.branchRateModel.getBranchRate(this.treeModel, nodeRef) * (this.treeModel.getNodeHeight(nodeRef2) - this.treeModel.getNodeHeight(nodeRef));
            n3 = this.treeModel.getChildCount(nodeRef);
            for (int j = 0; j < n2; ++j) {
                this.ibdForward[i][j] = 0.0;
                for (int k = 0; k < n3; ++k) {
                    int n4 = this.treeModel.getChild(nodeRef, k).getNumber();
                    double[] dArray = this.ibdForward[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] + this.ibdForward[n4][j];
                }
                double[] dArray = this.ibdForward[i];
                int n6 = j;
                dArray[n6] = dArray[n6] * Math.exp(-this.diag[j] * d);
            }
        }
    }

    public void backwardIBD(NodeRef nodeRef) {
        NodeRef nodeRef2;
        int n;
        int n2;
        int n3;
        int n4 = this.substitutionModel.getStateCount();
        if (nodeRef == null) {
            nodeRef = this.treeModel.getRoot();
            n3 = nodeRef.getNumber();
            for (n2 = 0; n2 < n4; ++n2) {
                this.ibdBackward[n3][n2] = 0.0;
            }
        }
        this.getDiagonalRates(this.diag);
        n3 = this.treeModel.getChildCount(nodeRef);
        n2 = nodeRef.getNumber();
        for (n = 0; n < n3; ++n) {
            nodeRef2 = this.treeModel.getChild(nodeRef, n);
            int n5 = nodeRef2.getNumber();
            double d = this.branchRateModel.getBranchRate(this.treeModel, nodeRef2) * (this.treeModel.getNodeHeight(nodeRef) - this.treeModel.getNodeHeight(nodeRef2));
            for (int i = 0; i < n4; ++i) {
                this.ibdBackward[n5][i] = this.ibdBackward[n2][i];
                for (int j = 0; j < n3; ++j) {
                    if (j == n) continue;
                    int n6 = this.treeModel.getChild(nodeRef, j).getNumber();
                    double[] dArray = this.ibdBackward[n5];
                    int n7 = i;
                    dArray[n7] = dArray[n7] + this.ibdForward[n6][i];
                }
                double[] dArray = this.ibdBackward[n5];
                int n8 = i;
                dArray[n8] = dArray[n8] * Math.exp(-this.diag[i] * d);
            }
        }
        for (n = 0; n < n3; ++n) {
            nodeRef2 = this.treeModel.getChild(nodeRef, n);
            this.backwardIBD(nodeRef2);
        }
    }

    public void expectedIBD() {
        int n = this.substitutionModel.getStateCount();
        int n2 = this.treeModel.getNodeCount();
        if (this.ibdweights == null) {
            this.ibdweights = new double[this.treeModel.getExternalNodeCount()];
            this.ibdForward = new double[n2][n];
            this.ibdBackward = new double[n2][n];
            this.diag = new double[n];
        }
        double[] dArray = this.substitutionModel.getFrequencyModel().getFrequencies();
        this.forwardIBD();
        this.backwardIBD(null);
        int n3 = this.treeModel.getExternalNodeCount();
        for (int i = 0; i < n3; ++i) {
            this.ibdweights[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n4 = i;
                this.ibdweights[n4] = this.ibdweights[n4] + this.ibdBackward[i][j] * dArray[j];
            }
        }
    }

    protected void getDiagonalRates(double[] dArray) {
        double d = this.substitutionModel.getKappa();
        double[] dArray2 = this.substitutionModel.getFrequencyModel().getFrequencies();
        double d2 = this.mutationParameter.getParameterValue(0);
        double d3 = 0.5 / ((dArray2[0] + dArray2[2]) * (dArray2[1] + dArray2[3]) + d * (dArray2[0] * dArray2[2] + dArray2[1] * dArray2[3]));
        dArray[0] = (dArray2[1] + dArray2[3] + dArray2[2] * d) * d2 * d3;
        dArray[1] = (dArray2[0] + dArray2[2] + dArray2[3] * d) * d2 * d3;
        dArray[2] = (dArray2[1] + dArray2[3] + dArray2[0] * d) * d2 * d3;
        dArray[3] = (dArray2[0] + dArray2[2] + dArray2[1] * d) * d2 * d3;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this.ibdWeight};
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.ibdWeight;
    }

    private double getIBDWeight(Tree tree, NodeRef nodeRef) {
        if (!this.weightsKnown) {
            this.expectedIBD();
            this.weightsKnown = true;
        }
        if (tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            return this.ibdweights[n] + 1.0;
        }
        return 0.0;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.branchRateModel || model == this.treeModel || model == this.substitutionModel) {
            this.weightsKnown = false;
        } else {
            System.err.println("Weird call back to IBDReporter from " + model.getModelName());
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.mutationParameter) {
            this.weightsKnown = false;
        } else {
            System.err.println("Weird call back to IBDReporter from " + variable.getVariableName());
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

