/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.AbstractPolygon2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class Polygon2D
extends AbstractPolygon2D {
    public Polygon2D(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("Unbalanced arrays");
        }
        if (dArray[0] != dArray[dArray.length - 1] && dArray2[0] != dArray2[dArray2.length - 1]) {
            double[] dArray3 = new double[dArray.length + 1];
            double[] dArray4 = new double[dArray2.length + 1];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
            dArray3[dArray.length] = dArray[0];
            dArray4[dArray2.length] = dArray2[0];
            this.x = dArray3;
            this.y = dArray4;
        } else {
            this.x = dArray;
            this.y = dArray2;
        }
        this.length = this.x.length - 1;
    }

    public Polygon2D(List<Point2D> list, boolean bl) {
        this.point2Ds = list;
        if (!bl) {
            Point2D point2D = list.get(0);
            list.add(point2D);
        }
        this.convertPointsToArrays();
        this.length = list.size() - 1;
    }

    public Polygon2D() {
        this.length = 0;
        this.point2Ds = new ArrayList();
    }

    public Polygon2D(Element element) {
        List list = element.getChildren();
        this.id = element.getAttributeValue("id");
        this.parseCoordinates(element);
    }

    @Override
    public double getProbability(Point2D point2D, boolean bl) {
        boolean bl2 = this.containsPoint2D(point2D);
        if (bl ^ bl2) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getLogProbability(Point2D point2D, boolean bl) {
        boolean bl2 = this.containsPoint2D(point2D);
        if (bl ^ bl2) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setFillValue(double d) {
        throw new RuntimeException("setFillValue() call not allowed in Polygon2D; try Polygon2DSampling.");
    }

    @Override
    public double getFillValue() {
        throw new RuntimeException("getFillValue() call not allowed in Polygon2D; try Polygon2DSampling.");
    }

    @Override
    public double getLogFillValue() {
        throw new RuntimeException("getLogFillValue() call not allowed in Polygon2D; try Polygon2DSampling.");
    }

    @Override
    public boolean hasFillValue() {
        return false;
    }

    public static void main(String[] stringArray) {
        Polygon2D polygon2D = new Polygon2D();
        polygon2D.addPoint2D(new Point2D.Double(-10.0, -10.0));
        polygon2D.addPoint2D(new Point2D.Double(-10.0, 50.0));
        polygon2D.addPoint2D(new Point2D.Double(10.0, 50.0));
        polygon2D.addPoint2D(new Point2D.Double(10.0, -10.0));
        System.out.println(polygon2D);
        System.out.println("");
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        System.out.println("polygon contains " + double_ + ": " + polygon2D.containsPoint2D(double_));
        double_ = new Point2D.Double(100.0, 100.0);
        System.out.println("polygon contains " + double_ + ": " + polygon2D.containsPoint2D(double_));
        System.out.println("");
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        System.out.println(double_2);
        Polygon2D polygon2D2 = (Polygon2D)polygon2D.clip(double_2);
        System.out.println(polygon2D2);
    }
}

