/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import internal.toolkit.base.core.math.linearfilters.SymmetricMullerNewtonSolver;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

public class RobustSymmetricFrequencyResponseDecomposer {
    private double m_var;
    private BackFilter m_bf;
    private int m_freq;
    private double m_epsilon = 1.0E-4;

    public RobustSymmetricFrequencyResponseDecomposer() {
        this.m_freq = 0;
    }

    public RobustSymmetricFrequencyResponseDecomposer(int freq) {
        this.m_freq = freq;
    }

    public boolean decompose(SymmetricFilter sf) {
        SymmetricMullerNewtonSolver solver;
        UnitRoots ur;
        UnitRoots sur;
        IntToDoubleFunction fn = sf.weights();
        double var = fn.applyAsDouble(0);
        if (var <= 0.0) {
            return false;
        }
        SymmetricFilter cur = sf;
        this.m_bf = null;
        double[] weights = cur.weightsToArray();
        int i = 0;
        while (i < weights.length) {
            int n = i++;
            weights[n] = weights[n] / var;
        }
        UnitRootsSolver urs = new UnitRootsSolver(this.m_freq);
        Polynomial P = Polynomial.of(weights);
        if (urs.factorize(P) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
            Polynomial urp = sur.asPolynomial();
            Polynomial ur2 = urp.times(urp);
            this.m_bf = new BackFilter(urp);
            LeastSquaresDivision lsd = new LeastSquaresDivision();
            lsd.divide(P, ur2);
            P = lsd.getQuotient();
            double[] c = P.toArray();
            int d = P.degree();
            int n = d / 2;
            for (int i2 = 0; i2 < n; ++i2) {
                double q;
                c[i2] = q = (c[i2] + c[d - i2]) / 2.0;
                c[d - i2] = q;
            }
            P = Polynomial.of(c);
        }
        if (this.m_bf == null) {
            this.m_bf = BackFilter.ONE;
        }
        if (!(solver = new SymmetricMullerNewtonSolver()).factorize(P)) {
            return false;
        }
        Complex[] sroots = solver.getStableRoots();
        ComplexUtility.lejaOrder(sroots);
        Polynomial P2 = Polynomial.fromComplexRoots(sroots);
        BackFilter bf = new BackFilter(P2);
        double v = bf.get(0);
        this.m_bf = bf.times(this.m_bf);
        this.m_bf = this.m_bf.normalize();
        Polynomial coeff = this.m_bf.asPolynomial();
        this.m_var = var / coeff.coefficients().ssq();
        return this.m_var >= 0.0;
    }

    public BackFilter getBFilter() {
        return this.m_bf;
    }

    public double getFactor() {
        return this.m_var;
    }

    public double getPrecision() {
        return this.m_epsilon;
    }

    public int getStartingURValue() {
        return this.m_freq;
    }

    public void setPrecision(double value) {
        this.m_epsilon = value;
    }

    public void setStartingURValue(int value) {
        this.m_freq = value;
    }
}

