/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.analysis.AutoRegressiveSpectrum;
import jdplus.toolkit.base.core.data.analysis.Periodogram;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;

public class AutoRegressiveSpectrumTest {
    private static final int NFREQ = 60;
    private final double[] f = new double[61];
    private final double[] spectrum = new double[61];
    private int arcount;
    private double sensitivity = 0.95;
    private AutoRegressiveSpectrum ar;
    private double median;
    private double srange;
    private int[] spos;
    private int[] tdpos;
    private static final double[] SILHF = new double[]{0.0696, 0.0705, 0.0715, 0.0726, 0.0735, 0.0746, 0.0756, 0.0768, 0.0778, 0.0788, 0.0801, 0.0812, 0.0822, 0.0834, 0.0845, 0.0857, 0.0869, 0.0881, 0.0895, 0.0909, 0.0923, 0.0935, 0.0948, 0.0961, 0.0975, 0.0988, 0.1003, 0.1018, 0.1034, 0.1047, 0.1062, 0.1076, 0.109, 0.1106, 0.1125, 0.1143, 0.1161, 0.1175, 0.1192, 0.1208, 0.1224, 0.1245, 0.1263, 0.1282, 0.1301, 0.1324, 0.1342, 0.136, 0.1381, 0.1404, 0.1428, 0.1452, 0.1477, 0.15, 0.1523, 0.1548, 0.1573, 0.1598, 0.162, 0.1645, 0.1674, 0.1702, 0.1731, 0.1756, 0.179, 0.182, 0.1852, 0.1883, 0.1922, 0.1958, 0.1991, 0.203, 0.2069, 0.2108, 0.2154, 0.2198, 0.2243, 0.2296, 0.2347, 0.2396, 0.2447, 0.251, 0.2572, 0.264, 0.2717, 0.2787, 0.2863, 0.2952, 0.3043, 0.3147, 0.3259, 0.3385, 0.3522, 0.3658, 0.3849, 0.404, 0.4314, 0.459, 0.4958, 0.5485};
    private static final double[] SILHM = new double[]{0.0023, 0.0029, 0.0036, 0.0042, 0.0048, 0.0055, 0.0061, 0.0068, 0.0074, 0.008, 0.0089, 0.0095, 0.0102, 0.0109, 0.0116, 0.0123, 0.0131, 0.0139, 0.0147, 0.0154, 0.0162, 0.0169, 0.0178, 0.0186, 0.0195, 0.0203, 0.0212, 0.0221, 0.023, 0.024, 0.0249, 0.0259, 0.027, 0.028, 0.029, 0.03, 0.0309, 0.0319, 0.033, 0.0342, 0.0353, 0.0364, 0.0376, 0.0388, 0.04, 0.0411, 0.0424, 0.0435, 0.0448, 0.0459, 0.0474, 0.0488, 0.0502, 0.0515, 0.0529, 0.0544, 0.0559, 0.0572, 0.0589, 0.0606, 0.0624, 0.064, 0.0658, 0.0676, 0.0695, 0.0714, 0.0732, 0.0751, 0.0768, 0.079, 0.0814, 0.0839, 0.0864, 0.0889, 0.0912, 0.0939, 0.0968, 0.0995, 0.1027, 0.1057, 0.1093, 0.1127, 0.1163, 0.1202, 0.1239, 0.128, 0.1332, 0.1379, 0.143, 0.149, 0.1551, 0.162, 0.1705, 0.1794, 0.1901, 0.2025, 0.2173, 0.238, 0.2661, 0.312};

    private static int indexGE(double val, boolean sym) {
        int i;
        double[] valArray = sym ? SILHM : SILHF;
        for (i = 0; i < valArray.length; ++i) {
            if (valArray[i] <= val) {
                continue;
            }
            return i;
        }
        return i;
    }

    private static double prob(double sinc, boolean sym) {
        return 0.8 + 0.0025 * (double)AutoRegressiveSpectrumTest.indexGE(sinc, sym);
    }

    public boolean test(DoubleSeq data, int period) {
        if (!this.computeARSpectrum(data, period)) {
            return false;
        }
        this.computeFrequencies(period);
        this.computeRange();
        return true;
    }

    public boolean isPeak(double freq, double p) {
        int pos = this.findPos(freq);
        return this.peak(pos, p);
    }

    private boolean peak(int pos, double p) {
        return this.peakProb(pos) > p;
    }

    private double peakProb(int pos) {
        double s = this.spectrum[pos];
        if (s <= this.median) {
            return 0.0;
        }
        if (pos < 60 && s > 0.0) {
            double sm = s - this.spectrum[pos - 1];
            double sp = s - this.spectrum[pos + 1];
            double sinc = Math.min(sm, sp);
            if (sinc < 0.0) {
                return 0.0;
            }
            return AutoRegressiveSpectrumTest.prob(sinc /= this.srange, true);
        }
        if (pos == 60) {
            double sinc = s - this.spectrum[pos - 1];
            if (sinc < 0.0) {
                return 0.0;
            }
            return AutoRegressiveSpectrumTest.prob(sinc /= this.srange, false);
        }
        double sinc = s - this.spectrum[pos + 1];
        if (sinc < 0.0) {
            return 0.0;
        }
        return AutoRegressiveSpectrumTest.prob(sinc /= this.srange, false);
    }

    public int tdPeaksCount() {
        return this.peaks(this.tdpos);
    }

    public int seasonalPeaksCount() {
        return this.peaks(this.spos);
    }

    public AutoRegressiveSpectrum getAutoRegressiveSpectrum() {
        return this.ar;
    }

    public boolean hasSeasonalPeak(int ifreq, double prob) {
        if (ifreq <= 0 || ifreq > this.spos.length) {
            return false;
        }
        return this.peak(this.spos[ifreq - 1], prob);
    }

    public int[] seasonalPeaks(double plow, double phigh) {
        int[] rslt = new int[this.spos.length];
        for (int i = 0; i < this.spos.length; ++i) {
            double p = this.peakProb(this.spos[i]);
            if (p > phigh) {
                rslt[i] = 2;
                continue;
            }
            if (!(p > plow)) continue;
            rslt[i] = 1;
        }
        return rslt;
    }

    private int peaks(int[] pos) {
        if (pos == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < pos.length; ++i) {
            if (!this.peak(pos[i], this.getSensitivity())) continue;
            ++n;
        }
        return n;
    }

    private int arcount(int ndata, int freq) {
        if (this.arcount == 0) {
            int n = 30 * freq / 12;
            if (n > ndata - 1) {
                return ndata - 1;
            }
            return n;
        }
        return this.arcount;
    }

    private boolean computeARSpectrum(DoubleSeq data, int period) {
        int n = data.length();
        int nar = this.arcount(n, period);
        if (nar >= n) {
            return false;
        }
        this.ar = new AutoRegressiveSpectrum(AutoRegressiveSpectrum.Method.Ols);
        return this.ar.process(data, nar);
    }

    private void computeFrequencies(int freq) {
        int i;
        for (int i2 = 0; i2 <= 60; ++i2) {
            this.f[i2] = this.step() * (double)i2;
        }
        this.spos = new int[freq / 2];
        int step = 120 / freq;
        for (int i3 = 0; i3 < this.spos.length; ++i3) {
            this.spos[i3] = step * (i3 + 1);
        }
        double[] tdf = Periodogram.getTradingDaysFrequencies((int)freq);
        if (tdf != null) {
            this.tdpos = new int[tdf.length];
            for (i = 0; i < tdf.length; ++i) {
                int pos;
                this.tdpos[i] = pos = this.findPos(tdf[i]);
                this.f[pos - 1] = tdf[i] - this.step();
                this.f[pos] = tdf[i];
                this.f[pos + 1] = tdf[i] + this.step();
            }
        }
        for (i = 0; i <= 60; ++i) {
            this.spectrum[i] = this.ar.value(this.f[i]);
        }
    }

    private double step() {
        return 0.05235987755982988;
    }

    private int findPos(double f) {
        int pos = (int)(f / this.step() + 0.5);
        if (pos > 60) {
            pos = 60;
        }
        return pos;
    }

    private void computeRange() {
        DescriptiveStatistics stats = DescriptiveStatistics.ofInternal((double[])this.spectrum);
        this.median = stats.getMedian();
        this.srange = stats.getMax() - stats.getMin();
    }

    public int getArCount() {
        return this.arcount;
    }

    public void setArCount(int arcount) {
        this.arcount = arcount;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }
}

