/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.helpers;

import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class CellRefHelper {
    private boolean match = false;
    private int col = 0;
    private int row = 0;

    private boolean withMatch(boolean condition) {
        this.match = condition;
        return this.match;
    }

    public boolean parseEnd(@Nullable CharSequence dimension) {
        if (dimension != null) {
            int length = dimension.length();
            for (int i = 0; i < length; ++i) {
                if (dimension.charAt(i) != ':') continue;
                return this.parse(dimension, i + 1, length);
            }
        }
        return this.withMatch(false);
    }

    public boolean parse(@Nullable CharSequence ref) {
        return ref != null ? this.parse(ref, 0, ref.length()) : this.withMatch(false);
    }

    private boolean parse(@NonNull CharSequence ref, int begIdx, int endIdx) {
        char c;
        int i;
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        if (endIdx <= begIdx) {
            return this.withMatch(false);
        }
        this.col = 0;
        for (i = begIdx; i < endIdx && (c = ref.charAt(i)) >= 'A' && c <= 'Z'; ++i) {
            this.col = this.col * 26 + ((byte)c - 65) + 1;
        }
        --this.col;
        this.row = 0;
        while (i < endIdx && (c = ref.charAt(i)) >= '0' && c <= '9') {
            this.row = this.row * 10 + ((byte)c - 48);
            ++i;
        }
        --this.row;
        return this.withMatch(i == endIdx && this.col >= 0 && this.row >= 0);
    }

    public int getColumnIndex() throws IllegalStateException {
        this.checkMatch();
        return this.col;
    }

    public int getRowIndex() throws IllegalStateException {
        this.checkMatch();
        return this.row;
    }

    private void checkMatch() throws IllegalStateException {
        if (!this.match) {
            throw new IllegalStateException();
        }
    }

    @NonNull
    public static String getRowLabel(int rowIndex) throws IndexOutOfBoundsException {
        CellRefHelper.checkNonNegative(rowIndex);
        return Integer.toString(rowIndex + 1);
    }

    @NonNull
    public static String getColumnLabel(int columnIndex) throws IndexOutOfBoundsException {
        CellRefHelper.checkNonNegative(columnIndex);
        int dividend = columnIndex + 1;
        String result = "";
        while (dividend > 0) {
            int modulo = (dividend - 1) % 26;
            result = (char)(65 + modulo) + result;
            dividend = (dividend - modulo) / 26;
        }
        return result;
    }

    @NonNull
    public static String getCellRef(int rowIndex, int columnIndex) throws IndexOutOfBoundsException {
        return CellRefHelper.getColumnLabel(columnIndex) + CellRefHelper.getRowLabel(rowIndex);
    }

    private static void checkNonNegative(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Expected: non-negative index, found:" + index);
        }
    }
}

