## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(multigroup.vaccine)

## -----------------------------------------------------------------------------
popsize <- c(80000, 20000)

## -----------------------------------------------------------------------------
relcontact <- c(1, 1.7)

## -----------------------------------------------------------------------------
incontact <- c(0.2, 0.5)

## -----------------------------------------------------------------------------
contactmatrix <- contactMatrixPropPref(popsize, relcontact, incontact)

## -----------------------------------------------------------------------------
relsusc <- c(1, 1.05)

## -----------------------------------------------------------------------------
reltransm <- c(1, 1.01)

## -----------------------------------------------------------------------------
R0 <- 1.75

## -----------------------------------------------------------------------------
initR <- c(0, 0)
initI <- c(0, 1)
initV <- c(0.3, 0.2) * popsize

## -----------------------------------------------------------------------------
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV)

## -----------------------------------------------------------------------------
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV, method = "analytic")

## -----------------------------------------------------------------------------
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV, method = "stochastic",
          nsims = 10)

## -----------------------------------------------------------------------------
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV, method = "hybrid",
          nsims = 10)

