/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.Deeps;

import java.util.StringTokenizer;
import keel.Algorithms.Lazy_Learning.Deeps.Itemset;
import keel.Algorithms.Lazy_Learning.LazyAlgorithm;
import org.core.Files;

public class Deeps
extends LazyAlgorithm {
    double ALPHA;
    double[][][] classData;
    int[][][] binaryData;
    Itemset[][] maxBorder;
    int[] maxBorderSize;
    double[] score;

    public Deeps(String script) {
        int i;
        this.readDataFiles(script);
        this.name = "DeEps";
        this.classData = new double[this.nClasses][][];
        for (int i2 = 0; i2 < this.nClasses; ++i2) {
            this.classData[i2] = new double[this.nInstances[i2]][this.inputAtt];
        }
        int[] index = new int[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            index[i] = 0;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            int instanceClass = this.trainOutput[i];
            for (int j = 0; j < this.trainData[i].length; ++j) {
                this.classData[instanceClass][index[instanceClass]][j] = this.trainData[i][j];
            }
            int n = instanceClass;
            index[n] = index[n] + 1;
        }
        this.binaryData = new int[this.nClasses][][];
        for (i = 0; i < this.nClasses; ++i) {
            this.binaryData[i] = new int[this.nInstances[i]][this.inputAtt];
        }
        this.maxBorder = new Itemset[this.nClasses][];
        this.maxBorderSize = new int[this.nClasses];
        this.score = new double[this.nClasses];
        Itemset.setMaxItems(this.inputAtt);
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.ALPHA = Double.parseDouble(tokens.nextToken().substring(1));
    }

    @Override
    protected int evaluate(double[] example) {
        int j;
        int i;
        double max;
        int output = -1;
        for (int j2 = 0; j2 < example.length; ++j2) {
            double min = example[j2] - this.ALPHA;
            max = example[j2] + this.ALPHA;
            for (int k = 0; k < this.nClasses; ++k) {
                for (int i2 = 0; i2 < this.nInstances[k]; ++i2) {
                    double value = this.classData[k][i2][j2];
                    this.binaryData[k][i2][j2] = value <= max && value >= min ? 1 : 0;
                }
            }
        }
        for (int k = 0; k < this.nClasses; ++k) {
            for (int i3 = 0; i3 < this.nInstances[k]; ++i3) {
                if (!this.same(example, this.classData[k][i3])) continue;
                for (int j3 = 0; j3 < example.length; ++j3) {
                    this.binaryData[k][i3][j3] = 0;
                }
            }
        }
        this.extractHorizontals();
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.maxBorder[i].length; ++j) {
            }
        }
        for (i = 0; i < this.nClasses; ++i) {
            Itemset[] EPs = this.jepProducer(i);
            this.score[i] = this.calculateScore(EPs, i);
            for (j = 0; j < EPs.length; ++j) {
            }
        }
        output = -1;
        max = Double.MIN_VALUE;
        for (i = 0; i < this.nClasses; ++i) {
            if (!(this.score[i] > max)) continue;
            output = i;
            max = this.score[i];
        }
        return output;
    }

    private void extractHorizontals() {
        for (int k = 0; k < this.nClasses; ++k) {
            if (this.nInstances[k] > 0) {
                this.maxBorder[k] = new Itemset[1];
                this.maxBorder[k][0] = new Itemset(this.binaryData[k][0]);
                this.maxBorderSize[k] = 1;
                for (int i = 1; i < this.nInstances[k]; ++i) {
                    Itemset aux = new Itemset(this.binaryData[k][i]);
                    boolean subset = false;
                    for (int index = 0; index < this.maxBorder[k].length && !subset; ++index) {
                        if (!aux.isSubset(this.maxBorder[k][index])) continue;
                        subset = true;
                    }
                    if (subset) continue;
                    this.insertItemset(aux, k, i);
                }
                continue;
            }
            this.maxBorder[k] = new Itemset[1];
            this.maxBorder[k][0] = new Itemset();
        }
    }

    private void insertItemset(Itemset newIt, int inClass, int index) {
        Itemset[] copy = new Itemset[this.maxBorderSize[inClass] + 1];
        copy[0] = newIt;
        int copySize = 1;
        for (int i = 0; i < this.maxBorderSize[inClass]; ++i) {
            boolean subset = false;
            if (this.maxBorder[inClass][i].isSubset(copy[0])) {
                subset = true;
            }
            if (subset) continue;
            copy[copySize] = this.maxBorder[inClass][i];
            ++copySize;
        }
        this.maxBorder[inClass] = new Itemset[copySize];
        System.arraycopy(copy, 0, this.maxBorder[inClass], 0, copySize);
        this.maxBorderSize[inClass] = copySize;
    }

    private double calculateScore(Itemset[] border, int nClass) {
        int i;
        int size = this.nInstances[nClass];
        int[] selected = new int[size];
        for (i = 0; i < size; ++i) {
            selected[i] = 0;
        }
        for (int pointer = 0; pointer < border.length; ++pointer) {
            Itemset aux = border[pointer];
            for (int i2 = 0; i2 < this.binaryData[nClass].length; ++i2) {
                if (!aux.isSubSetBinary(this.binaryData[nClass][i2])) continue;
                selected[i2] = 1;
            }
        }
        int count = 0;
        for (i = 0; i < size; ++i) {
            count += selected[i];
        }
        double score = (double)count / (double)size;
        return score;
    }

    private Itemset[] jepProducer(int nClass) {
        int i;
        Itemset[] aux = new Itemset[this.maxBorder[nClass].length];
        int unionSize = 0;
        for (i = 0; i < this.nClasses; ++i) {
            unionSize += this.maxBorder[i].length;
        }
        Itemset[] union = new Itemset[unionSize -= this.maxBorder[nClass].length];
        int unionIndex = 0;
        for (i = 0; i < this.nClasses; ++i) {
            if (i == nClass) continue;
            System.arraycopy(this.maxBorder[i], 0, union, unionIndex, this.maxBorder[i].length);
            unionIndex += this.maxBorder[i].length;
        }
        int auxIndex = 0;
        for (i = 0; i < this.maxBorder[nClass].length; ++i) {
            Itemset jep;
            boolean isSubset = false;
            for (int j = 0; j < unionSize && !isSubset; ++j) {
                isSubset = this.maxBorder[nClass][i].isSubset(union[j]);
            }
            if (isSubset || (jep = this.borderDiff(this.maxBorder[nClass][i], union)).getSize() <= 0) continue;
            aux[auxIndex] = jep;
            ++auxIndex;
        }
        Itemset[] result = new Itemset[auxIndex];
        System.arraycopy(aux, 0, result, 0, auxIndex);
        return result;
    }

    private Itemset borderDiff(Itemset target, Itemset[] border) {
        Itemset result = new Itemset();
        result = result.merge(target.diference(border[0]));
        for (int i = 1; i < border.length; ++i) {
            result = result.merge(target.diference(border[i]));
        }
        return result;
    }
}

