/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCPAR;

import keel.Algorithms.Associative_Classification.ClassifierCPAR.myDataset;
import org.core.Files;

public class DataBase {
    int n_variables;
    int n_variablesUsed;
    int partitions;
    int[] nLabels;
    int[][] dataBase;
    myDataset train;
    String[] names;

    public DataBase() {
    }

    public DataBase(myDataset train) {
        int[][] ranks = train.returnRanks();
        this.n_variables = train.getnInputs();
        this.names = (String[])train.names().clone();
        this.nLabels = new int[this.n_variables];
        this.dataBase = new int[this.n_variables][];
        this.train = train;
        this.n_variablesUsed = 0;
        for (int i = 0; i < this.n_variables; ++i) {
            int rank = Math.abs(ranks[i][1] - ranks[i][0]);
            this.nLabels[i] = rank + 1;
            this.dataBase[i] = new int[this.nLabels[i]];
            for (int j = 0; j < this.nLabels[i]; ++j) {
                this.dataBase[i][j] = j;
            }
            if (this.nLabels[i] <= 1) continue;
            ++this.n_variablesUsed;
        }
    }

    public int numVariables() {
        return this.n_variables;
    }

    public int numVariablesUsed() {
        return this.n_variablesUsed;
    }

    public int numClasses() {
        return this.train.getnClasses();
    }

    public int numLabels(int variable) {
        return this.nLabels[variable];
    }

    public int[] getnLabels() {
        return this.nLabels;
    }

    public int matching(int variable, int label, int value) {
        if (variable < 0 || label < 0) {
            return 1;
        }
        if (this.dataBase[variable][label] == value) {
            return 1;
        }
        return 0;
    }

    public String print(int var, int label) {
        return this.train.getInputAsString(var, label);
    }

    public String printString() {
        String string = new String("@Data Base:");
        for (int i = 0; i < this.n_variables; ++i) {
            string = string + "\n\n@Number of Values in Variable " + (i + 1) + ": " + this.nLabels[i];
            string = string + "\n" + this.names[i] + ":\n";
            for (int j = 0; j < this.nLabels[i]; ++j) {
                string = string + this.print(i, j) + "\n";
            }
        }
        return string;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Files.writeFile(filename, stringOut);
    }
}

