/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseR;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Individuo;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.myDataset;
import org.core.Randomize;

public class Poblacion {
    ArrayList<Individuo> cromosomas = new ArrayList();
    ArrayList<Individuo> hijos = new ArrayList();
    BaseR baseReglas;
    myDataset train;
    double mejor_ECM;
    double sumatoria;
    double crossProb;
    double mutProb;
    int[] selectos;
    double[] soporte;

    public boolean BETTER(double a, double b) {
        return a > b;
    }

    public Poblacion(int tamPoblacion, BaseR baseReglas, myDataset train) {
        int n_etiquetas = baseReglas.baseDatos.n_etiquetas;
        int n_variables = baseReglas.baseDatos.n_variables;
        this.baseReglas = baseReglas;
        this.train = train;
        int n_reglas = 1;
        for (int i = 0; i < n_variables - 1; ++i) {
            n_reglas *= n_etiquetas;
        }
        Individuo ind = new Individuo(n_variables, n_etiquetas, n_reglas, baseReglas.baseDatos);
        double[] max = ind.dameIntervalosMax();
        double[] min = ind.dameIntervalosMin();
        for (int i = 1; i < tamPoblacion; ++i) {
            ind = new Individuo(n_variables, n_etiquetas, n_reglas, min, max);
            this.cromosomas.add(ind);
        }
        this.mejor_ECM = Double.MAX_VALUE;
        this.sumatoria = train.sumatoria();
        this.selectos = new int[this.cromosomas.size()];
    }

    public Individuo getMejor() {
        Collections.sort(this.cromosomas);
        return this.cromosomas.get(0);
    }

    public void procesoGenetico(int nGeneraciones, double crossProb, double mutProb) {
        this.crossProb = crossProb;
        this.mutProb = mutProb;
        this.evaluaP();
        for (int i = 0; i < nGeneraciones; ++i) {
            this.select();
            this.cross();
            this.mutate();
            this.evalua(i);
            this.replace();
        }
    }

    private void evaluaP() {
        double ecm = 0.0;
        Individuo cromosoma = this.cromosomas.get(0);
        if (cromosoma.n_e) {
            ecm = 0.0;
            this.baseReglas.ajusta(cromosoma);
            for (int j = 0; j < this.train.size(); ++j) {
                double salida = this.baseReglas.FLC(this.train.getExample(j));
                ecm += (salida - this.train.getOutputAsReal(j)) * (salida - this.train.getOutputAsReal(j));
            }
            cromosoma.setFitness(ecm /= this.sumatoria);
            if (ecm < this.mejor_ECM) {
                this.mejor_ECM = ecm;
            }
            cromosoma.n_e = false;
        }
        for (int i = 1; i < this.cromosomas.size(); ++i) {
            cromosoma = this.cromosomas.get(i);
            this.baseReglas.ajusta(cromosoma);
            if (!cromosoma.n_e) continue;
            ecm = 0.0;
            for (int j = 0; j < this.train.size(); ++j) {
                double salida = this.baseReglas.FLC(this.train.getExample(j));
                ecm += (salida - this.train.getOutputAsReal(j)) * (salida - this.train.getOutputAsReal(j));
                cromosoma.setFitness(salida);
            }
            if ((ecm /= this.sumatoria) < this.mejor_ECM) {
                this.mejor_ECM = ecm;
            }
            cromosoma.n_e = false;
        }
        System.err.println("Best ECM in the initial Population: " + this.mejor_ECM);
    }

    private void evalua(int generation) {
        double ecm = 0.0;
        for (int i = 0; i < this.hijos.size(); ++i) {
            Individuo cromosoma = this.hijos.get(i);
            this.baseReglas.ajusta(cromosoma);
            if (!cromosoma.n_e) continue;
            ecm = 0.0;
            for (int j = 0; j < this.train.size(); ++j) {
                double salida = this.baseReglas.FLC(this.train.getExample(j));
                ecm += (salida - this.train.getOutputAsReal(j)) * (salida - this.train.getOutputAsReal(j));
            }
            cromosoma.setFitness(ecm /= this.sumatoria);
            if (ecm < this.mejor_ECM) {
                this.mejor_ECM = ecm;
            }
            cromosoma.n_e = false;
        }
        System.err.println("Generation[" + generation + "], ECM: " + this.mejor_ECM);
    }

    void torneo(int indice, int cromosoma1, int cromosoma2) {
        this.selectos[indice] = this.BETTER(this.cromosomas.get((int)cromosoma1).fitness, this.cromosomas.get((int)cromosoma2).fitness) ? cromosoma1 : cromosoma2;
    }

    private void select() {
        int inicio;
        this.hijos.clear();
        for (int i = inicio = 0; i < this.cromosomas.size(); ++i) {
            int aleatorio2;
            int aleatorio1 = Randomize.RandintClosed(0, this.cromosomas.size() - 1);
            while (aleatorio1 == (aleatorio2 = Randomize.RandintClosed(0, this.cromosomas.size() - 1))) {
            }
            this.torneo(i, aleatorio1, aleatorio2);
        }
    }

    private void cross() {
        for (int i = 0; i < this.cromosomas.size() / 2; ++i) {
            Individuo hijo2;
            Individuo hijo1;
            Individuo padre = this.cromosomas.get(this.selectos[i]);
            Individuo madre = this.cromosomas.get(this.selectos[i + 1]);
            if (Randomize.Rand() < this.crossProb) {
                int puntoCorte = Randomize.Randint(1, padre.cromosoma1.length - 1);
                hijo1 = new Individuo(padre, madre, puntoCorte);
                hijo2 = new Individuo(madre, padre, puntoCorte);
            } else {
                hijo1 = padre.clone();
                hijo2 = madre.clone();
            }
            this.hijos.add(hijo1);
            this.hijos.add(hijo2);
        }
    }

    private void mutate() {
        for (int i = 0; i < this.hijos.size(); ++i) {
            this.hijos.get(i).mutar(this.mutProb);
        }
    }

    private void replace() {
        Collections.sort(this.cromosomas);
        Individuo mejor = this.cromosomas.get(0).clone();
        this.cromosomas.clear();
        this.cromosomas.add(mejor);
        int posicion = Randomize.RandintClosed(0, this.hijos.size() - 1);
        this.hijos.remove(posicion);
        for (int i = 0; i < this.hijos.size(); ++i) {
            Individuo nuevo = this.hijos.get(i).clone();
            this.cromosomas.add(nuevo);
        }
    }
}

