/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.File;
import javax.swing.JComponent;

public abstract class JComponentWriter {
    protected static final boolean DEBUG = false;
    private JComponent component;
    private File outputFile;
    protected double m_xScale;
    protected double m_yScale;
    protected boolean m_ScalingEnabled;

    public JComponentWriter() {
        this(null);
    }

    public JComponentWriter(JComponent jComponent) {
        this(jComponent, null);
    }

    public JComponentWriter(JComponent jComponent, File file) {
        this.component = jComponent;
        this.outputFile = file;
        this.initialize();
    }

    protected void initialize() {
        this.m_xScale = 1.0;
        this.m_yScale = 1.0;
        this.m_ScalingEnabled = true;
    }

    public void setComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setFile(File file) {
        this.outputFile = file;
    }

    public File getFile() {
        return this.outputFile;
    }

    public String getDescription() {
        return null;
    }

    public String getExtension() {
        return null;
    }

    public boolean getScalingEnabled() {
        return this.m_ScalingEnabled;
    }

    public void setScalingEnabled(boolean bl) {
        this.m_ScalingEnabled = bl;
    }

    public void setScale(double d, double d2) {
        if (this.getScalingEnabled()) {
            this.m_xScale = d;
            this.m_yScale = d2;
        } else {
            this.m_xScale = 1.0;
            this.m_yScale = 1.0;
        }
    }

    public double getXScale() {
        return this.m_xScale;
    }

    public double getYScale() {
        return this.m_xScale;
    }

    public void toOutput() throws Exception {
        if (this.getFile() == null) {
            throw new Exception("The file is not set!");
        }
        if (this.getComponent() == null) {
            throw new Exception("The component is not set!");
        }
    }
}

