/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleFillerTranslator
extends DIGQueryTranslator {
    public DIGQueryRoleFillerTranslator() {
        super(null, null, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query2, "roleFillers");
        da.addNamedElement(instances, "individual", da.getNodeID(pattern.getSubject()));
        da.addNamedElement(instances, "ratom", da.getNodeID(pattern.getPredicate()));
        return query2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        SimpleXMLPath p = new SimpleXMLPath(true);
        p.appendElementPath("individualSet");
        p.appendElementPath("individual");
        p.appendAttrPath("name");
        ArrayList<Triple> matches = new ArrayList<Triple>();
        ExtendedIterator iNodes = p.getAll(response).mapWith(new DIGValueToNodeMapper());
        try {
            while (iNodes.hasNext()) {
                Node result = (Node)iNodes.next();
                if (!result.equals(query2.getObject())) continue;
                matches.add(query2.asTriple());
                break;
            }
        }
        finally {
            iNodes.close();
        }
        return WrappedIterator.create(matches.iterator());
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return this.translatePattern(pattern, da);
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return subject.isConcrete() && da.isIndividual(subject);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return object.isConcrete() && da.isIndividual(object);
    }

    public boolean checkPredicate(Node predicate, DIGAdapter da, Model premises) {
        if (predicate.isConcrete()) {
            Resource p = (Resource)da.m_sourceData.getRDFNode(predicate);
            String pNS = p.getNameSpace();
            return !da.m_sourceData.contains(p, RDF.type, da.m_sourceData.getProfile().DATATYPE_PROPERTY()) && !RDFS.getURI().equals(pNS) && !RDF.getURI().equals(pNS) && !OWL.getURI().equals(pNS);
        }
        return false;
    }
}

