/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.continuous.Continuous;
import dr.evolution.continuous.ContinuousTraitLikelihood;
import dr.evolution.continuous.Contrastable;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class RootTraitMLE
extends Statistic.Abstract {
    public static final String ROOT_TRAIT_MLE = "rootTraitMLE";
    public static final String TRAIT = "trait";
    public static final String NAME = "name";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return RootTraitMLE.ROOT_TRAIT_MLE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                XMLObject xMLObject2;
                Object object = xMLObject.getChild(i);
                if (!(xMLObject.getChild(i) instanceof XMLObject) || !(xMLObject2 = (XMLObject)xMLObject.getChild(i)).getName().equals(RootTraitMLE.TRAIT)) continue;
                arrayList.add(xMLObject2.getStringAttribute(RootTraitMLE.NAME));
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            RootTraitMLE rootTraitMLE = new RootTraitMLE(treeModel, stringArray);
            return rootTraitMLE;
        }

        @Override
        public String getParserDescription() {
            return "A maximum likelihood estimate of trait value at the root.";
        }

        @Override
        public Class getReturnType() {
            return RootTraitMLE.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private String[] traitNames = null;
    private Contrastable[] mles = null;
    private TreeModel treeModel = null;
    private ContinuousTraitLikelihood contTraitLikelihood = new ContinuousTraitLikelihood();

    public RootTraitMLE(TreeModel treeModel, String[] stringArray) {
        this.treeModel = treeModel;
        this.traitNames = stringArray;
        this.mles = new Contrastable[stringArray.length];
    }

    @Override
    public double getStatisticValue(int n) {
        this.contTraitLikelihood.calculateLikelihood(this.treeModel, this.traitNames, this.mles, 1.0);
        if (this.mles[n] instanceof Continuous) {
            return ((Continuous)this.mles[n]).getValue();
        }
        return -1.0;
    }

    @Override
    public int getDimension() {
        return this.traitNames.length;
    }
}

