/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.feature;

import java.util.Map;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

public class IllegalAttributeException
extends IllegalArgumentException {
    private static final long serialVersionUID = 3373066465585246605L;
    private static final AttributeDescriptor NULL_ATTRIBUTE_DESCRIPTOR = new NullAttributeDescriptor();
    private final AttributeDescriptor descriptor;
    private final Object value;

    public IllegalAttributeException(String message) {
        this(NULL_ATTRIBUTE_DESCRIPTOR, null, message);
    }

    public IllegalAttributeException(AttributeDescriptor descriptor, Object value) {
        this.descriptor = descriptor;
        this.value = value;
    }

    public IllegalAttributeException(AttributeDescriptor descriptor, Object value, String message) {
        super(message);
        this.descriptor = descriptor;
        this.value = value;
    }

    public IllegalAttributeException(AttributeDescriptor descriptor, Object value, String message, Throwable t) {
        super(message, t);
        this.descriptor = descriptor;
        this.value = value;
    }

    public IllegalAttributeException(AttributeDescriptor descriptor, Object value, Throwable t) {
        super(t);
        this.descriptor = descriptor;
        this.value = value;
    }

    public AttributeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        String s2 = this.getClass().getName();
        String message = this.getLocalizedMessage();
        StringBuffer buf = new StringBuffer();
        buf.append(s2);
        if (message != null) {
            buf.append(":");
            buf.append(message);
        }
        if (this.descriptor != null) {
            buf.append(":");
            buf.append(this.descriptor.getName());
        }
        buf.append(" value:");
        buf.append(this.value);
        return buf.toString();
    }

    private static class NullAttributeDescriptor
    implements AttributeDescriptor {
        private NullAttributeDescriptor() {
        }

        @Override
        public int getMaxOccurs() {
            return 0;
        }

        @Override
        public int getMinOccurs() {
            return 0;
        }

        @Override
        public Name getName() {
            return null;
        }

        @Override
        public Map<Object, Object> getUserData() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public AttributeType getType() {
            return null;
        }
    }
}

