/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Map;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Pie<ST extends PieStyler, S extends PieSeries>
extends PlotContent_<ST, S> {
    private final ST pieStyler;
    private final DecimalFormat df = new DecimalFormat("#.0");

    PlotContent_Pie(Chart<ST, S> chart) {
        super(chart);
        this.pieStyler = (PieStyler)chart.getStyler();
    }

    public static Shape getDonutSliceShape(Rectangle2D pieBounds, double thickness, double start, double extent) {
        thickness /= 2.0;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath dummy = new GeneralPath();
        double x = pieBounds.getX();
        double y = pieBounds.getY();
        double width = pieBounds.getWidth();
        double height = pieBounds.getHeight();
        Arc2D.Double outer = new Arc2D.Double(x, y, width, height, start, extent, 0);
        double wt = width * thickness;
        double ht = height * thickness;
        Arc2D.Double inner = new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start + extent, -extent, 0);
        generalPath.append(outer, false);
        dummy.append(new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start, extent, 0), false);
        Point2D point = dummy.getCurrentPoint();
        if (point != null) {
            generalPath.lineTo(point.getX(), point.getY());
        }
        generalPath.append(inner, false);
        dummy.append(new Arc2D.Double(x, y, width, height, start + extent, -extent, 0), false);
        point = dummy.getCurrentPoint();
        if (point != null) {
            generalPath.lineTo(point.getX(), point.getY());
        }
        return generalPath;
    }

    @Override
    public void doPaint(Graphics2D g2) {
        if (((Styler)this.pieStyler).getDecimalPattern() != null) {
            this.df.applyPattern(((Styler)this.pieStyler).getDecimalPattern());
        }
        double pieFillPercentage = ((Styler)this.pieStyler).getPlotContentSize();
        double halfBorderPercentage = (1.0 - pieFillPercentage) / 2.0;
        double width = ((PieStyler)this.pieStyler).isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getWidth();
        double height = ((PieStyler)this.pieStyler).isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getHeight();
        Rectangle2D.Double pieBounds = new Rectangle2D.Double(this.getBounds().getX() + this.getBounds().getWidth() / 2.0 - width / 2.0 + halfBorderPercentage * width, this.getBounds().getY() + this.getBounds().getHeight() / 2.0 - height / 2.0 + halfBorderPercentage * height, width * pieFillPercentage, height * pieFillPercentage);
        double total = 0.0;
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            if (!series.isEnabled() || series.getValue() == null) continue;
            total += series.getValue().doubleValue();
        }
        double startAngle = ((PieStyler)this.pieStyler).getStartAngleInDegrees() + 90.0;
        this.paintSlices(g2, pieBounds, total, startAngle);
        this.paintLabels(g2, pieBounds, total, startAngle);
        this.paintSum(g2, pieBounds, total);
    }

    private void paintSlices(Graphics2D g2, Rectangle2D pieBounds, double total, double startAngle) {
        double borderAngle = startAngle;
        Map map = this.chart.getSeriesMap();
        double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0;
        double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0;
        for (PieSeries series : map.values()) {
            Shape toolTipShape;
            if (!series.isEnabled() || series.getValue() == null) continue;
            Number y = series.getValue();
            double arcAngle = y.doubleValue() * 360.0 / total;
            g2.setColor(series.getFillColor());
            if (PieStyler.ClockwiseDirectionType.CLOCKWISE == ((PieStyler)this.pieStyler).getClockwiseDirectionType()) {
                startAngle -= arcAngle;
            }
            if (PieSeries.PieSeriesRenderStyle.Pie == series.getChartPieSeriesRenderStyle()) {
                Arc2D.Double pieShape = new Arc2D.Double(pieBounds.getX(), pieBounds.getY(), pieBounds.getWidth(), pieBounds.getHeight(), startAngle, arcAngle, 2);
                g2.fill(pieShape);
                g2.setColor(((Styler)this.pieStyler).getPlotBackgroundColor());
                g2.draw(pieShape);
                toolTipShape = pieShape;
            } else {
                Shape donutSlice = PlotContent_Pie.getDonutSliceShape(pieBounds, ((PieStyler)this.pieStyler).getDonutThickness(), startAngle, arcAngle);
                g2.fill(donutSlice);
                g2.setColor(((Styler)this.pieStyler).getPlotBackgroundColor());
                g2.draw(donutSlice);
                toolTipShape = donutSlice;
            }
            if (((Styler)this.pieStyler).isToolTipsEnabled()) {
                String toolTipLabel = series.getName() + " (" + this.df.format(y) + ")";
                double angle = arcAngle + startAngle - arcAngle / 2.0;
                double xOffset = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double yOffset = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                this.toolTips.addData(toolTipShape, xOffset, yOffset + 10.0, 0.0, toolTipLabel);
            }
            if (PieStyler.ClockwiseDirectionType.COUNTER_CLOCKWISE != ((PieStyler)this.pieStyler).getClockwiseDirectionType()) continue;
            startAngle += arcAngle;
        }
        float borderWidth = ((PieStyler)this.chart.getStyler()).getSliceBorderWidth();
        if (borderWidth > 0.0f) {
            Color color = ((Styler)this.pieStyler).getPlotBackgroundColor();
            g2.setColor(color);
            for (PieSeries series : map.values()) {
                if (!series.isEnabled() || series.getValue() == null) continue;
                Number y = series.getValue();
                double arcAngle = y.doubleValue() * 360.0 / total;
                double xBorder = pieBounds.getWidth() / 2.0 * Math.cos(Math.toRadians(borderAngle += arcAngle));
                double yBorder = pieBounds.getHeight() / 2.0 * Math.sin(Math.toRadians(borderAngle));
                xBorder = xBorder + pieBounds.getX() + pieBounds.getWidth() / 2.0;
                yBorder = pieBounds.getY() + pieBounds.getHeight() / 2.0 - yBorder;
                Line2D.Double line = new Line2D.Double(xCenter, yCenter, xBorder, yBorder);
                g2.setStroke(new BasicStroke(borderWidth, 1, 1));
                g2.draw(line);
            }
        }
    }

    private void paintLabels(Graphics2D g2, Rectangle2D pieBounds, double total, double startAngle) {
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            if (!series.isEnabled() || series.getValue() == null) continue;
            Number y = series.getValue();
            double arcAngle = y.doubleValue() * 360.0 / total;
            if (PieStyler.ClockwiseDirectionType.CLOCKWISE == ((PieStyler)this.pieStyler).getClockwiseDirectionType()) {
                startAngle -= arcAngle;
            }
            if (((PieStyler)this.pieStyler).isLabelsVisible()) {
                String label = "";
                if (((PieStyler)this.pieStyler).getLabelType() == PieStyler.LabelType.Value) {
                    label = ((Styler)this.pieStyler).getDecimalPattern() != null ? this.df.format(y) : y.toString();
                } else if (((PieStyler)this.pieStyler).getLabelType() == PieStyler.LabelType.Name) {
                    label = series.getName();
                } else if (((PieStyler)this.pieStyler).getLabelType() == PieStyler.LabelType.NameAndPercentage) {
                    double percentage = y.doubleValue() / total * 100.0;
                    label = series.getName() + " (" + this.df.format(percentage) + "%)";
                } else if (((PieStyler)this.pieStyler).getLabelType() == PieStyler.LabelType.Percentage) {
                    double percentage = y.doubleValue() / total * 100.0;
                    label = this.df.format(percentage) + "%";
                } else if (((PieStyler)this.pieStyler).getLabelType() == PieStyler.LabelType.NameAndValue) {
                    label = ((Styler)this.pieStyler).getDecimalPattern() != null ? series.getName() + " (" + this.df.format(y) + ")" : series.getName() + " (" + y.toString() + ")";
                }
                TextLayout textLayout = new TextLayout(label, ((PieStyler)this.pieStyler).getLabelsFont(), new FontRenderContext(null, true, false));
                Rectangle2D labelRectangle = textLayout.getBounds();
                double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0 - labelRectangle.getWidth() / 2.0;
                double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0 + labelRectangle.getHeight() / 2.0;
                double angle = arcAngle + startAngle - arcAngle / 2.0;
                double xOffset = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double yOffset = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                Shape shape = textLayout.getOutline(null);
                Rectangle2D labelBounds = shape.getBounds2D();
                double labelWidth = labelBounds.getWidth();
                double labelHeight = labelBounds.getHeight();
                double xOffset1 = xCenter + Math.cos(Math.toRadians(startAngle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double yOffset1 = yCenter - Math.sin(Math.toRadians(startAngle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double xOffset2 = xCenter + Math.cos(Math.toRadians(arcAngle + startAngle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double yOffset2 = yCenter - Math.sin(Math.toRadians(arcAngle + startAngle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getLabelsDistance());
                double xDiff = Math.abs(xOffset1 - xOffset2);
                double yDiff = Math.abs(yOffset1 - yOffset2);
                boolean labelWillFit = false;
                if (xDiff >= yDiff) {
                    if (labelWidth < xDiff) {
                        labelWillFit = true;
                    }
                } else if (xDiff <= yDiff && labelHeight < yDiff) {
                    labelWillFit = true;
                }
                if (((PieStyler)this.pieStyler).isForceAllLabelsVisible() || labelWillFit) {
                    if (((PieStyler)this.pieStyler).isLabelsFontColorAutomaticEnabled()) {
                        g2.setColor(((PieStyler)this.pieStyler).getLabelsFontColor(series.getFillColor()));
                    } else {
                        g2.setColor(((PieStyler)this.pieStyler).getLabelsFontColor());
                    }
                    g2.setFont(((PieStyler)this.pieStyler).getLabelsFont());
                    AffineTransform orig = g2.getTransform();
                    AffineTransform at = new AffineTransform();
                    if (((PieStyler)this.pieStyler).getLabelsDistance() <= 1.0) {
                        at.translate(xOffset, yOffset);
                    } else {
                        xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0;
                        yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0;
                        double endPoint = 3.0 - ((PieStyler)this.pieStyler).getLabelsDistance();
                        double xOffsetStart = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.01);
                        double xOffsetEnd = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / endPoint);
                        double yOffsetStart = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.01);
                        double yOffsetEnd = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / endPoint);
                        g2.setStroke(new BasicStroke(2.0f, 0, 0));
                        Line2D.Double line = new Line2D.Double(xOffsetStart, yOffsetStart, xOffsetEnd, yOffsetEnd);
                        g2.draw(line);
                        at.translate(xOffset - Math.sin(Math.toRadians(angle - 90.0)) * labelWidth / 2.0 + 3.0, yOffset);
                    }
                    g2.transform(at);
                    g2.fill(shape);
                    g2.setTransform(orig);
                }
            }
            if (PieStyler.ClockwiseDirectionType.COUNTER_CLOCKWISE != ((PieStyler)this.pieStyler).getClockwiseDirectionType()) continue;
            startAngle += arcAngle;
        }
    }

    private void paintSum(Graphics2D g2, Rectangle2D pieBounds, double total) {
        if (((PieStyler)this.pieStyler).isSumVisible()) {
            String label = ((PieStyler)this.pieStyler).getSumFormat() == null || ((PieStyler)this.pieStyler).getSumFormat().isEmpty() ? this.df.format(total) : String.format(((PieStyler)this.pieStyler).getSumFormat(), total);
            TextLayout textLayout = new TextLayout(label, ((PieStyler)this.pieStyler).getSumFont(), new FontRenderContext(null, true, false));
            Shape shape = textLayout.getOutline(null);
            g2.setColor(((Styler)this.pieStyler).getChartFontColor());
            Rectangle2D labelRectangle = textLayout.getBounds();
            double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0 - labelRectangle.getWidth() / 2.0;
            double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0 + labelRectangle.getHeight() / 2.0;
            AffineTransform orig = g2.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate(xCenter, yCenter);
            g2.transform(at);
            g2.fill(shape);
            g2.setTransform(orig);
        }
    }
}

