/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_;
import org.knowm.xchart.internal.chartpart.RenderableSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;

public class Legend_Pie<ST extends Styler, S extends Series>
extends Legend_<ST, S> {
    public Legend_Pie(Chart<ST, S> chart) {
        super(chart);
    }

    @Override
    public void doPaint(Graphics2D g2) {
        double startx = this.xOffset + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (Series series : map.values()) {
            if (!series.isShowInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, 20);
            Rectangle2D.Double rectSmall = new Rectangle2D.Double(startx, starty, 20.0, 20.0);
            g2.setColor(series.getFillColor());
            g2.fill(rectSmall);
            double x = startx + 20.0 + (double)((Styler)this.chart.getStyler()).getLegendPadding();
            this.paintSeriesText(g2, seriesTextBounds, 20, x, starty);
            if (((Styler)this.chart.getStyler()).getLegendLayout() == Styler.LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((Styler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = 20;
            if (series.getLegendRenderType() == RenderableSeries.LegendRenderType.Line) {
                markerWidth = ((Styler)this.chart.getStyler()).getLegendSeriesLineLength();
            }
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((Styler)this.chart.getStyler()).getLegendPadding());
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return 20.0;
    }
}

